/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.KeyState;
import com.persistit.Management;
import com.persistit.ValueState;
import com.persistit.ui.AbstractInspector;
import com.persistit.ui.AdminUI;
import com.persistit.ui.InspectorPanel;
import com.persistit.ui.ValueInspectorTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

class InspectorObjectPanel
extends AbstractInspector {
    private static final long serialVersionUID = -6373326253805580551L;
    private DefaultTreeModel _treeModel;
    private JTree _tree;
    private JTextArea _textArea;

    InspectorObjectPanel() {
    }

    @Override
    protected void setup(AdminUI ui, InspectorPanel host) {
        super.setup(ui, host);
        this._treeModel = new DefaultTreeModel(null);
        this._tree = new JTree(this._treeModel);
        this.setLayout(new BorderLayout());
        ui.registerTextComponent(this._tree);
        this._textArea = new JTextArea(0, 0);
        ui.registerTextComponent(this._textArea);
        JScrollPane treeScrollPane = new JScrollPane(this._tree, 20, 30);
        treeScrollPane.setPreferredSize(new Dimension(500, 100));
        treeScrollPane.setBorder(null);
        final JScrollPane textScrollPane = new JScrollPane(this._textArea, 20, 30);
        textScrollPane.setPreferredSize(new Dimension(500, 0));
        textScrollPane.setBorder(null);
        JSplitPane splitPane = new JSplitPane(0, treeScrollPane, textScrollPane);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(Integer.MAX_VALUE);
        this._tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                final ValueInspectorTreeNode node = (ValueInspectorTreeNode)tse.getPath().getLastPathComponent();
                if (node != null && tse.isAddedPath()) {
                    if (node.getEvalString() == null && textScrollPane.getHeight() != 0) {
                        InspectorObjectPanel.this._textArea.setText(null);
                        node.evalString(new Runnable(){

                            @Override
                            public void run() {
                                InspectorObjectPanel.this._textArea.setText(node.getEvalString());
                            }
                        });
                    } else {
                        InspectorObjectPanel.this._textArea.setText(node.getEvalString());
                    }
                }
            }
        });
        this.add((Component)splitPane, "Center");
    }

    @Override
    protected void refreshed() {
        Management management = this._adminUI.getManagement();
        Management.LogicalRecord lr = this._host.getLogicalRecord();
        if (management == null || lr == null) {
            this.nullMessage();
        } else if (this._host.isShowValue()) {
            ValueState valueState = lr.getValueState();
            try {
                Object[] results = management.decodeValueObjects(valueState, null);
                ValueInspectorTreeNode root = new ValueInspectorTreeNode(null, results, "Value", Object[].class);
                this._treeModel.setRoot(root);
                this._textArea.setText(null);
            }
            catch (Exception e) {
                this._host.setLogicalRecord(null);
                this._adminUI.postException(e);
            }
        } else {
            KeyState keyState = lr.getKeyState();
            try {
                Object[] results = management.decodeKeyObjects(keyState, null);
                ValueInspectorTreeNode root = new ValueInspectorTreeNode(null, results, "KeySegments", Object[].class);
                this._treeModel.setRoot(root);
            }
            catch (Exception e) {
                this._host.setLogicalRecord(null);
                this._adminUI.postException(e);
            }
        }
    }

    private Object getObject(ValueState vs) {
        return null;
    }

    void nullMessage() {
        this._treeModel.setRoot(null);
    }

    @Override
    protected void waiting() {
        this._treeModel.setRoot(new ValueInspectorTreeNode(null, this._adminUI.getWaitingMessage(), "", String.class));
    }

    class RemoteClassLoader
    extends ClassLoader {
        RemoteClassLoader() {
            super(RemoteClassLoader.class.getClassLoader());
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.startsWith("com.persistit")) {
                return super.loadClass(name, resolve);
            }
            Class clazz = this.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (InspectorObjectPanel.this._adminUI.getManagement() != null) {
                try {
                    System.out.println("RemoteClassLoader is attempting to load class " + name);
                    clazz = InspectorObjectPanel.this._adminUI.getManagement().getRemoteClass(name);
                }
                catch (RemoteException re) {
                    InspectorObjectPanel.this._adminUI.postException(re);
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }
    }
}

