/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AbstractInspector;
import com.persistit.ui.AdminUI;
import com.persistit.ui.InspectorPanel;
import com.persistit.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class InspectorHexPanel
extends AbstractInspector {
    private JTextArea _textArea;

    InspectorHexPanel() {
    }

    @Override
    protected void setup(AdminUI ui, InspectorPanel host) {
        super.setup(ui, host);
        this.setLayout(new BorderLayout());
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this._textArea.setFont(this._adminUI.getFixedFont());
        JScrollPane scrollPane = new JScrollPane(this._textArea, 20, 30);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    protected void refreshed() {
        Management.LogicalRecord lr = this._host.getLogicalRecord();
        if (lr == null) {
            this.nullData();
        } else if (this._host.isShowValue()) {
            this._textArea.setText(Util.dump(lr.getValueState()));
        } else {
            this._textArea.setText(Util.dump(this._host.getLogicalRecord().getKeyState()));
        }
    }

    @Override
    protected void nullData() {
        this._textArea.setText(this._adminUI.getNullMessage());
    }

    @Override
    protected void waiting() {
        this._textArea.setText(this._adminUI.getWaitingMessage());
    }

    protected void setDefaultButton() {
    }

    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
    }
}

