/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogMessage;
import com.persistit.logging.PersistitLogger;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class LogBase {
    public static final String RECURRING = "%s (%,d similar occurrences in %,d seconds)";
    @Message(value="INFO|Akiban Persistit %s")
    public final PersistitLogMessage.LogItem copyright = PersistitLogMessage.empty();
    @Message(value="DEBUG|Log started %tc")
    public final PersistitLogMessage.LogItem start = PersistitLogMessage.empty();
    @Message(value="DEBUG|Log ended %tc")
    public final PersistitLogMessage.LogItem end = PersistitLogMessage.empty();
    @Message(value="ERROR|%s")
    public final PersistitLogMessage.LogItem exception = PersistitLogMessage.empty();
    @Message(value="WARNING|Configuration parameter error %s}")
    public final PersistitLogMessage.LogItem configurationError = PersistitLogMessage.empty();
    @Message(value="INFO| Allocating %,d buffers of size %,d bytes")
    public final PersistitLogMessage.LogItem allocateBuffers = PersistitLogMessage.empty();
    @Message(value="INFO|Opening volume %s (%s)")
    public final PersistitLogMessage.LogItem openVolume = PersistitLogMessage.empty();
    @Message(value="ERROR|Journal write failure %s in %s at offset %,d")
    public final PersistitLogMessage.LogItem journalWriteError = PersistitLogMessage.empty();
    @Message(value="INFO|Recovery done: %,d retained pages, %,d committed transactions, %,d errors")
    public final PersistitLogMessage.LogItem recoveryDone = PersistitLogMessage.empty();
    @Message(value="ERROR|Recovery failed due to %s - the journal needs to be repaired or discarded")
    public final PersistitLogMessage.LogItem recoveryFailure = PersistitLogMessage.empty();
    @Message(value="DEBUG|Valid recovery keystone file %s will be recovered to %,d")
    public final PersistitLogMessage.LogItem recoveryKeystone = PersistitLogMessage.empty();
    @Message(value="DEBUG|Valid recovery member file %s")
    public final PersistitLogMessage.LogItem recoveryValidFile = PersistitLogMessage.empty();
    @Message(value="TRACE|Processing Recovery Record type %s at %s %s with timestamp %,d")
    public final PersistitLogMessage.LogItem recoveryRecord = PersistitLogMessage.empty();
    @Message(value="INFO|Recovery plan: will recover %,d pages and %,d committed transactions; will discard %,d uncommitted transactions")
    public final PersistitLogMessage.LogItem recoveryPlan = PersistitLogMessage.empty();
    @Message(value="INFO|Recovery progress: %,d committed transactions applied, %,d uncommitted transactions rolled back, %,d remaining ")
    public final PersistitLogMessage.LogItem recoveryProgress = PersistitLogMessage.empty();
    @Message(value="WARNING|Recovery exception %s at transaction %s")
    public final PersistitLogMessage.LogItem recoveryException = PersistitLogMessage.empty();
    @Message(value="DEBUG|%s proposed")
    public final PersistitLogMessage.LogItem checkpointProposed = PersistitLogMessage.empty();
    @Message(value="DEBUG|%s written at %,d")
    public final PersistitLogMessage.LogItem checkpointWritten = PersistitLogMessage.empty();
    @Message(value="DEBUG|%s recovered at %s")
    public final PersistitLogMessage.LogItem checkpointRecovered = PersistitLogMessage.empty();
    @Message(value="ERROR|%s while beginning transaction %s")
    public final PersistitLogMessage.LogItem txnBeginException = PersistitLogMessage.empty();
    @Message(value="ERROR|%s while committing transaction %s")
    public final PersistitLogMessage.LogItem txnCommitException = PersistitLogMessage.empty();
    @Message(value="ERROR|%s while ending transaction %s")
    public final PersistitLogMessage.LogItem txnEndException = PersistitLogMessage.empty();
    @Message(value="ERROR|%s while rolling back transaction %s")
    public final PersistitLogMessage.LogItem txnRollbackException = PersistitLogMessage.empty();
    @Message(value="WARNING|Transaction neither committed nor rolled back %s")
    public final PersistitLogMessage.LogItem txnNotCommitted = PersistitLogMessage.empty();
    @Message(value="WARNING|Transaction abandoned %s")
    public final PersistitLogMessage.LogItem txnAbandoned = PersistitLogMessage.empty();
    @Message(value="DEBUG|Starting AdminUI")
    public final PersistitLogMessage.LogItem startAdminUI = PersistitLogMessage.empty();
    @Message(value="DEBUG|MXBean %s is registered")
    public final PersistitLogMessage.LogItem mbeanRegistered = PersistitLogMessage.empty();
    @Message(value="DEBUG|MXBean %s is unregistered")
    public final PersistitLogMessage.LogItem mbeanUnregistered = PersistitLogMessage.empty();
    @Message(value="WARNING|Failure while registering MXBean: %s")
    public final PersistitLogMessage.LogItem mbeanException = PersistitLogMessage.empty();
    @Message(value="TRACE|Added new garbage chain leftPage=%,d, rightPage=%,d %s")
    public final PersistitLogMessage.LogItem newGarbageChain = PersistitLogMessage.empty();
    @Message(value="TRACE|No room in garbage page for new garbage chain leftPage=%,d, rightPage=%,d, garbageBuffer=%s")
    public final PersistitLogMessage.LogItem garbagePageFull = PersistitLogMessage.empty();
    @Message(value="TRACE|Created new garbageRoot page %s")
    public final PersistitLogMessage.LogItem newGarbageRoot = PersistitLogMessage.empty();
    @Message(value="TRACE|GarbagePage %,d is exhausted, will be allocated and new garbageRoot is %,d %s")
    public final PersistitLogMessage.LogItem garbagePageExhausted = PersistitLogMessage.empty();
    @Message(value="TRACE|Allocated allocPage=%,d from garbageChain %s")
    public final PersistitLogMessage.LogItem allocateFromGarbageChain = PersistitLogMessage.empty();
    @Message(value="TRACE|Removing garbage chain %s because rightPage=%,d == nextGarbagePage")
    public final PersistitLogMessage.LogItem garbageChainDone = PersistitLogMessage.empty();
    @Message(value="TRACE|Updating garbage chain %s new leftPage=%,d, rightPage=%,d")
    public final PersistitLogMessage.LogItem garbageChainUpdate = PersistitLogMessage.empty();
    @Message(value="ERROR|IOException %s while reading volume %s page %,d into buffer # %,d")
    public final PersistitLogMessage.LogItem readException = PersistitLogMessage.empty();
    @Message(value="ERROR|Exception %s while writing volume %s page %,d")
    public final PersistitLogMessage.LogItem writeException = PersistitLogMessage.empty();
    @Message(value="WARNING|Missing volume %s referenced at journal address %,d")
    public final PersistitLogMessage.LogItem missingVolume = PersistitLogMessage.empty();
    @Message(value="WARNING|Lost page %,d from missing volume %s referenced at journal address %,d")
    public final PersistitLogMessage.LogItem lostPageFromMissingVolume = PersistitLogMessage.empty();
    @Message(value="WARNING|Exception %s while copying volume %s page %,d from journal address %,d")
    public final PersistitLogMessage.LogItem copyException = PersistitLogMessage.empty();
    @Message(value="ERROR|IOException %s while creating temporary volume %s")
    public final PersistitLogMessage.LogItem tempVolumeCreateException = PersistitLogMessage.empty();
    @Message(value="DEBUG|Extending %s: old length=%,d, new length=%,d")
    public final PersistitLogMessage.LogItem extendNormal = PersistitLogMessage.empty();
    @Message(value="DEBUG|Volume %s is already larger: has length=%,d, proposed new length=%,d")
    public final PersistitLogMessage.LogItem extendLonger = PersistitLogMessage.empty();
    @Message(value="ERROR|IOException %s while extending %s: old length=%,d, new length=%,d")
    public final PersistitLogMessage.LogItem extendException = PersistitLogMessage.empty();
    @Message(value="DEBUG|Management RMI Server registered on %s")
    public final PersistitLogMessage.LogItem rmiServerRegistered = PersistitLogMessage.empty();
    @Message(value="DEBUG|Management RMI Server unregistered on %s")
    public final PersistitLogMessage.LogItem rmiServerUnregister = PersistitLogMessage.empty();
    @Message(value="WARNING|Exception while registering management RMI Server %s %s")
    public final PersistitLogMessage.LogItem rmiRegisterException = PersistitLogMessage.empty();
    @Message(value="WARNING|Exception while unregistering management RMI Server %s %s")
    public final PersistitLogMessage.LogItem rmiUnregisterException = PersistitLogMessage.empty();
    @Message(value="WARNING|Unindexed page %,d in volume=%s tree=%s - run IntegrityCheck to repair")
    public final PersistitLogMessage.LogItem unindexedPage = PersistitLogMessage.empty();
    @Message(value="INFO|Waited %,d seconds for IO operations to finish")
    public final PersistitLogMessage.LogItem waitForClose = PersistitLogMessage.empty();
    @Message(value="ERROR|Checkpoint %s written to journal before dirty page %d")
    public final PersistitLogMessage.LogItem lateWrite = PersistitLogMessage.empty();
    @Message(value="WARNING|%s has %,d stranded pages")
    public final PersistitLogMessage.LogItem strandedPages = PersistitLogMessage.empty();
    @Message(value="ERROR|BTree structure error %s")
    public final PersistitLogMessage.LogItem corruptVolume = PersistitLogMessage.empty();
    @Message(value="WARNING|%s while flushing non-essential administrative data")
    public final PersistitLogMessage.LogItem adminFlushException = PersistitLogMessage.empty();
    @Message(value="WARNING|%s while performing cleanup action %s")
    public final PersistitLogMessage.LogItem cleanupException = PersistitLogMessage.empty();
    @Message(value="WARNING|%s while pruning transaction record %s")
    public final PersistitLogMessage.LogItem pruneException = PersistitLogMessage.empty();
    @Message(value="WARNING|Transaction %s pruning incomplete at %s after rollback")
    public final PersistitLogMessage.LogItem pruningIncomplete = PersistitLogMessage.empty();
    @Message(value="WARNING|Crash retried %,d times on %s")
    public final PersistitLogMessage.LogItem crashRetry = PersistitLogMessage.empty();
    @Message(value="WARNING|Journal flush operation took %,dms last %,d cycles average is %,dms")
    public final PersistitLogMessage.LogItem longJournalIO = PersistitLogMessage.empty();
    @Message(value="INFO|Normal journal file count %,d")
    public final PersistitLogMessage.LogItem normalJournalFileCount = PersistitLogMessage.empty();
    @Message(value="WARNING|Too many journal files %,d")
    public final PersistitLogMessage.LogItem tooManyJournalFilesWarning = PersistitLogMessage.empty();
    @Message(value="ERROR|Too many journal files %,d")
    public final PersistitLogMessage.LogItem tooManyJournalFilesError = PersistitLogMessage.empty();
    @Message(value="INFO|Preloading buffer pool inventory recorded at %tc")
    public final PersistitLogMessage.LogItem bufferInventoryLoad = PersistitLogMessage.empty();
    @Message(value="INFO|Preloaded %,d of %,d buffers in %,d seconds")
    public final PersistitLogMessage.LogItem bufferInventoryProgress = PersistitLogMessage.empty();
    @Message(value="WARNING|Exception while writing buffer pool inventory %s")
    public final PersistitLogMessage.LogItem bufferInventoryException = PersistitLogMessage.empty();
    @Message(value="WARNING|Thread %s interrupted due to shutdown")
    public final PersistitLogMessage.LogItem interruptedAtClose = PersistitLogMessage.empty();

    public static String recurring(String message, int count, long duration) {
        return String.format(RECURRING, message, count, duration);
    }

    public void configure(PersistitLogger logger) {
        for (Field field : this.getClass().getDeclaredFields()) {
            Message annotation = field.getAnnotation(Message.class);
            if (annotation == null) continue;
            try {
                String[] v = annotation.value().split("\\|");
                PersistitLevel level = PersistitLevel.valueOf(v[0]);
                String message = v[1];
                PersistitLogMessage.LogItem logItem = (PersistitLogMessage.LogItem)field.get(this);
                logItem.configure(logger, level, message);
            }
            catch (Exception e) {
                System.err.printf("%s on field %s with annotation %s", e, field, annotation);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Message {
        public String value();
    }
}

