/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Configuration;
import com.persistit.Volume;
import com.persistit.exception.InvalidVolumeSpecificationException;
import com.persistit.util.Util;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class VolumeSpecification {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ALIAS = "alias";
    private static final String ATTR_CREATE = "create";
    private static final String ATTR_READONLY = "readOnly";
    private static final String ATTR_CREATEONLY = "createOnly";
    private static final String ATTR_PAGE_SIZE = "pageSize";
    private static final String ATTR_INITIAL_SIZE = "initialSize";
    private static final String ATTR_EXTENSION_SIZE = "extensionSize";
    private static final String ATTR_MAXIMUM_SIZE = "maximumSize";
    private static final String ATTR_INITIAL_PAGES = "initialPages";
    private static final String ATTR_EXTENSION_PAGES = "extensionPages";
    private static final String ATTR_MAXIMUM_PAGES = "maximumPages";
    private String path;
    private String name = null;
    private boolean readOnly = false;
    private boolean create = false;
    private boolean createOnly = false;
    private boolean aliased = false;
    private int pageSize = -1;
    private int version = -1;
    private long id = 0L;
    private long initialPages = -1L;
    private long extensionPages = -1L;
    private long maximumPages = -1L;
    private long initialSize = -1L;
    private long extensionSize = -1L;
    private long maximumSize = -1L;

    public static String nameFromFile(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        return p < 1 ? name : name.substring(0, p);
    }

    public VolumeSpecification(String path, String name, int pageSize, long initialPages, long maximumPages, long extensionPages, boolean create, boolean createOnly, boolean readOnly) {
        this.path = path;
        if (name == null) {
            this.name = VolumeSpecification.nameFromFile(new File(path));
        } else {
            this.setName(name);
        }
        this.pageSize = pageSize;
        this.initialPages = initialPages;
        this.maximumPages = maximumPages;
        this.extensionPages = extensionPages;
        this.create = create;
        this.createOnly = createOnly;
        this.readOnly = readOnly;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VolumeSpecification(String specification) throws InvalidVolumeSpecificationException {
        StringTokenizer mainTokenizer = new StringTokenizer(specification, ",");
        try {
            this.path = mainTokenizer.nextToken().trim();
            this.name = VolumeSpecification.nameFromFile(new File(this.path));
            while (mainTokenizer.hasMoreTokens()) {
                String valueString;
                String token = mainTokenizer.nextToken().trim();
                StringTokenizer innerTokenizer = new StringTokenizer(token, ":");
                String attr = innerTokenizer.nextToken().trim();
                if (ATTR_READONLY.equals(attr)) {
                    this.readOnly = true;
                    continue;
                }
                if (ATTR_CREATE.equals(attr)) {
                    this.create = true;
                    continue;
                }
                if (ATTR_CREATEONLY.equals(attr)) {
                    this.createOnly = true;
                    continue;
                }
                if (ATTR_NAME.equals(attr) || ATTR_ALIAS.equals(attr)) {
                    valueString = innerTokenizer.nextToken().trim();
                    if (valueString == null || valueString.isEmpty()) continue;
                    this.setName(valueString);
                    continue;
                }
                valueString = innerTokenizer.nextToken().trim();
                boolean bad = false;
                long value = Configuration.parseLongProperty(attr, valueString);
                if (ATTR_PAGE_SIZE.equals(attr)) {
                    if (value >= Integer.MAX_VALUE || value <= 0L || !Volume.isValidPageSize((int)value)) throw new InvalidVolumeSpecificationException("Invalid pageSize " + specification);
                    this.pageSize = (int)value;
                } else if (ATTR_INITIAL_PAGES.equals(attr)) {
                    this.initialPages = value;
                } else if (ATTR_EXTENSION_PAGES.equals(attr)) {
                    this.extensionPages = value;
                } else if (ATTR_MAXIMUM_PAGES.equals(attr)) {
                    this.maximumPages = value;
                } else if (ATTR_INITIAL_SIZE.equals(attr)) {
                    this.initialSize = value;
                } else if (ATTR_EXTENSION_SIZE.equals(attr)) {
                    this.extensionSize = value;
                } else if (ATTR_MAXIMUM_SIZE.equals(attr)) {
                    this.maximumSize = value;
                } else {
                    bad = true;
                }
                if (!bad && !innerTokenizer.hasMoreTokens()) continue;
                throw new InvalidVolumeSpecificationException("Unknown attribute " + attr + " in " + specification);
            }
            int n = 0;
            if (this.readOnly) {
                ++n;
            }
            if (this.create) {
                ++n;
            }
            if (this.createOnly) {
                ++n;
            }
            if (n > 1) {
                throw new InvalidVolumeSpecificationException(specification + ": readOnly, create and createOnly " + "attributes are mutually exclusive");
            }
            if (this.pageSize > 0) {
                if (this.initialPages == -1L && this.initialSize > 0L) {
                    this.initialPages = (this.initialSize + (long)(this.pageSize - 1)) / (long)this.pageSize;
                }
                if (this.extensionPages == -1L && this.extensionSize > 0L) {
                    this.extensionPages = (this.extensionSize + (long)(this.pageSize - 1)) / (long)this.pageSize;
                }
                if (this.maximumPages == -1L && this.maximumSize > 0L) {
                    this.maximumPages = (this.maximumSize + (long)(this.pageSize - 1)) / (long)this.pageSize;
                }
            }
            if (this.maximumPages <= 0L) {
                this.maximumPages = this.initialPages;
            }
            if (!this.create && !this.createOnly) return;
            if (this.initialPages < 1L || this.initialPages > Long.MAX_VALUE / (long)this.pageSize) {
                throw new InvalidVolumeSpecificationException("Invalid initial page count: " + this.initialPages);
            }
            if (this.extensionPages < 0L || this.extensionPages > Long.MAX_VALUE / (long)this.pageSize) {
                throw new InvalidVolumeSpecificationException("Invalid extension page count: " + this.extensionPages);
            }
            if (this.maximumPages >= this.initialPages && this.maximumPages <= Long.MAX_VALUE / (long)this.pageSize) return;
            throw new InvalidVolumeSpecificationException("Invalid maximum page count: " + this.maximumPages);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidVolumeSpecificationException(specification + ": invalid number");
        }
        catch (NoSuchElementException nste) {
            throw new InvalidVolumeSpecificationException(specification + ": " + nste);
        }
    }

    public void setPageSize(int value) throws InvalidVolumeSpecificationException {
        if (!Volume.isValidPageSize(value)) {
            throw new InvalidVolumeSpecificationException("Invalid pageSize " + value);
        }
        if (this.pageSize != value && this.pageSize != -1) {
            throw new InvalidVolumeSpecificationException("Mismatched volume pageSize " + value + " for " + this);
        }
        this.pageSize = value;
    }

    public void setVersion(int value) throws InvalidVolumeSpecificationException {
        if (this.version != value && this.version != -1) {
            throw new InvalidVolumeSpecificationException("Mismatched volume version " + value + " for " + this);
        }
        this.version = value;
    }

    public void setId(long value) throws InvalidVolumeSpecificationException {
        if (this.id != value && this.id != 0L) {
            throw new InvalidVolumeSpecificationException("Mismatched volume version " + value + " for " + this);
        }
        this.id = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public File getAbsoluteFile() {
        return new File(this.path).getAbsoluteFile();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.aliased = !VolumeSpecification.nameFromFile(new File(this.path)).equals(name);
        this.name = name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAliased() {
        return this.aliased;
    }

    public boolean isCreate() {
        return this.create || this.createOnly;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isCreateOnly() {
        return this.createOnly;
    }

    public void setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getInitialPages() {
        return this.initialPages;
    }

    void setInitialPages(long initialPages) {
        this.initialSize = this.sizeFromPages(initialPages);
        this.initialPages = initialPages;
    }

    public long getExtensionPages() {
        return this.extensionPages;
    }

    void setExtensionPages(long extensionPages) {
        this.extensionSize = this.sizeFromPages(extensionPages);
        this.extensionPages = extensionPages;
    }

    public long getMaximumPages() {
        return this.maximumPages;
    }

    void setMaximumPages(long maximumPages) {
        this.maximumSize = this.sizeFromPages(maximumPages);
        this.maximumPages = maximumPages;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(long initialSize) {
        this.initialPages = this.pagesFromSize(initialSize);
        this.initialSize = this.roundSize(initialSize);
    }

    public long getExtensionSize() {
        return this.extensionSize;
    }

    public void setExtensionSize(long extensionSize) {
        this.extensionPages = this.pagesFromSize(extensionSize);
        this.extensionSize = this.roundSize(extensionSize);
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(long maximumSize) {
        this.maximumPages = this.pagesFromSize(maximumSize);
        this.maximumSize = this.roundSize(maximumSize);
    }

    public int getVersion() {
        return this.version;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path);
        if (this.aliased) {
            sb.append(',').append(ATTR_NAME).append(':').append(this.name);
        }
        if (this.pageSize > 0) {
            sb.append(',').append(ATTR_PAGE_SIZE).append(':').append(this.pageSize);
        }
        this.appendSize(sb, ATTR_INITIAL_SIZE, ATTR_INITIAL_PAGES, this.initialSize, this.initialPages);
        this.appendSize(sb, ATTR_MAXIMUM_SIZE, ATTR_MAXIMUM_PAGES, this.maximumSize, this.maximumPages);
        this.appendSize(sb, ATTR_EXTENSION_SIZE, ATTR_EXTENSION_PAGES, this.extensionSize, this.extensionPages);
        if (this.readOnly) {
            sb.append(',').append(ATTR_READONLY);
        }
        if (this.createOnly) {
            sb.append(',').append(ATTR_CREATEONLY);
        } else if (this.create) {
            sb.append(',').append(ATTR_CREATE);
        }
        return sb.toString();
    }

    private void appendSize(StringBuilder sb, String sizeName, String pagesName, long size, long pages) {
        if (this.pageSize <= 0) {
            if (pages > 0L) {
                sb.append(',').append(pagesName).append(':').append(this.ds(pages));
            } else if (size > 0L) {
                sb.append(',').append(sizeName).append(':').append(this.ds(size));
            }
        } else if (pages > 0L) {
            sb.append(',').append(sizeName).append(':').append(this.ds(pages * (long)this.pageSize));
        } else if (size > 0L) {
            sb.append(',').append(sizeName).append(':').append(this.ds(size));
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof VolumeSpecification)) {
            return false;
        }
        VolumeSpecification v = (VolumeSpecification)object;
        return this.path.equals(v.path) && this.name.equals(v.name) && this.readOnly == v.readOnly && this.create == v.create && this.createOnly == v.createOnly && this.aliased == v.aliased && this.pageSize == v.pageSize && this.version == v.version && this.id == v.id && this.initialPages == v.initialPages && this.initialSize == v.initialSize && this.extensionPages == v.extensionPages && this.extensionSize == v.extensionSize && this.maximumPages == v.maximumPages && this.maximumSize == v.maximumSize;
    }

    private String ds(long s) {
        return Configuration.displayableLongValue(s);
    }

    public String summary() {
        return this.name + "(" + this.path + ")";
    }

    private long sizeFromPages(long pages) {
        Util.rangeCheck(pages, 0L, 0x1FFFFFFFFFFFFL);
        return this.pageSize > 0 ? pages * (long)this.pageSize : 0L;
    }

    private long pagesFromSize(long size) {
        Util.rangeCheck(size, 0L, Long.MAX_VALUE);
        return this.pageSize > 0 ? size / (long)this.pageSize : 0L;
    }

    private long roundSize(long size) {
        if (this.pageSize > 0) {
            return size / (long)this.pageSize * (long)this.pageSize;
        }
        return size;
    }
}

