/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.BufferPool;
import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.Tree;
import com.persistit.VolumeHeader;
import com.persistit.VolumeSpecification;
import com.persistit.VolumeStatistics;
import com.persistit.VolumeStorage;
import com.persistit.VolumeStorageL2;
import com.persistit.VolumeStorageT2;
import com.persistit.VolumeStorageV2;
import com.persistit.VolumeStructure;
import com.persistit.exception.BufferSizeUnavailableException;
import com.persistit.exception.InUseException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.ReadOnlyVolumeException;
import com.persistit.exception.TruncateVolumeException;
import com.persistit.exception.UnderSpecifiedVolumeException;
import com.persistit.exception.VolumeAlreadyExistsException;
import com.persistit.exception.VolumeClosedException;
import com.persistit.exception.VolumeNotFoundException;
import com.persistit.exception.WrongVolumeException;
import com.persistit.util.Util;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Volume {
    static final int LOCK_VOLUME_HANDLE = Integer.MAX_VALUE;
    static final String LOCK_VOLUME_NAME = "_lock";
    private final String _name;
    private long _id;
    private final AtomicBoolean _closing = new AtomicBoolean();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final AtomicInteger _handle = new AtomicInteger();
    private final AtomicReference<Object> _appCache = new AtomicReference();
    private VolumeSpecification _specification;
    private volatile VolumeStorage _storage;
    private volatile VolumeStatistics _statistics;
    private volatile VolumeStructure _structure;
    private static final long TEMP_VOLUME_ID_FOR_FIXUP_DETECTION = 12345L;
    private static final String TEMP_VOLUME_NAME_SUFFIX_FOR_FIXUP_DETECTION = "_temporary_volume";

    public static boolean isValidPageSize(int pageSize) {
        for (int b = 1024; b <= 16384; b *= 2) {
            if (b != pageSize) continue;
            return true;
        }
        return false;
    }

    static Volume createTemporaryVolume(Persistit persistit, int pageSize, File tempDirectory) throws PersistitException {
        Volume volume = new Volume(Thread.currentThread().getName() + TEMP_VOLUME_NAME_SUFFIX_FOR_FIXUP_DETECTION, 12345L);
        volume.openInternal(persistit, pageSize);
        volume._storage = new VolumeStorageT2(persistit, volume, tempDirectory);
        volume._storage.create();
        return volume;
    }

    static Volume createLockVolume(Persistit persistit, int pageSize, File tempDirectory) throws PersistitException {
        Volume volume = new Volume(LOCK_VOLUME_NAME, 0L);
        volume.setHandle(Integer.MAX_VALUE);
        volume.openInternal(persistit, pageSize);
        volume._storage = new VolumeStorageL2(persistit, volume, tempDirectory);
        volume._storage.create();
        return volume;
    }

    Volume(String name, long id) {
        this._name = name;
        this._id = id;
        this._specification = new VolumeSpecification(name);
    }

    Volume(VolumeSpecification specification) {
        this(specification.getName(), specification.getId());
        this._specification = specification;
    }

    private void checkNull(Object o, String delegate) {
        if (o == null) {
            throw new IllegalStateException(this + " has no " + delegate);
        }
    }

    private void checkClosing() throws VolumeClosedException {
        if (this._closing.get()) {
            throw new VolumeClosedException();
        }
    }

    VolumeSpecification getSpecification() {
        VolumeSpecification s = this._specification;
        this.checkNull(s, "VolumeSpecification");
        return s;
    }

    VolumeStorage getStorage() {
        VolumeStorage s = this._storage;
        this.checkNull(s, "VolumeStorage");
        return s;
    }

    VolumeStatistics getStatistics() {
        VolumeStatistics s = this._statistics;
        this.checkNull(s, "VolumeStatistics");
        return s;
    }

    VolumeStructure getStructure() {
        return this._structure;
    }

    void setSpecification(VolumeSpecification specification) {
        if (this._specification != null) {
            throw new IllegalStateException("Volume " + this + " already has a VolumeSpecification");
        }
        if (!specification.getName().equals(this._name) || specification.getId() != this._id && specification.getId() != 0L) {
            throw new IllegalStateException("Volume " + this + " is incompatible with " + specification);
        }
        this._specification = specification;
    }

    void overwriteSpecification(VolumeSpecification specification) {
        this._specification = null;
        this.setSpecification(specification);
    }

    void closing() {
        this._closing.set(true);
    }

    public void close() throws PersistitException {
        this.close(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws PersistitException {
        this.closing();
        long expiration = System.currentTimeMillis() + timeout;
        while (true) {
            VolumeStorage storage;
            if (!(storage = this.getStorage()).claim(true, timeout)) {
                throw new InUseException("Unable to acquire claim on " + this);
            }
            if (this._closed.get()) break;
            try {
                if (this.getStructure().getPool().invalidate(this)) {
                    this.getStructure().close();
                    this.getStorage().close();
                    this.getStatistics().reset();
                    this._closed.set(true);
                    break;
                }
            }
            finally {
                storage.release();
            }
            if (System.currentTimeMillis() >= expiration) {
                throw new InUseException("Unable invalidate all pages on " + this);
            }
            Util.sleep(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws PersistitException {
        if (this.isReadOnly()) {
            throw new ReadOnlyVolumeException();
        }
        if (!(this.isTemporary() || this.getSpecification().isCreate() || this.getSpecification().isCreateOnly())) {
            throw new TruncateVolumeException();
        }
        while (true) {
            if (this.getStorage().claim(true, 0L)) {
                try {
                    if (this.getStructure().getPool().invalidate(this)) {
                        this.getStructure().truncate();
                        this.getStorage().truncate();
                        this.getStatistics().reset();
                        break;
                    }
                }
                finally {
                    this.getStorage().release();
                }
            }
            Util.sleep(500L);
        }
    }

    public boolean delete() throws PersistitException {
        if (!this.isClosed()) {
            throw new IllegalStateException("Volume must be closed before deletion");
        }
        return this.getStorage().delete();
    }

    public String getPath() {
        return this.getStorage().getPath();
    }

    public File getAbsoluteFile() {
        return this.getSpecification().getAbsoluteFile();
    }

    public long getNextAvailablePage() {
        return this.getStorage().getNextAvailablePage();
    }

    public long getExtendedPageCount() {
        return this.getStorage().getExtentedPageCount();
    }

    BufferPool getPool() {
        return this.getStructure().getPool();
    }

    Tree getDirectoryTree() {
        return this.getStructure().getDirectoryTree();
    }

    boolean isTemporary() {
        if (this._storage == null) {
            return this._id == 12345L && this._name.endsWith(TEMP_VOLUME_NAME_SUFFIX_FOR_FIXUP_DETECTION);
        }
        return this.getStorage().isTemp();
    }

    boolean isLockVolume() {
        return this.getHandle() == Integer.MAX_VALUE;
    }

    public int getPageSize() {
        return this.getStructure().getPageSize();
    }

    public Tree getTree(String name, boolean createIfNecessary) throws PersistitException {
        this.checkClosing();
        return this.getStructure().getTree(name, createIfNecessary);
    }

    public String[] getTreeNames() throws PersistitException {
        this.checkClosing();
        return this.getStructure().getTreeNames();
    }

    Management.TreeInfo getTreeInfo(String name) {
        try {
            Tree tree = this.getTree(name, false);
            if (tree != null) {
                return new Management.TreeInfo(tree);
            }
            return null;
        }
        catch (PersistitException pe) {
            return null;
        }
    }

    public boolean isOpened() {
        return this._storage != null && this._storage.isOpened();
    }

    public boolean isClosed() {
        return this._closing.get();
    }

    public boolean isReadOnly() {
        return this.getStorage().isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(Persistit persistit) throws PersistitException {
        this.checkClosing();
        if (this._specification == null) {
            throw new IllegalStateException("Missing VolumeSpecification");
        }
        if (this._storage != null) {
            throw new IllegalStateException("This volume has already been opened");
        }
        if (this._specification.getPageSize() <= 0) {
            throw new UnderSpecifiedVolumeException(this.getName());
        }
        if (persistit.getBufferPool(this._specification.getPageSize()) == null) {
            throw new BufferSizeUnavailableException(this.getName());
        }
        boolean exists = VolumeHeader.verifyVolumeHeader(this._specification, persistit.getCurrentTimestamp());
        this._structure = new VolumeStructure(persistit, this, this._specification.getPageSize());
        this._storage = new VolumeStorageV2(persistit, this);
        this._statistics = new VolumeStatistics();
        boolean opened = false;
        try {
            if (exists) {
                if (this._specification.isCreateOnly()) {
                    throw new VolumeAlreadyExistsException(this._specification.getPath());
                }
                this._storage.open();
                opened = true;
            } else {
                if (!this._specification.isCreate()) {
                    throw new VolumeNotFoundException(this._specification.getPath());
                }
                this._storage.create();
                opened = true;
            }
        }
        finally {
            if (!opened) {
                this._structure = null;
                this._storage = null;
                this._statistics = null;
            }
        }
        persistit.addVolume(this);
    }

    private void openInternal(Persistit persistit, int pageSize) throws PersistitException {
        this.checkClosing();
        if (this._storage != null) {
            throw new IllegalStateException("This volume has already been opened");
        }
        if (persistit.getBufferPool(pageSize) == null) {
            throw new BufferSizeUnavailableException("There is no buffer pool for pages of size " + pageSize);
        }
        this._structure = new VolumeStructure(persistit, this, pageSize);
        this._statistics = new VolumeStatistics();
    }

    public String getName() {
        return this._name;
    }

    public long getId() {
        return this._id;
    }

    void setId(long id) {
        if (id != 0L && this._id != 0L && this._id != id) {
            throw new IllegalStateException("Volume " + this + " already has id=" + this._id);
        }
        this._id = id;
    }

    void verifyId(long id) throws WrongVolumeException {
        if (id != 0L && this._id != 0L && id != this._id) {
            throw new WrongVolumeException(this + "id " + this._id + " does not match expected id " + id);
        }
    }

    public void setAppCache(Object appCache) {
        this._appCache.set(appCache);
    }

    public Object getAppCache() {
        return this._appCache.get();
    }

    public int getHandle() {
        return this._handle.get();
    }

    int setHandle(int handle) {
        if (!this._handle.compareAndSet(0, handle)) {
            throw new IllegalStateException("Volume handle already set");
        }
        return handle;
    }

    void resetHandle() {
        this._handle.set(0);
    }

    public String toString() {
        VolumeSpecification specification = this._specification;
        if (specification != null) {
            return specification.summary();
        }
        return this._name;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Volume) {
            Volume volume = (Volume)o;
            return volume.getName().equals(this.getName()) && volume.getId() == this.getId();
        }
        return false;
    }
}

