/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.MVV;
import com.persistit.Value;

interface ValueHelper {
    public static final ValueHelper EMPTY_VALUE_WRITER = new ValueHelper(){

        @Override
        public int requiredLength(byte[] target, int targetOffset, int targetLength) {
            return 0;
        }

        @Override
        public int storeVersion(byte[] target, int targetOffset, int targetLength, int targetLimit) {
            return 0;
        }

        @Override
        public void saveValue(byte[] target, int targetOffset, int targetLength) {
        }

        @Override
        public long getPointerValue() {
            return 0L;
        }

        @Override
        public void setPointerValue(long poiner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMVV() {
            return false;
        }
    };

    public int requiredLength(byte[] var1, int var2, int var3);

    public int storeVersion(byte[] var1, int var2, int var3, int var4);

    public void saveValue(byte[] var1, int var2, int var3);

    public long getPointerValue();

    public void setPointerValue(long var1);

    public boolean isMVV();

    public static class MVVValueWriter
    implements ValueHelper {
        Value _value;
        Value _spareValue;
        long _version;

        void init(Value value, Value spareValue, long version) {
            this._value = value;
            this._spareValue = spareValue;
            this._version = version;
        }

        @Override
        public int storeVersion(byte[] target, int targetOffset, int targetLength, int targetLimit) {
            return MVV.storeVersion(target, targetOffset, targetLength, target.length, this._version, this._value.getEncodedBytes(), 0, this._value.getEncodedSize());
        }

        @Override
        public void saveValue(byte[] target, int targetOffset, int targetLength) {
        }

        @Override
        public int requiredLength(byte[] target, int targetOffset, int targetLength) {
            return MVV.exactRequiredLength(target, targetOffset, targetLength, this._version, this._value.getEncodedSize());
        }

        @Override
        public long getPointerValue() {
            return this._value.getPointerValue();
        }

        @Override
        public void setPointerValue(long pointer) {
            this._value.setPointerValue(pointer);
        }

        @Override
        public boolean isMVV() {
            return true;
        }
    }

    public static class RawValueWriter
    implements ValueHelper {
        Value _value;

        void init(Value value) {
            this._value = value;
        }

        @Override
        public int storeVersion(byte[] target, int targetOffset, int targetLength, int targetLimit) {
            System.arraycopy(this._value.getEncodedBytes(), 0, target, targetOffset, this._value.getEncodedSize());
            return this._value.getEncodedSize();
        }

        @Override
        public void saveValue(byte[] target, int targetOffset, int targetLength) {
        }

        @Override
        public int requiredLength(byte[] target, int targetOffset, int targetLength) {
            return this._value.getEncodedSize();
        }

        @Override
        public long getPointerValue() {
            return this._value.getPointerValue();
        }

        @Override
        public void setPointerValue(long pointer) {
            this._value.setPointerValue(pointer);
        }

        @Override
        public boolean isMVV() {
            return false;
        }
    }
}

