/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.AccumulatorState;
import com.persistit.Buffer;
import com.persistit.Persistit;
import com.persistit.SharedResource;
import com.persistit.TreeStatistics;
import com.persistit.Volume;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.PersistitException;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Tree
extends SharedResource {
    static final int MAX_SERIALIZED_SIZE = 512;
    static final int MAX_TREE_NAME_SIZE = 256;
    static final int MAX_ACCUMULATOR_COUNT = 64;
    private final String _name;
    private final Volume _volume;
    private volatile long _rootPageAddr;
    private volatile int _depth;
    private final AtomicLong _changeCount = new AtomicLong(0L);
    private final AtomicReference<Object> _appCache = new AtomicReference();
    private final AtomicInteger _handle = new AtomicInteger();
    private final Accumulator[] _accumulators = new Accumulator[64];
    private final TreeStatistics _treeStatistics = new TreeStatistics();

    Tree(Persistit persistit, Volume volume, String name) {
        super(persistit);
        int serializedLength = name.getBytes().length;
        if (serializedLength > 256) {
            throw new IllegalArgumentException("Tree name too long: " + name.length() + "(as " + serializedLength + " bytes)");
        }
        this._name = name;
        this._volume = volume;
        this._generation.set(1L);
    }

    public Volume getVolume() {
        return this._volume;
    }

    public String getName() {
        return this._name;
    }

    public int hashCode() {
        return this._volume.hashCode() ^ this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Tree) {
            Tree tree = (Tree)o;
            return this._name.equals(tree._name) && this._volume.equals(tree.getVolume());
        }
        return false;
    }

    public long getRootPageAddr() {
        return this._rootPageAddr;
    }

    public int getDepth() {
        return this._depth;
    }

    void changeRootPageAddr(long rootPageAddr, int deltaDepth) throws PersistitException {
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        this._rootPageAddr = rootPageAddr;
        this._depth += deltaDepth;
    }

    void bumpChangeCount() {
        this._changeCount.incrementAndGet();
    }

    long getChangeCount() {
        return this._changeCount.get();
    }

    int store(byte[] bytes, int index) {
        byte[] nameBytes = Util.stringToBytes(this._name);
        Util.putLong(bytes, index, this._rootPageAddr);
        Util.putLong(bytes, index + 8, this.getChangeCount());
        Util.putShort(bytes, index + 16, this._depth);
        Util.putShort(bytes, index + 18, nameBytes.length);
        Util.putBytes(bytes, index + 20, nameBytes);
        return 20 + nameBytes.length;
    }

    int load(byte[] bytes, int index, int length) {
        int nameLength;
        int n = nameLength = length < 20 ? -1 : Util.getShort(bytes, index + 18);
        if (nameLength < 1 || nameLength + 20 > length) {
            throw new IllegalStateException("Invalid tree record is too short for tree " + this._name + ": " + length);
        }
        String name = new String(bytes, index + 20, nameLength);
        if (!this._name.equals(name)) {
            throw new IllegalStateException("Invalid tree name recorded: " + name + " for tree " + this._name);
        }
        this._rootPageAddr = Util.getLong(bytes, index);
        this._changeCount.set(Util.getLong(bytes, index + 8));
        this._depth = Util.getShort(bytes, index + 16);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootPageAddress(long rootPageAddr) throws PersistitException {
        if (this._rootPageAddr != rootPageAddr) {
            Buffer buffer = null;
            try {
                buffer = this.getVolume().getStructure().getPool().get(this._volume, rootPageAddr, false, true);
                int type = buffer.getPageType();
                if (type < 1 || type > 21) {
                    throw new CorruptVolumeException(String.format("Tree root page %,d has invalid type %s", rootPageAddr, buffer.getPageTypeName()));
                }
                this._rootPageAddr = rootPageAddr;
                this._depth = type - 1 + 1;
            }
            finally {
                if (buffer != null) {
                    buffer.releaseTouched();
                }
            }
        }
    }

    void invalidate() {
        super.clearValid();
        this._depth = -1;
        this._rootPageAddr = -1L;
        this._generation.set(-1L);
    }

    public TreeStatistics getStatistics() {
        return this._treeStatistics;
    }

    @Override
    public String toString() {
        return "<Tree " + this._name + " in volume " + this._volume.getName() + " rootPageAddr=" + this._rootPageAddr + " depth=" + this._depth + " status=" + this.getStatusDisplayString() + ">";
    }

    public void setAppCache(Object appCache) {
        this._appCache.set(appCache);
    }

    public Object getAppCache() {
        return this._appCache.get();
    }

    public int getHandle() {
        return this._handle.get();
    }

    void loadHandle() throws PersistitException {
        assert (!this._volume.isTemporary()) : "Handle allocation for temporary tree " + this;
        this._persistit.getJournalManager().handleForTree(this);
    }

    public synchronized Accumulator getAccumulator(Accumulator.Type type, int index) throws PersistitException {
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException("Invalid accumulator index: " + index);
        }
        Accumulator accumulator = this._accumulators[index];
        if (accumulator == null) {
            AccumulatorState saved = Accumulator.getAccumulatorState(this, index);
            long savedValue = 0L;
            if (saved != null) {
                if (!saved.getTreeName().equals(this.getName())) {
                    throw new IllegalStateException("AccumulatorState has wrong tree name: " + saved);
                }
                if (!saved.getType().equals((Object)type)) {
                    throw new IllegalStateException("AccumulatorState has different type: " + saved);
                }
                savedValue = saved.getValue();
            }
            this._accumulators[index] = accumulator = Accumulator.accumulator(type, this, index, savedValue, this._persistit.getTransactionIndex());
            this._persistit.addAccumulator(accumulator);
        } else if (accumulator.getType() != type) {
            throw new IllegalStateException("Wrong type " + accumulator + " is not a " + (Object)((Object)type) + " accumulator");
        }
        return accumulator;
    }

    int setHandle(int handle) {
        if (!this._handle.compareAndSet(0, handle)) {
            throw new IllegalStateException("Tree handle already set");
        }
        return handle;
    }

    void resetHandle() {
        this._handle.set(0);
    }

    void discardAccumulators() {
        for (int i = 0; i < this._accumulators.length; ++i) {
            if (this._accumulators[i] == null) continue;
            this._persistit.removeAccumulator(this._accumulators[i]);
            this._accumulators[i] = null;
        }
    }
}

