/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.CleanupManager;
import com.persistit.Exchange;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.SessionId;
import com.persistit.TransactionRunnable;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.RollbackException;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Transaction {
    static final int MAXIMUM_STEP = 99;
    static final int TRANSACTION_BUFFER_SIZE = 65536;
    private static long _idCounter = 100000000L;
    private final Persistit _persistit;
    private final SessionId _sessionId;
    private final long _id;
    private volatile int _nestedDepth;
    private volatile boolean _rollbackPending;
    private volatile boolean _rollbackCompleted;
    private volatile boolean _commitCompleted;
    private volatile long _rollbackCount = 0L;
    private volatile long _commitCount = 0L;
    private volatile int _rollbacksSinceLastCommit = 0;
    private volatile TransactionStatus _transactionStatus;
    private volatile long _startTimestamp;
    private volatile long _commitTimestamp;
    private final ByteBuffer _buffer = ByteBuffer.allocate(65536);
    private long _previousJournalAddress;
    private int _step;
    private String _threadName;
    private final Set<CleanupManager.CleanupAction> _lockCleanupActions = new HashSet<CleanupManager.CleanupAction>();
    private CommitPolicy _defaultCommitPolicy = CommitPolicy.SOFT;

    Transaction(Persistit persistit, SessionId sessionId) {
        this(persistit, sessionId, Transaction.nextId());
    }

    private Transaction(Persistit persistit, SessionId sessionId, long id) {
        this._persistit = persistit;
        this._sessionId = sessionId;
        this._id = id;
    }

    private static synchronized long nextId() {
        return ++_idCounter;
    }

    void close() throws PersistitException {
        TransactionStatus status;
        TransactionStatus ts;
        if (!(this._nestedDepth <= 0 || this._commitCompleted || this._rollbackCompleted || (ts = this._transactionStatus) == null || ts.getTs() != this._startTimestamp || this._commitCompleted || this._rollbackCompleted)) {
            this._transactionStatus.markAbandoned();
            this.rollback();
            this._persistit.getLogBase().txnAbandoned.log(this);
        }
        if ((status = this._persistit.getTransactionIndex().getStatus(this._startTimestamp)) != null && status.getMvvCount() > 0) {
            this.flushTransactionBuffer(false);
        }
    }

    public void checkPendingRollback() throws RollbackException {
        if (this._rollbackPending) {
            throw new RollbackException();
        }
    }

    public boolean isActive() {
        return this._nestedDepth > 0;
    }

    public boolean isCommitted() {
        return this._commitCompleted;
    }

    public boolean isRollbackPending() {
        return this._rollbackPending;
    }

    public void begin() throws PersistitException {
        if (this._commitCompleted) {
            throw new IllegalStateException("Attempt to begin a committed transaction " + this);
        }
        if (this._rollbackPending) {
            throw new IllegalStateException("Attempt to begin a transaction with pending rollback" + this);
        }
        if (this._nestedDepth == 0) {
            this.flushTransactionBuffer(false);
            try {
                this._transactionStatus = this._persistit.getTransactionIndex().registerTransaction();
            }
            catch (InterruptedException e) {
                this._rollbackCompleted = true;
                throw new PersistitInterruptedException(e);
            }
            this._rollbackPending = false;
            this._rollbackCompleted = false;
            this._startTimestamp = this._transactionStatus.getTs();
            this._commitTimestamp = 0L;
            this._step = 0;
            this._threadName = Thread.currentThread().getName();
        } else {
            this.checkPendingRollback();
        }
        ++this._nestedDepth;
    }

    void beginCheckpoint() throws PersistitException {
        if (this._commitCompleted) {
            throw new IllegalStateException("Attempt to begin a committed transaction " + this);
        }
        if (this._rollbackPending) {
            throw new IllegalStateException("Attmpet to begin a transaction with pending rollback" + this);
        }
        if (this._nestedDepth == 0) {
            this.flushTransactionBuffer(false);
            try {
                this._transactionStatus = this._persistit.getTransactionIndex().registerCheckpointTransaction();
            }
            catch (InterruptedException e) {
                this._rollbackCompleted = true;
                throw new PersistitInterruptedException(e);
            }
            this._rollbackPending = false;
            this._rollbackCompleted = false;
            this._startTimestamp = this._transactionStatus.getTs();
            this._commitTimestamp = 0L;
            this._step = 0;
        } else {
            this.checkPendingRollback();
        }
        ++this._nestedDepth;
    }

    public void end() {
        this.checkActive();
        if (this._nestedDepth == 1) {
            if (!this._commitCompleted) {
                if (!this._rollbackPending) {
                    this._persistit.getLogBase().txnNotCommitted.log(this);
                }
                if (!this._rollbackCompleted) {
                    this.rollback();
                }
            } else {
                ++this._commitCount;
                this._rollbacksSinceLastCommit = 0;
            }
            try {
                this.pruneLockPages();
            }
            catch (Exception e) {
                this._persistit.getLogBase().pruneException.log(e, "locks");
            }
            this._transactionStatus = null;
            this._rollbackPending = false;
            this._threadName = null;
        }
        --this._nestedDepth;
        this._commitCompleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this.checkActive();
        if (this._commitCompleted) {
            throw new IllegalStateException("Already committed " + this);
        }
        this._rollbackPending = true;
        if (!this._rollbackCompleted) {
            ++this._rollbackCount;
            ++this._rollbacksSinceLastCommit;
            this._transactionStatus.abort();
            try {
                this.flushTransactionBuffer(false);
            }
            catch (PersistitException e) {
                this._persistit.getLogBase().exception.log(e);
            }
            finally {
                this._persistit.getTransactionIndex().notifyCompleted(this._transactionStatus, this._persistit.getTimestampAllocator().getCurrentTimestamp());
                this._rollbackCompleted = true;
            }
        }
    }

    public void commit() throws PersistitException {
        this.commit(this._persistit.getDefaultTransactionCommitPolicy());
    }

    @Deprecated
    public void commit(boolean toDisk) throws PersistitException {
        this.commit(toDisk ? CommitPolicy.HARD : CommitPolicy.SOFT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitPolicy policy) throws PersistitException {
        block8: {
            this.checkActive();
            if (this._commitCompleted) {
                throw new IllegalStateException("Already committed " + this);
            }
            this.checkPendingRollback();
            if (this._nestedDepth != 1) break block8;
            if (this._rollbackCompleted) {
                throw new IllegalStateException("Already rolled back " + this);
            }
            for (Accumulator.Delta delta = this._transactionStatus.getDelta(); delta != null; delta = delta.getNext()) {
                this.writeDeltaToJournal(delta);
            }
            this._transactionStatus.commit(this._persistit.getTimestampAllocator().getCurrentTimestamp());
            ThreadSequencer.sequence(SequencerConstants.COMMIT_FLUSH_A);
            this._commitTimestamp = this._persistit.getTimestampAllocator().updateTimestamp();
            ThreadSequencer.sequence(SequencerConstants.COMMIT_FLUSH_C);
            long flushedTimetimestamp = 0L;
            for (Accumulator.Delta delta = this._transactionStatus.getDelta(); delta != null; delta = delta.getNext()) {
                Accumulator acc = delta.getAccumulator();
                acc.checkpointNeeded(this._commitTimestamp);
            }
            boolean committed = false;
            try {
                if (this.flushTransactionBuffer(false)) {
                    flushedTimetimestamp = this._persistit.getTimestampAllocator().getCurrentTimestamp();
                }
                committed = true;
                this._persistit.getTransactionIndex().notifyCompleted(this._transactionStatus, committed ? this._commitTimestamp : Long.MIN_VALUE);
                this._commitCompleted = committed;
                this._rollbackCompleted = !committed;
            }
            catch (Throwable throwable) {
                this._persistit.getTransactionIndex().notifyCompleted(this._transactionStatus, committed ? this._commitTimestamp : Long.MIN_VALUE);
                this._commitCompleted = committed;
                this._rollbackCompleted = !committed;
                this._rollbackPending = this._rollbackCompleted;
                throw throwable;
            }
            this._rollbackPending = this._rollbackCompleted;
            this._persistit.getJournalManager().throttle();
            if (flushedTimetimestamp != 0L) {
                this._persistit.getJournalManager().waitForDurability(flushedTimetimestamp, policy == CommitPolicy.SOFT ? this._persistit.getTransactionCommitLeadTime() : 0L, policy == CommitPolicy.GROUP ? this._persistit.getTransactionCommitStallTime() : 0L);
            }
        }
    }

    public int getNestedTransactionDepth() {
        return this._nestedDepth;
    }

    public int run(TransactionRunnable runnable) throws PersistitException {
        return this.run(runnable, 0, 0L, this._persistit.getDefaultTransactionCommitPolicy());
    }

    public int run(TransactionRunnable runnable, int retryCount, long retryDelay, boolean toDisk) throws PersistitException {
        return this.run(runnable, retryCount, retryDelay, toDisk ? CommitPolicy.HARD : CommitPolicy.SOFT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(TransactionRunnable runnable, int retryCount, long retryDelay, CommitPolicy toDisk) throws PersistitException {
        if (retryCount < 0) {
            throw new IllegalArgumentException();
        }
        int count = 1;
        while (true) {
            block10: {
                this.begin();
                try {
                    runnable.runTransaction();
                    this.commit(toDisk);
                    int n = count;
                    return n;
                }
                catch (RollbackException re) {
                    if (retryCount <= 0 || this._nestedDepth > 1) {
                        throw re;
                    }
                    --retryCount;
                    if (retryDelay <= 0L) break block10;
                    try {
                        Util.sleep(retryDelay);
                    }
                    catch (PersistitInterruptedException ie) {
                        throw re;
                    }
                }
                finally {
                    this.end();
                }
            }
            ++count;
        }
    }

    public String toString() {
        return "Transaction_" + this._id + " depth=" + this._nestedDepth + " status=" + this.getStatus() + (this._threadName == null ? "" : " owner=" + this._threadName);
    }

    String getStatus() {
        TransactionStatus status = this._transactionStatus;
        long ts = this.getStartTimestamp();
        if (status != null && status.getTs() == ts) {
            return status.toString();
        }
        return "<not running>";
    }

    public CommitPolicy getDefaultCommitPolicy() {
        return this._defaultCommitPolicy;
    }

    public void setDefaultCommitPolicy(CommitPolicy policy) {
        this._defaultCommitPolicy = policy;
    }

    public long getId() {
        return this._id;
    }

    public long getStartTimestamp() {
        return this._startTimestamp;
    }

    public long getCommitTimestamp() {
        return this._commitTimestamp;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public long getCommittedTransactionCount() {
        return this._commitCount;
    }

    public long getRolledBackTransactionCount() {
        return this._rollbackCount;
    }

    public int getRolledBackSinceLastCommitCount() {
        return this._rollbacksSinceLastCommit;
    }

    void store(Exchange exchange, Key key, Value value) throws PersistitException {
        if (this._nestedDepth > 0) {
            this.checkPendingRollback();
            this.writeStoreRecordToJournal(this.treeHandle(exchange.getTree()), key, value);
        }
    }

    void remove(Exchange exchange, Key key1, Key key2) throws PersistitException {
        if (this._nestedDepth > 0) {
            this.checkPendingRollback();
            this.writeDeleteRecordToJournal(this.treeHandle(exchange.getTree()), key1, key2);
        }
    }

    void removeTree(Exchange exchange) throws PersistitException {
        if (this._nestedDepth > 0) {
            this.checkPendingRollback();
            this.writeDeleteTreeToJournal(this.treeHandle(exchange.getTree()));
        }
    }

    private synchronized void prepare(int recordSize) throws PersistitException {
        if (recordSize > this._buffer.remaining()) {
            this.flushTransactionBuffer(true);
        }
        if (recordSize > this._buffer.remaining()) {
            throw new IllegalStateException("Record size " + recordSize + " is too long for Transaction buffer in " + this);
        }
    }

    synchronized boolean flushTransactionBuffer(boolean chain) throws PersistitException {
        boolean didWrite = false;
        if (this._buffer.position() > 0 || this._previousJournalAddress != 0L) {
            long previousJournalAddress = this._persistit.getJournalManager().writeTransactionToJournal(this._buffer, this._startTimestamp, this._commitTimestamp, this._previousJournalAddress);
            this._buffer.clear();
            didWrite = true;
            this._previousJournalAddress = chain ? previousJournalAddress : 0L;
        }
        return didWrite;
    }

    synchronized void flushOnCheckpoint(long timestamp) throws PersistitException {
        if (this._startTimestamp > 0L && this._startTimestamp < timestamp && this._commitTimestamp == 0L && this._buffer.position() > 0) {
            ThreadSequencer.sequence(SequencerConstants.COMMIT_FLUSH_B);
            this._previousJournalAddress = this._persistit.getJournalManager().writeTransactionToJournal(this._buffer, this._startTimestamp, 0L, this._previousJournalAddress);
            this._buffer.clear();
        }
    }

    synchronized void writeStoreRecordToJournal(int treeHandle, Key key, Value value) throws PersistitException {
        int recordSize = 14 + key.getEncodedSize() + value.getEncodedSize();
        this.prepare(recordSize);
        JournalRecord.SR.putLength(this._buffer, recordSize);
        JournalRecord.SR.putType(this._buffer);
        JournalRecord.SR.putTreeHandle(this._buffer, treeHandle);
        JournalRecord.SR.putKeySize(this._buffer, (short)key.getEncodedSize());
        this._buffer.position(this._buffer.position() + 14);
        this._buffer.put(key.getEncodedBytes(), 0, key.getEncodedSize());
        this._buffer.put(value.getEncodedBytes(), 0, value.getEncodedSize());
    }

    synchronized void writeDeleteRecordToJournal(int treeHandle, Key key1, Key key2) throws PersistitException {
        int elisionCount = key2.firstUniqueByteIndex(key1);
        int recordSize = 16 + key1.getEncodedSize() + key2.getEncodedSize() - elisionCount;
        this.prepare(recordSize);
        JournalRecord.DR.putLength(this._buffer, recordSize);
        JournalRecord.DR.putType(this._buffer);
        JournalRecord.DR.putTreeHandle(this._buffer, treeHandle);
        JournalRecord.DR.putKey1Size(this._buffer, key1.getEncodedSize());
        JournalRecord.DR.putKey2Elision(this._buffer, elisionCount);
        this._buffer.position(this._buffer.position() + 16);
        this._buffer.put(key1.getEncodedBytes(), 0, key1.getEncodedSize());
        this._buffer.put(key2.getEncodedBytes(), elisionCount, key2.getEncodedSize() - elisionCount);
    }

    synchronized void writeDeleteTreeToJournal(int treeHandle) throws PersistitException {
        this.prepare(12);
        JournalRecord.putLength(this._buffer, 12);
        JournalRecord.DT.putType(this._buffer);
        JournalRecord.DT.putTreeHandle(this._buffer, treeHandle);
        this._buffer.position(this._buffer.position() + 12);
    }

    synchronized void writeDeltaToJournal(Accumulator.Delta delta) throws PersistitException {
        int treeHandle = this.treeHandle(delta.getAccumulator().getTree());
        if (delta.getValue() == 1L) {
            this.prepare(16);
            JournalRecord.putLength(this._buffer, 16);
            JournalRecord.D0.putType(this._buffer);
            JournalRecord.D0.putTreeHandle(this._buffer, treeHandle);
            JournalRecord.D0.putAccumulatorTypeOrdinal(this._buffer, delta.getAccumulator().getType().ordinal());
            JournalRecord.D0.putIndex(this._buffer, delta.getAccumulator().getIndex());
            this._buffer.position(this._buffer.position() + 16);
        } else {
            this.prepare(24);
            JournalRecord.putLength(this._buffer, 24);
            JournalRecord.D1.putType(this._buffer);
            JournalRecord.D1.putTreeHandle(this._buffer, treeHandle);
            JournalRecord.D1.putIndex(this._buffer, delta.getAccumulator().getIndex());
            JournalRecord.D1.putAccumulatorTypeOrdinal(this._buffer, delta.getAccumulator().getType().ordinal());
            JournalRecord.D1.putValue(this._buffer, delta.getValue());
            this._buffer.position(this._buffer.position() + 24);
        }
    }

    TransactionStatus getTransactionStatus() {
        TransactionStatus ts = this._transactionStatus;
        if (this._nestedDepth > 0 && ts != null && ts.getTs() == this._startTimestamp) {
            return ts;
        }
        throw new IllegalArgumentException("Transaction not in scope " + this);
    }

    public int getStep() {
        return this._step;
    }

    public int setStep(int step) {
        this.checkPendingRollback();
        this.checkStepRange(step);
        int previous = this._step;
        this._step = step;
        return previous;
    }

    void checkActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("No transaction scope: begin() has not been called in " + this);
        }
    }

    public int incrementStep() {
        return this.setStep(this._step + 1);
    }

    private void checkStepRange(int newStep) {
        if (newStep < 0) {
            throw new IllegalStateException(this + " cannot have a step of " + newStep + ", less than 0");
        }
        if (newStep > 99) {
            throw new IllegalStateException(this + " cannot have a step of " + newStep + ", greater than maximum " + 99);
        }
    }

    private int treeHandle(Tree tree) {
        int treeHandle = tree.getHandle();
        assert (treeHandle != 0) : "Undefined tree handle in " + tree;
        return treeHandle;
    }

    void addLockPage(Long page, int treeHandle) {
        this._lockCleanupActions.add(new CleanupManager.CleanupPruneAction(treeHandle, page));
    }

    void pruneLockPages() {
        if (this._lockCleanupActions.isEmpty()) {
            return;
        }
        this._persistit.getTransactionIndex().updateActiveTransactionCache(this._commitTimestamp);
        ArrayList<CleanupManager.CleanupAction> actions = new ArrayList<CleanupManager.CleanupAction>(this._lockCleanupActions);
        this._lockCleanupActions.clear();
        while (!actions.isEmpty()) {
            ArrayList<CleanupManager.CleanupAction> consequentActions = new ArrayList<CleanupManager.CleanupAction>();
            for (CleanupManager.CleanupAction cleanupAction : actions) {
                try {
                    cleanupAction.performAction(this._persistit, consequentActions);
                }
                catch (PersistitException pe) {
                    this._persistit.getLogBase().pruneException.log(pe, this);
                }
                actions = consequentActions;
            }
        }
    }

    ByteBuffer getTransactionBuffer() {
        return this._buffer;
    }

    public static enum CommitPolicy {
        SOFT,
        HARD,
        GROUP;


        static CommitPolicy forName(String policyName) {
            for (CommitPolicy policy : CommitPolicy.values()) {
                if (!policy.name().equalsIgnoreCase(policyName)) continue;
                return policy;
            }
            throw new IllegalArgumentException("No such CommitPolicy: " + policyName);
        }
    }
}

