/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.CLI;
import com.persistit.IOMeter;
import com.persistit.Management;
import com.persistit.Task;
import com.persistit.mxbeans.IOMeterMXBean;
import com.persistit.util.Util;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsTask
extends Task {
    static final long NANOS_PER_MILLI = 1000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final String COUNT_FORMAT = "%s=%d";
    static final String RATE_FORMAT = "%s=%.3f";
    static final String PHEADER_FORMAT = " %10s";
    static final String PCOUNT_FORMAT = " %,10d";
    static final String PRATE_FORMAT = " %,10.3f";
    static final String TIME_HEADER_FORMAT = "%12s ";
    static final String TIME_FORMAT = "%,12d ";
    long _delay;
    long _count;
    boolean _bpool;
    boolean _journal;
    boolean _io;
    boolean _transactions;
    boolean _showRate;
    boolean _showValue;
    String _fileName;
    PrintWriter _pw;
    String _lastUpdate = "none";
    private final Map<String, Stat> _statsMap = new HashMap<String, Stat>();
    private final List<Stat> _statsList = new ArrayList<Stat>();

    @CLI.Cmd(value="stat")
    static Task createStatisticsTask(@CLI.Arg(value="delay|long:10:0:10000000|Interval in seconds between updates") long delay, @CLI.Arg(value="count|long:1:0:|Number of updates") long count, @CLI.Arg(value="file|string|Output file name") String toFile, @CLI.Arg(value="_flag|a|All") boolean all, @CLI.Arg(value="_flag|b|Buffer pool statistics") boolean bstats, @CLI.Arg(value="_flag|j|Journal statistics") boolean jstats, @CLI.Arg(value="_flag|i|I/O Statistics") boolean istats, @CLI.Arg(value="_flag|t|Transaction statistics") boolean tstats, @CLI.Arg(value="_flag|r|Show rates") boolean showRates, @CLI.Arg(value="_flag|v|Show values") boolean showValues) throws Exception {
        StatisticsTask task = new StatisticsTask();
        task._delay = delay;
        task._count = count;
        task._fileName = toFile;
        task._bpool = bstats || all;
        task._journal = jstats || all;
        task._io = istats || all;
        task._transactions = tstats || all;
        task._showRate = showRates;
        task._showValue = showValues;
        return task;
    }

    @Override
    protected void runTask() throws Exception {
        long now;
        if (this._fileName != null && !this._fileName.isEmpty()) {
            this._pw = new PrintWriter(new FileOutputStream(this._fileName, true));
        }
        if (!(this._bpool || this._journal || this._transactions || this._io)) {
            this.postMessage("No statistics selected", 0);
            return;
        }
        StringBuilder sb = new StringBuilder();
        long next = now = System.nanoTime();
        boolean first = true;
        for (long count = 0L; count < this._count || count == 0L; ++count) {
            Display d;
            if (count != 0L) {
                next += this._delay * 1000000000L;
                while (true) {
                    this.poll();
                    now = System.nanoTime();
                    long sleep = Math.min(1000L, (next - now) / 1000000L);
                    if (sleep <= 0L) break;
                    Util.sleep(sleep);
                }
            }
            this.updateStatistics(now);
            sb.setLength(0);
            Display display = this._showRate ? Display.RATE : (d = count == 0L ? Display.TOTAL : Display.CHANGE);
            if (count > 0L || !this._showRate) {
                String line;
                for (Stat stat : this._statsList) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(stat.toString(d));
                }
                sb.append(' ');
                sb.append((Object)d);
                this._lastUpdate = line = sb.toString();
                if (this._pw != null) {
                    if (first) {
                        this._pw.printf(TIME_HEADER_FORMAT, "elapsed ms");
                        for (Stat stat : this._statsList) {
                            stat.printHeader(this._pw);
                        }
                        this._pw.println();
                        first = false;
                    }
                    this._pw.printf(TIME_FORMAT, this._persistit.elapsedTime());
                    for (Stat stat : this._statsList) {
                        stat.printValue(this._pw, d);
                    }
                    this._pw.print(' ');
                    this._pw.println(d.toString());
                    this._pw.flush();
                } else {
                    this.postMessage(line, 1);
                }
            }
            if (this._delay < 1L) break;
        }
    }

    private Stat stat(String name) {
        Stat stat = this._statsMap.get(name);
        if (stat == null) {
            stat = new Stat(name);
            this._statsMap.put(name, stat);
            this._statsList.add(stat);
        }
        return stat;
    }

    private void updateStatistics(long time) throws Exception {
        Management management = this._persistit.getManagement();
        if (this._bpool) {
            this.updateBPoolStatistics(management, time);
        }
        if (this._journal) {
            this.updateJournalStatistics(management, time);
        }
        if (this._transactions) {
            this.updateTransactionStatistics(management, time);
        }
        if (this._io) {
            this.updateIOStatistics(management, time);
        }
    }

    private void updateBPoolStatistics(Management management, long time) throws Exception {
        Management.BufferPoolInfo[] array = management.getBufferPoolInfoArray();
        long hits = 0L;
        long misses = 0L;
        long newPages = 0L;
        long evictions = 0L;
        for (Management.BufferPoolInfo info : array) {
            hits += info.getHitCount();
            misses += info.getMissCount();
            newPages += info.getNewCount();
            evictions += info.getEvictCount();
        }
        this.stat("hit").update(time, hits);
        this.stat("miss").update(time, misses);
        this.stat("new").update(time, newPages);
        this.stat("evict").update(time, evictions);
    }

    private void updateJournalStatistics(Management management, long time) throws Exception {
        Management.JournalInfo info = management.getJournalInfo();
        this.stat("jwrite").update(time, info.getJournaledPageCount());
        this.stat("jread").update(time, info.getReadPageCount());
        this.stat("jcopy").update(time, info.getCopiedPageCount());
    }

    private void updateTransactionStatistics(Management management, long time) throws Exception {
        Management.TransactionInfo info = management.getTransactionInfo();
        this.stat("tcommit").update(time, info.getCommitCount());
        this.stat("troll").update(time, info.getRollbackCount());
    }

    private void updateIOStatistics(Management management, long time) throws Exception {
        IOMeter ioMeter = this._persistit.getIOMeter();
        String[] items = IOMeterMXBean.SUMMARY_ITEMS;
        long size = 0L;
        for (String item : items) {
            this.stat(item).update(time, ioMeter.totalOperations(item));
            size += ioMeter.totalBytes(item);
        }
        this.stat("IOkbytes").update(time, (size + 600L) / 1000L);
    }

    @Override
    public String getStatus() {
        return this._lastUpdate;
    }

    static class Stat {
        final String _name;
        long _time;
        long _value;
        long _interval;
        long _change;

        Stat(String name) {
            this._name = name;
        }

        final void update(long time, long value) {
            this._interval = time - this._time;
            this._change = value - this._value;
            this._time = time;
            this._value = value;
        }

        public String toString() {
            return this.toString(Display.TOTAL);
        }

        public String toString(Display display) {
            switch (display) {
                case TOTAL: {
                    return String.format(StatisticsTask.COUNT_FORMAT, this._name, this._value);
                }
                case CHANGE: {
                    return String.format(StatisticsTask.COUNT_FORMAT, this._name, this._change);
                }
                case RATE: {
                    return String.format(StatisticsTask.RATE_FORMAT, this._name, this.rate());
                }
            }
            throw new IllegalStateException();
        }

        public void printHeader(PrintWriter pw) throws IOException {
            pw.print(String.format(StatisticsTask.PHEADER_FORMAT, this._name));
        }

        public void printValue(PrintWriter pw, Display display) throws IOException {
            switch (display) {
                case TOTAL: {
                    pw.print(String.format(StatisticsTask.PCOUNT_FORMAT, this._value));
                    break;
                }
                case CHANGE: {
                    pw.print(String.format(StatisticsTask.PCOUNT_FORMAT, this._change));
                    break;
                }
                case RATE: {
                    pw.print(String.format(StatisticsTask.PRATE_FORMAT, this.rate()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public double rate() {
            if (this._interval > 0L) {
                return (double)this._change * 1.0E9 / (double)this._interval;
            }
            return -1.0;
        }
    }

    static enum Display {
        TOTAL,
        CHANGE,
        RATE;

    }
}

