/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.SharedResource;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.util.Debug;

class ReentrantResourceHolder {
    private final SharedResource _resource;
    private int _claimCount;

    ReentrantResourceHolder(SharedResource r) {
        this._resource = r;
    }

    void verifyReleased() {
        Debug.$assert0.t(this._claimCount == 0);
        this._claimCount = 0;
    }

    boolean claim(boolean writer) throws PersistitInterruptedException {
        return this.claim(writer, 60000L);
    }

    boolean claim(boolean writer, long timeout) throws PersistitInterruptedException {
        if (this._claimCount == 0) {
            if (!this._resource.claim(writer, timeout)) {
                return false;
            }
            ++this._claimCount;
            return true;
        }
        if (writer && !this._resource.isWriter() && !this._resource.upgradeClaim()) {
            return false;
        }
        ++this._claimCount;
        return true;
    }

    void release() {
        if (this._claimCount <= 0) {
            throw new IllegalStateException("This thread holds no claims");
        }
        if (--this._claimCount == 0) {
            this._resource.release();
        }
    }

    boolean upgradeClaim() {
        return this._resource.upgradeClaim();
    }
}

