/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.Tree;
import java.util.ArrayList;
import java.util.List;

public class KeyHistogram {
    private final Tree _tree;
    private final Key _startKey;
    private final Key _endKey;
    private final int _requestedSampleSize;
    private final int _treeDepth;
    private final int _keyDepth;
    private final List<KeyCount> _keys = new ArrayList<KeyCount>();
    private int _modulus = 1;
    private int _keyCount = 0;
    private int _pageCount = 0;
    private long _pageBytesTotal = 0L;
    private long _pageBytesInUse = 0L;

    public KeyHistogram(Tree tree, Key start, Key end, int sampleSize, int keyDepth, int treeDepth) {
        this._tree = tree;
        this._startKey = start;
        this._endKey = end;
        this._requestedSampleSize = sampleSize;
        this._keyDepth = keyDepth;
        this._treeDepth = treeDepth;
    }

    public Tree getTree() {
        return this._tree;
    }

    public Key getStartKey() {
        return this._startKey;
    }

    public Key getEndKey() {
        return this._endKey;
    }

    public int getKeyCount() {
        return this._keyCount;
    }

    public int getRequestedSampleSize() {
        return this._requestedSampleSize;
    }

    public int getSampleSize() {
        return this._keys.size();
    }

    public List<KeyCount> getSamples() {
        return this._keys;
    }

    public int getTreeDepth() {
        return this._treeDepth;
    }

    public int getKeyDepth() {
        return this._keyDepth;
    }

    public int getPageCount() {
        return this._pageCount;
    }

    public long getPageBytesTotal() {
        return this._pageBytesTotal;
    }

    public long getPageBytesInUse() {
        return this._pageBytesInUse;
    }

    void addKeyCopy(Key key) {
        ++this._keyCount;
        if (this._keyCount % this._modulus == 0) {
            int length = this._keyDepth == 0 ? key.getEncodedSize() : key.indexTo(this._keyDepth).getIndex();
            int end = this._keys.size() - 1;
            boolean same = false;
            if (end >= 0) {
                byte[] last = this._keys.get(end).getBytes();
                same = last.length == length;
                for (int index = 0; same && index < length; same &= last[index] == key.getEncodedBytes()[index], ++index) {
                }
            }
            if (same) {
                this._keys.get(end).setCount(this._keyCount);
            } else {
                byte[] bytes = new byte[length];
                System.arraycopy(key.getEncodedBytes(), 0, bytes, 0, length);
                this._keys.add(new KeyCount(bytes, this._keyCount));
            }
        }
        if (this._keys.size() >= this._requestedSampleSize * 16) {
            int index = this._keys.size() & 0x7FFFFFFE;
            while ((index -= 2) >= 0) {
                this._keys.remove(index);
            }
            this._modulus *= 2;
        }
    }

    void addPage(int size, int used) {
        ++this._pageCount;
        this._pageBytesTotal += (long)size;
        this._pageBytesInUse += (long)used;
    }

    void cull() {
        int have = this._keys.size();
        int want = this._requestedSampleSize;
        int counter = have;
        int index = have;
        while (--index >= 0) {
            if ((counter += want) <= have) {
                this._keys.remove(index);
                continue;
            }
            counter -= have;
        }
        if (this._keys.size() > want) {
            this._keys.remove(0);
        }
    }

    public static class KeyCount {
        final byte[] _bytes;
        int _count;

        private KeyCount(byte[] bytes, int count) {
            this._bytes = bytes;
            this._count = count;
        }

        public byte[] getBytes() {
            return this._bytes;
        }

        public int getCount() {
            return this._count;
        }

        private void setCount(int count) {
            this._count = count;
        }

        public String toString() {
            Key key = new Key((Persistit)null);
            System.arraycopy(this._bytes, 0, key.getEncodedBytes(), 0, this._bytes.length);
            key.setEncodedSize(this._bytes.length);
            return String.format("%,10d %s", this._count, key);
        }
    }
}

