/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.JournalManager;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.Value;
import com.persistit.exception.CorruptJournalException;
import com.persistit.exception.PersistitIOException;
import com.persistit.util.ArgParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class JournalTool {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final long DEFAULT_BLOCK_SIZE = 1000000000L;
    private static final int EOF = -1;
    private static final int EOJ = -2;
    static final String[] ARGS_TEMPLATE = new String[]{"path|string:|Journal file name", "start|long:0:0:10000000000000|Start journal address", "end|long:1000000000000000000:0:1000000000000000000|End journal address", "types|String:*|Selected record types, for example, \"PA,PM,CP\"", "pages|String:*|Selected pages, for example, \"0,1,200-299,33333-\"", "timestamps|String:*|Selected timestamps, for example, \"132466-132499\"", "maxkey|int:42:4:10000|Maximum displayed key length", "maxvalue|int:42:4:100000|Maximum displayed value length", "timestamps|String:*|Selected timestamps, for example, \"132466-132499\"", "_flag|v|Verbose dump - includes PageMap and TransactionMap details"};
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private final Persistit _persistit;
    private Action _action;
    private String _journalFilePath;
    private long _startAddr;
    private long _endAddr;
    private PrintWriter _writer = new PrintWriter(new OutputStreamWriter(System.out));
    private final Map<Long, FileChannel> _journalFileChannels = new HashMap<Long, FileChannel>();
    private ByteBuffer _readBuffer;
    private final int _readBufferSize = 0x100000;
    private long _readBufferAddress;
    private long _currentAddress;
    private long _blockSize = 1000000000L;
    private BitSet _selectedTypes = new BitSet(65536);
    private RangePredicate _selectedPages;
    private RangePredicate _selectedTimestamps;
    private int _keyDisplayLength;
    private int _valueDisplayLength;
    private boolean _verbose;

    public long getStartAddr() {
        return this._startAddr;
    }

    public void setStartAddr(long startAddr) {
        this._startAddr = startAddr;
    }

    public long getEndAddr() {
        return this._endAddr;
    }

    public void setEndAddr(long endAddr) {
        this._endAddr = endAddr;
    }

    public Action getAction() {
        return this._action;
    }

    public void setAction(Action action) {
        this._action = action;
    }

    public PrintWriter getWriter() {
        return this._writer;
    }

    public void setWriter(PrintWriter writer) {
        this._writer = writer;
    }

    public BitSet getSelectedTypes() {
        return this._selectedTypes;
    }

    public void setSelectedTypes(BitSet selectedTypes) {
        this._selectedTypes = selectedTypes;
    }

    public RangePredicate getSelectedPages() {
        return this._selectedPages;
    }

    public void setSelectedPages(RangePredicate selectedPages) {
        this._selectedPages = selectedPages;
    }

    public RangePredicate getSelectedTimestamps() {
        return this._selectedTimestamps;
    }

    public void setSelectedTimestamps(RangePredicate selectedTimestamps) {
        this._selectedTimestamps = selectedTimestamps;
    }

    public int getKeyDisplayLength() {
        return this._keyDisplayLength;
    }

    public void setKeyDisplayLength(int keyDisplayLength) {
        this._keyDisplayLength = keyDisplayLength;
    }

    public int getValueDisplayLength() {
        return this._valueDisplayLength;
    }

    public void setValueDisplayLength(int valueDisplayLength) {
        this._valueDisplayLength = valueDisplayLength;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public JournalTool(Persistit persistit) {
        this._persistit = persistit;
        this._action = new SimpleDumpAction();
        this._selectedTypes.set(0, 65535, true);
    }

    public void init(String[] args) {
        ArgParser ap = new ArgParser("com.persistit.JournalTool", args, ARGS_TEMPLATE).strict();
        if (ap.isUsageOnly()) {
            return;
        }
        this.init(ap);
    }

    void init(ArgParser ap) {
        this.init(ap.getStringValue("path"), ap.getLongValue("start"), ap.getLongValue("end"), ap.getStringValue("types"), ap.getStringValue("pages"), ap.getStringValue("timestamps"), ap.getIntValue("maxkey"), ap.getIntValue("maxvalue"), ap.isFlag(118));
    }

    void init(String path, long start, long end, String types, String pages, String timestamps, int maxkey, int maxvalue, boolean v) {
        this._startAddr = start;
        this._endAddr = end;
        String pathName = path;
        if (this.isNullOrEmpty(pathName) && this._persistit != null) {
            pathName = this._persistit.getJournalManager().getJournalFilePath();
        }
        if (this.isNullOrEmpty(pathName)) {
            throw new IllegalArgumentException("The 'path' parameter must specify a valid journal path, for example, \n /xxx/yyy/jjj where journal file names are like jjj.000000001234");
        }
        long generation = JournalManager.fileToGeneration(new File(pathName));
        if (generation != -1L) {
            pathName = pathName.substring(0, pathName.lastIndexOf(46));
            if (start == 0L) {
                this._startAddr = generation * 1000000000L;
            }
            if (end == 1000000000000000000L) {
                this._endAddr = (generation + 1L) * 1000000000L;
            }
        }
        this._journalFilePath = pathName;
        this._readBuffer = ByteBuffer.allocate(0x100000);
        this.parseTypes(types);
        this._selectedPages = new RangePredicate(pages);
        this._selectedTimestamps = new RangePredicate(timestamps);
        this._keyDisplayLength = maxkey;
        this._valueDisplayLength = maxvalue;
        this._verbose = v;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private void parseTypes(String types) {
        boolean okay = true;
        if (!"*".equals(types)) {
            this._selectedTypes.set(0, this._selectedTypes.size(), false);
            for (String typeString : types.split(",")) {
                if (typeString.length() == 2) {
                    int t = typeString.charAt(0) << 8 | typeString.charAt(1);
                    if (JournalRecord.isValidType(t)) {
                        this._selectedTypes.set(t, true);
                        continue;
                    }
                    okay = false;
                    continue;
                }
                okay = false;
            }
        }
        if (!okay) {
            throw new IllegalArgumentException("The 'types' parameter must specify either \"*\" or a comma-separated list of valid record type names");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws Exception {
        try {
            this._currentAddress = this._startAddr;
            this._readBufferAddress = Long.MIN_VALUE;
            while (this._currentAddress < this._endAddr) {
                int type = this.scanOneRecord();
                switch (type) {
                    case -1: 
                    case 19013: {
                        this._currentAddress = this.addressUp(this._currentAddress);
                        break;
                    }
                    case -2: {
                        return;
                    }
                }
            }
        }
        finally {
            this._writer.flush();
        }
    }

    private int scanOneRecord() throws Exception {
        long from = this._currentAddress;
        try {
            this.read(this._currentAddress, 16);
        }
        catch (CorruptJournalException e) {
            this._action.eof(from);
            return -1;
        }
        catch (PersistitIOException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                return -2;
            }
            throw e;
        }
        int recordSize = JournalRecord.getLength(this._readBuffer);
        int type = JournalRecord.getType(this._readBuffer);
        long timestamp = JournalRecord.getTimestamp(this._readBuffer);
        this._currentAddress = this.processOneRecord(from, timestamp, recordSize, type);
        return type;
    }

    long processOneRecord(long from, long timestamp, int recordSize, int type) throws Exception {
        if ((long)recordSize >= this._blockSize || recordSize < 12) {
            throw new CorruptJournalException("Bad JournalRecord length " + recordSize + " at position " + this.addressToString(from, timestamp));
        }
        long address = from;
        switch (type) {
            case 19013: {
                if (!this._selectedTypes.get(type)) break;
                this._action.je(address, timestamp, recordSize);
                break;
            }
            case 19016: {
                this.read(this._currentAddress, recordSize);
                long blockSize = JournalRecord.JH.getBlockSize(this._readBuffer);
                if (blockSize != this._blockSize) {
                    address = this._currentAddress = this._currentAddress / this._blockSize * blockSize;
                    this._readBufferAddress = this._currentAddress;
                    this._blockSize = blockSize;
                }
                if (!this._selectedTypes.get(type)) break;
                this._action.jh(address, timestamp, recordSize);
                break;
            }
            case 21330: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.sr(address, timestamp, recordSize);
                break;
            }
            case 17490: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.dr(address, timestamp, recordSize);
                break;
            }
            case 17492: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.dt(address, timestamp, recordSize);
                break;
            }
            case 18774: {
                if (!this._selectedTypes.get(type)) break;
                this._action.iv(address, timestamp, recordSize);
                break;
            }
            case 18772: {
                if (!this._selectedTypes.get(type)) break;
                this._action.it(address, timestamp, recordSize);
                break;
            }
            case 20545: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.pa(address, timestamp, recordSize);
                break;
            }
            case 20557: {
                if (!this._selectedTypes.get(type)) break;
                this._action.pm(address, timestamp, recordSize);
                break;
            }
            case 21581: {
                if (!this._selectedTypes.get(type)) break;
                this._action.tm(address, timestamp, recordSize);
                break;
            }
            case 21592: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.tx(address, timestamp, recordSize);
                break;
            }
            case 17232: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.cp(address, timestamp, recordSize);
                break;
            }
            case 17456: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.d0(address, timestamp, recordSize);
                break;
            }
            case 17457: {
                if (!this._selectedTypes.get(type) || !this._selectedTimestamps.isSelected(timestamp)) break;
                this._action.d1(address, timestamp, recordSize);
                break;
            }
            default: {
                if (JournalRecord.isValidType(type)) break;
                this._currentAddress -= 16L;
                throw new CorruptJournalException("Invalid record type " + type + " at " + this.addressToString(address));
            }
        }
        return address + (long)recordSize;
    }

    private long addressUp(long address) {
        return (address / this._blockSize + 1L) * this._blockSize;
    }

    private synchronized FileChannel getFileChannel(long address) throws PersistitIOException {
        long generation = address / this._blockSize;
        FileChannel channel = this._journalFileChannels.get(generation);
        if (channel == null) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this.addressToFile(address), "r");
                channel = raf.getChannel();
                this._journalFileChannels.put(generation, channel);
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
        }
        return channel;
    }

    File addressToFile(long address) {
        return JournalManager.generationToFile(this._journalFilePath, address / this._blockSize);
    }

    private void read(long address, int size) throws PersistitIOException {
        if (this._readBufferAddress >= 0L && address >= this._readBufferAddress && (long)size + address - this._readBufferAddress <= (long)this._readBuffer.limit()) {
            this._readBuffer.position((int)(address - this._readBufferAddress));
        } else {
            try {
                int readSize;
                FileChannel fc = this.getFileChannel(address);
                this._readBuffer.clear();
                int maxSize = this._readBuffer.capacity();
                long remainingInBlock = this.addressUp(address) - address;
                if (remainingInBlock < (long)maxSize) {
                    maxSize = (int)remainingInBlock;
                }
                this._readBuffer.limit(maxSize);
                int offset = 0;
                while (this._readBuffer.remaining() > 0 && (readSize = fc.read(this._readBuffer, (long)offset + address % this._blockSize)) >= 0) {
                    offset += readSize;
                }
                this._readBufferAddress = address;
                this._readBuffer.flip();
                if (this._readBuffer.remaining() < size) {
                    throw new CorruptJournalException("End of file at " + this.addressToString(address));
                }
            }
            catch (IOException e) {
                throw new PersistitIOException("Reading from " + this.addressToString(address), e);
            }
        }
    }

    private String addressToString(long address) {
        return String.format("JournalAddress %,d", address);
    }

    private String addressToString(long address, long timestamp) {
        return String.format("JournalAddress %,d{%,d}", address, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Persistit persistit = new Persistit();
        JournalTool jt = null;
        try {
            jt = new JournalTool(persistit);
            jt.init(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(1);
        }
        try {
            jt.scan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            persistit.close();
        }
    }

    static /* synthetic */ Persistit access$100(JournalTool x0) {
        return x0._persistit;
    }

    protected class SimpleDumpAction
    implements Action {
        static final String ELIPSES = "...";
        final StringBuilder sb = new StringBuilder();
        final Key key1 = new Key(JournalTool.access$100(JournalTool.this));
        final Key key2 = new Key(JournalTool.access$100(JournalTool.this));
        final Value value = new Value(JournalTool.access$100(JournalTool.this));

        protected SimpleDumpAction() {
        }

        protected void start(long address, long timestamp, String type, int recordSize) {
            this.sb.setLength(0);
            this.sb.append(String.format("%,18d%,16d %2s (%8d) ", address, timestamp, type, recordSize));
        }

        protected void appendf(String format, Object ... args) {
            this.sb.append(String.format(format, args));
        }

        protected void keyf(Key key) {
            String s = null;
            try {
                s = key.toString();
            }
            catch (Exception e) {
                s = e.getLocalizedMessage();
            }
            this.padf(s, JournalTool.this._keyDisplayLength);
        }

        protected void valuef(Value value) {
            String s = null;
            try {
                if (value.getEncodedSize() >= 120 && (value.getEncodedBytes()[0] & 0xFF) == 255) {
                    long page = Buffer.decodeLongRecordDescriptorPointer(value.getEncodedBytes(), 0);
                    int size = Buffer.decodeLongRecordDescriptorSize(value.getEncodedBytes(), 0);
                    s = String.format("LONG_REC size %,8d page %12d", size, page);
                } else {
                    s = value.toString();
                }
            }
            catch (Exception e) {
                s = e.getLocalizedMessage();
            }
            this.padf(s, JournalTool.this._valueDisplayLength);
        }

        protected void padf(String s, int length) {
            if (s.length() < length) {
                this.sb.append(s);
                int i = length - s.length();
                while (--i >= 0) {
                    this.sb.append(' ');
                }
            } else {
                this.sb.append(s.substring(0, length - ELIPSES.length()));
                this.sb.append(ELIPSES);
            }
        }

        protected void flush() {
            if (this.sb.length() > 0) {
                this.write(this.sb.toString());
                this.sb.setLength(0);
            }
        }

        protected void write(String msg) {
            JournalTool.this._writer.println(msg);
        }

        @Override
        public void jh(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            long baseAddress = JournalRecord.JH.getBaseJournalAddress(JournalTool.this._readBuffer);
            long blockSize = JournalRecord.JH.getBlockSize(JournalTool.this._readBuffer);
            String fileCreated = SDF.format(new Date(JournalRecord.JH.getFileCreatedTime(JournalTool.this._readBuffer)));
            String journalCreated = SDF.format(new Date(JournalRecord.JH.getJournalCreatedTime(JournalTool.this._readBuffer)));
            long version = JournalRecord.JH.getVersion(JournalTool.this._readBuffer);
            this.start(address, timestamp, "JH", recordSize);
            this.appendf(" version %,3d blockSize %,14d baseAddress %,18d journalCreated %24s fileCreated %24s", version, blockSize, baseAddress, journalCreated, fileCreated);
            JournalTool.this._blockSize = blockSize;
            this.flush();
        }

        @Override
        public void je(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            this.start(address, timestamp, "JE", recordSize);
            long baseAddress = JournalRecord.JE.getBaseAddress(JournalTool.this._readBuffer);
            long currentAddress = JournalRecord.JE.getCurrentJournalAddress(JournalTool.this._readBuffer);
            String journalCreated = SDF.format(new Date(JournalRecord.JE.getJournalCreatedTime(JournalTool.this._readBuffer)));
            this.appendf(" baseAddress %,18d currentAddress %,18d journalCreated %24s", baseAddress, currentAddress, journalCreated);
            this.flush();
        }

        @Override
        public void iv(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            int handle = JournalRecord.IV.getHandle(JournalTool.this._readBuffer);
            long id = JournalRecord.IV.getVolumeId(JournalTool.this._readBuffer);
            String name = JournalRecord.IV.getVolumeSpecification(JournalTool.this._readBuffer);
            this.start(address, timestamp, "IV", recordSize);
            this.appendf(" handle %05d id %,22d name %s", handle, id, name);
            this.flush();
        }

        @Override
        public void it(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            int handle = JournalRecord.IT.getHandle(JournalTool.this._readBuffer);
            int vhandle = JournalRecord.IT.getVolumeHandle(JournalTool.this._readBuffer);
            String treeName = JournalRecord.IT.getTreeName(JournalTool.this._readBuffer);
            this.start(address, timestamp, "IT", recordSize);
            this.appendf(" handle %05d volume %05d treeName %s", handle, vhandle, treeName);
            this.flush();
        }

        @Override
        public void cp(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            long baseAddress = JournalRecord.CP.getBaseAddress(JournalTool.this._readBuffer);
            String wallTime = SDF.format(new Date(JournalRecord.CP.getSystemTimeMillis(JournalTool.this._readBuffer)));
            this.start(address, timestamp, "CP", recordSize);
            this.appendf(" baseAddress %,18d at %24s", baseAddress, wallTime);
            this.flush();
        }

        @Override
        public void tx(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            this.start(address, timestamp, "TX", recordSize);
            this.appendf(" committed %,d backchain %,d", JournalRecord.TX.getCommitTimestamp(JournalTool.this._readBuffer), JournalRecord.TX.getBackchainAddress(JournalTool.this._readBuffer));
            this.flush();
            int start = JournalTool.this._readBuffer.position();
            int end = start + recordSize;
            JournalTool.this._readBuffer.position(JournalTool.this._readBuffer.position() + 32);
            while (JournalTool.this._readBuffer.position() < end) {
                int innerSize = JournalRecord.getLength(JournalTool.this._readBuffer);
                int type = JournalRecord.getType(JournalTool.this._readBuffer);
                int position = JournalTool.this._readBuffer.position();
                JournalTool.this.processOneRecord(address + (long)position - (long)start, timestamp, innerSize, type);
                JournalTool.this._readBuffer.position(position + innerSize);
            }
            this.flush();
        }

        @Override
        public void dr(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            int thandle = JournalRecord.DR.getTreeHandle(JournalTool.this._readBuffer);
            int key1Size = JournalRecord.DR.getKey1Size(JournalTool.this._readBuffer);
            int elisionCount = JournalRecord.DR.getKey2Elision(JournalTool.this._readBuffer);
            int key2Size = recordSize - key1Size - 16;
            System.arraycopy(JournalTool.this._readBuffer.array(), JournalTool.this._readBuffer.position() + 16, this.key1.getEncodedBytes(), 0, key1Size);
            this.key1.setEncodedSize(key1Size);
            System.arraycopy(this.key1.getEncodedBytes(), 0, this.key2.getEncodedBytes(), 0, elisionCount);
            System.arraycopy(JournalTool.this._readBuffer.array(), JournalTool.this._readBuffer.position() + 16 + key1Size, this.key2.getEncodedBytes(), elisionCount, key2Size);
            this.key2.setEncodedSize(key2Size + elisionCount);
            this.start(address, timestamp, "DR", recordSize);
            this.appendf(" tree %05d key1Size %,5d key2Size %,5d  ", thandle, key1Size, key2Size);
            this.keyf(this.key1);
            this.sb.append("->");
            this.keyf(this.key2);
            this.flush();
        }

        @Override
        public void sr(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            int thandle = JournalRecord.SR.getTreeHandle(JournalTool.this._readBuffer);
            int keySize = JournalRecord.SR.getKeySize(JournalTool.this._readBuffer);
            int valueSize = recordSize - keySize - 14;
            System.arraycopy(JournalTool.this._readBuffer.array(), JournalTool.this._readBuffer.position() + 14, this.key1.getEncodedBytes(), 0, keySize);
            this.key1.setEncodedSize(keySize);
            this.value.ensureFit(valueSize);
            System.arraycopy(JournalTool.this._readBuffer.array(), JournalTool.this._readBuffer.position() + 14 + keySize, this.value.getEncodedBytes(), 0, valueSize);
            this.value.setEncodedSize(valueSize);
            this.start(address, timestamp, "SR", recordSize);
            this.appendf(" tree %05d keySize %,5d valueSize %,5d  ", thandle, keySize, valueSize);
            this.keyf(this.key1);
            this.sb.append(" : ");
            this.valuef(this.value);
            this.flush();
        }

        @Override
        public void dt(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, 12);
            int thandle = JournalRecord.DT.getTreeHandle(JournalTool.this._readBuffer);
            this.start(address, timestamp, "DT", recordSize);
            this.appendf(" tree %05d", thandle);
            this.flush();
        }

        @Override
        public void pa(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            long pageAddress = JournalRecord.PA.getPageAddress(JournalTool.this._readBuffer);
            int volumeHandle = JournalRecord.PA.getVolumeHandle(JournalTool.this._readBuffer);
            if (!JournalTool.this._selectedPages.isSelected(pageAddress)) {
                return;
            }
            this.start(address, timestamp, "PA", recordSize);
            int type = JournalRecord.getByte(JournalTool.this._readBuffer, 36);
            String typeString = Buffer.getPageTypeName(pageAddress, type);
            long rightSibling = pageAddress == 0L ? 0L : JournalRecord.getLong(JournalTool.this._readBuffer, 52);
            this.appendf(" page %5d:%,12d type %10s right %,12d", volumeHandle, pageAddress, typeString, rightSibling);
            this.flush();
        }

        @Override
        public void pm(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, 16);
            this.start(address, timestamp, "PM", recordSize);
            int count = JournalRecord.PM.getEntryCount(JournalTool.this._readBuffer);
            this.appendf(" entries %,10d", count);
            this.flush();
            if (JournalTool.this._verbose) {
                this.dumpPageMap(count, address, timestamp, recordSize);
                this.flush();
            }
        }

        @Override
        public void tm(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, 16);
            this.start(address, timestamp, "TM", recordSize);
            int count = JournalRecord.TM.getEntryCount(JournalTool.this._readBuffer);
            this.appendf(" entries %,10d", count);
            this.flush();
            if (JournalTool.this._verbose) {
                this.dumpTransactionMap(count, address, timestamp, recordSize);
                this.flush();
            }
        }

        @Override
        public void d0(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            this.start(address, timestamp, "D0", recordSize);
            int thandle = JournalRecord.D0.getTreeHandle(JournalTool.this._readBuffer);
            int index = JournalRecord.D0.getIndex(JournalTool.this._readBuffer);
            this.appendf(" tree %05d index %2d value %,5d", thandle, index, 1);
            this.flush();
        }

        @Override
        public void d1(long address, long timestamp, int recordSize) throws Exception {
            JournalTool.this.read(address, recordSize);
            this.start(address, timestamp, "D1", recordSize);
            int thandle = JournalRecord.D1.getTreeHandle(JournalTool.this._readBuffer);
            int index = JournalRecord.D1.getIndex(JournalTool.this._readBuffer);
            long value = JournalRecord.D1.getValue(JournalTool.this._readBuffer);
            this.appendf(" tree %05d index %2d value %,5d", thandle, index, value);
            this.flush();
        }

        @Override
        public void eof(long address) throws Exception {
            this.start(address, 0L, "~~", 0);
            this.flush();
        }

        void dumpPageMap(int count, long from, long timestamp, int recordSize) throws PersistitIOException {
            if (count * 28 + 16 != recordSize) {
                throw new CorruptJournalException("Invalid record size " + recordSize + " for PM record at " + JournalTool.this.addressToString(from, timestamp));
            }
            long address = from + 16L;
            int index = 0;
            int loaded = 0;
            long lastPage = Long.MAX_VALUE;
            int lastVolumeHandle = Integer.MAX_VALUE;
            for (int remaining = count; remaining > 0; --remaining) {
                if (index == loaded) {
                    int loadedSize = Math.min(JournalTool.this._readBuffer.capacity() / 28 * 28, remaining * 28);
                    JournalTool.this.read(address, loadedSize);
                    address += (long)loadedSize;
                    index = 0;
                    loaded = loadedSize / 28;
                    if (loaded <= 0) {
                        throw new CorruptJournalException("Could not load PageMap segment in entry " + (count - remaining + 1) + " at " + JournalTool.this.addressToString(from, timestamp));
                    }
                }
                int volumeHandle = JournalRecord.PM.getEntryVolumeHandle(JournalTool.this._readBuffer, index);
                long pageAddress = JournalRecord.PM.getEntryPageAddress(JournalTool.this._readBuffer, index);
                long pageTimestamp = JournalRecord.PM.getEntryTimestamp(JournalTool.this._readBuffer, index);
                long journalAddress = JournalRecord.PM.getEntryJournalAddress(JournalTool.this._readBuffer, index);
                if (JournalTool.this._selectedPages.isSelected(pageAddress) && JournalTool.this._selectedTimestamps.isSelected(pageTimestamp)) {
                    if (pageAddress != lastPage || volumeHandle != lastVolumeHandle) {
                        this.flush();
                        lastPage = pageAddress;
                        lastVolumeHandle = volumeHandle;
                        this.appendf("-- %5d:%,12d: ", volumeHandle, pageAddress);
                    }
                    this.appendf(" @%,d(%,d)", journalAddress, pageTimestamp);
                }
                ++index;
            }
        }

        void dumpTransactionMap(int count, long from, long timestamp, int recordSize) throws PersistitIOException {
            if (count * 32 + 16 != recordSize) {
                throw new CorruptJournalException("Invalid record size " + recordSize + " for TM record at " + JournalTool.this.addressToString(from, timestamp));
            }
            long address = from + 16L;
            int index = 0;
            int loaded = 0;
            for (int remaining = count; remaining > 0; --remaining) {
                if (index == loaded) {
                    JournalTool.this.read(address, Math.min(JournalTool.this._readBuffer.capacity(), remaining * 32));
                    address += (long)JournalTool.this._readBuffer.remaining();
                    index = 0;
                    loaded = JournalTool.this._readBuffer.remaining() / 32;
                    if (loaded <= 0) {
                        throw new CorruptJournalException("Could not load TransactionMap segment in entry " + (count - remaining + 1) + " at " + JournalTool.this.addressToString(from, timestamp));
                    }
                }
                long startTimestamp = JournalRecord.TM.getEntryStartTimestamp(JournalTool.this._readBuffer, index);
                long commitTimestamp = JournalRecord.TM.getEntryCommitTimestamp(JournalTool.this._readBuffer, index);
                long journalAddress = JournalRecord.TM.getEntryJournalAddress(JournalTool.this._readBuffer, index);
                boolean isCommitted = commitTimestamp != 0L;
                this.appendf("--  start %,12d  commit %,12d  @%,18d %s", startTimestamp, commitTimestamp, journalAddress, isCommitted ? "committed" : "uncommitted");
                this.flush();
                ++index;
            }
        }
    }

    protected static class RangePredicate {
        private final long[] _left;
        private final long[] _right;

        RangePredicate(String ps) {
            if ("*".equals(ps)) {
                this._left = new long[0];
                this._right = new long[0];
            } else {
                String[] terms = ps.split(",");
                this._left = new long[terms.length];
                this._right = new long[terms.length];
                for (int index = 0; index < terms.length; ++index) {
                    String[] range = terms[index].split("-");
                    boolean okay = true;
                    try {
                        switch (range.length) {
                            case 1: {
                                long v;
                                this._left[index] = v = Long.parseLong(range[0]);
                                this._right[index] = v;
                                break;
                            }
                            case 2: {
                                this._left[index] = range[0].isEmpty() ? Long.MIN_VALUE : Long.parseLong(range[0]);
                                if (range[1].isEmpty()) {
                                    this._right[index] = Long.MAX_VALUE;
                                    break;
                                }
                                this._right[index] = Long.parseLong(range[1]);
                                break;
                            }
                            default: {
                                okay = false;
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        okay = false;
                    }
                    if (okay) continue;
                    throw new IllegalArgumentException("Invalid term " + terms[index] + " in range specification " + ps);
                }
            }
        }

        private boolean isSelected(long v) {
            if (this._left.length == 0) {
                return true;
            }
            for (int index = 0; index < this._left.length; ++index) {
                if (this._left[index] > v || this._right[index] < v) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Action {
        public void je(long var1, long var3, int var5) throws Exception;

        public void jh(long var1, long var3, int var5) throws Exception;

        public void iv(long var1, long var3, int var5) throws Exception;

        public void it(long var1, long var3, int var5) throws Exception;

        public void cp(long var1, long var3, int var5) throws Exception;

        public void tx(long var1, long var3, int var5) throws Exception;

        public void sr(long var1, long var3, int var5) throws Exception;

        public void dr(long var1, long var3, int var5) throws Exception;

        public void dt(long var1, long var3, int var5) throws Exception;

        public void pa(long var1, long var3, int var5) throws Exception;

        public void pm(long var1, long var3, int var5) throws Exception;

        public void tm(long var1, long var3, int var5) throws Exception;

        public void d0(long var1, long var3, int var5) throws Exception;

        public void d1(long var1, long var3, int var5) throws Exception;

        public void eof(long var1) throws Exception;
    }
}

