/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.DefaultValueCoder;
import com.persistit.Key;
import com.persistit.Persistit;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.KeyRenderer;
import com.persistit.exception.ConversionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultObjectCoder
extends DefaultValueCoder
implements KeyRenderer {
    private DefaultValueCoder.Builder _keyBuilder;
    private HashMap _secondaryKeyTupleMap;
    private ArrayList _secondaryKeyTupleList;

    private DefaultObjectCoder(Persistit persistit, Class clientClass, DefaultValueCoder.Builder valueBuilder) {
        super(persistit, clientClass, valueBuilder);
    }

    public synchronized DefaultObjectCoder registerObjectCoderFromBean(Persistit persistit, Class clientClass, String[] keyPropertyNames) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clientClass);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        boolean[] isKeyProperty = new boolean[descriptors.length];
        for (int index = 0; index < keyPropertyNames.length; ++index) {
            String name = keyPropertyNames[index];
            boolean found = false;
            for (int j = 0; !found && j < descriptors.length; ++j) {
                if (!descriptors[j].getName().equals(name)) continue;
                isKeyProperty[j] = true;
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException("Bean for class " + clientClass.getName() + " has no property named " + name);
        }
        int count = 0;
        String[] valuePropertyNames = new String[descriptors.length - keyPropertyNames.length];
        for (int j = 0; j < descriptors.length; ++j) {
            if (isKeyProperty[j]) continue;
            valuePropertyNames[count] = descriptors[j].getName();
            ++count;
        }
        DefaultValueCoder.Builder valueBuilder = new DefaultValueCoder.Builder("value", valuePropertyNames, clientClass);
        DefaultObjectCoder coder = new DefaultObjectCoder(persistit, clientClass, valueBuilder);
        CoderManager cm = null;
        cm = persistit.getCoderManager();
        cm.registerKeyCoder(clientClass, coder);
        cm.registerValueCoder(clientClass, coder);
        return coder;
    }

    public static synchronized DefaultObjectCoder registerObjectCoder(Persistit persistit, Class clientClass, String[] keyAccessorNames, String[] valueAccessorNames) {
        DefaultValueCoder.Builder keyBuilder = new DefaultValueCoder.Builder("primaryKey", keyAccessorNames, clientClass);
        DefaultValueCoder.Builder valueBuilder = new DefaultValueCoder.Builder("value", valueAccessorNames, clientClass);
        DefaultObjectCoder coder = new DefaultObjectCoder(persistit, clientClass, valueBuilder);
        coder._keyBuilder = keyBuilder;
        CoderManager cm = null;
        cm = persistit.getCoderManager();
        cm.registerKeyCoder(clientClass, coder);
        cm.registerValueCoder(clientClass, coder);
        return coder;
    }

    @Override
    protected Object newInstance() {
        return super.newInstance();
    }

    public synchronized DefaultValueCoder.Builder addSecondaryIndexBuilder(String name, String[] keyAccessorNames) {
        DefaultValueCoder.Builder oldBuilder;
        DefaultValueCoder.Builder builder = new DefaultValueCoder.Builder(name, keyAccessorNames, this.getClientClass());
        if (this._secondaryKeyTupleMap == null) {
            this._secondaryKeyTupleMap = new HashMap();
            this._secondaryKeyTupleList = new ArrayList();
        }
        if ((oldBuilder = this._secondaryKeyTupleMap.put(name, builder)) != null) {
            this._secondaryKeyTupleList.remove(oldBuilder);
        }
        this._secondaryKeyTupleList.add(builder);
        return builder;
    }

    public synchronized DefaultValueCoder.Builder removeSecondaryIndexBuilder(String name) {
        if (this._secondaryKeyTupleMap == null) {
            return null;
        }
        DefaultValueCoder.Builder builder = (DefaultValueCoder.Builder)this._secondaryKeyTupleMap.get(name);
        if (builder != null) {
            this._secondaryKeyTupleList.remove(builder);
            this._secondaryKeyTupleMap.remove(name);
        }
        return builder;
    }

    public synchronized DefaultValueCoder.Builder getSecondaryIndexBuilder(int index) {
        if (this._secondaryKeyTupleList != null && index >= 0 && index < this._secondaryKeyTupleList.size()) {
            return (DefaultValueCoder.Builder)this._secondaryKeyTupleList.get(index);
        }
        throw new IndexOutOfBoundsException("No such secondary index: " + index);
    }

    public synchronized DefaultValueCoder.Builder getSecondaryIndexBuilder(String name) {
        if (this._secondaryKeyTupleMap == null) {
            return null;
        }
        return (DefaultValueCoder.Builder)this._secondaryKeyTupleMap.get(name);
    }

    public synchronized int getSecondaryIndexBuilderCount() {
        if (this._secondaryKeyTupleList == null) {
            return 0;
        }
        return this._secondaryKeyTupleList.size();
    }

    public DefaultValueCoder.Builder getKeyBuilder() {
        return this._keyBuilder;
    }

    @Override
    public void appendKeySegment(Key key, Object object, CoderContext context) throws ConversionException {
        DefaultValueCoder.Accessor accessor = null;
        this.checkKeyAccessors();
        DefaultValueCoder.Builder keyBuilder = this.getKeyBuilder(context);
        try {
            int count = keyBuilder.getSize();
            for (int index = 0; index < count; ++index) {
                accessor = keyBuilder.getAccessor(index);
                accessor.toKey(object, key);
            }
        }
        catch (Exception e) {
            throw new ConversionException("Encoding " + accessor.toString() + " for " + this.getClientClass(), e);
        }
    }

    public Object decodeKeySegment(Key key, Class clazz, CoderContext context) throws ConversionException {
        Object instance;
        if (clazz != this.getClientClass()) {
            throw new ClassCastException("Client class " + this.getClientClass().getName() + " does not match requested class " + clazz.getName());
        }
        try {
            instance = this.getClientClass().newInstance();
        }
        catch (Exception e) {
            throw new ConversionException("Unable to instantiate an instance of " + this.getClientClass(), e);
        }
        this.renderKeySegment(key, instance, clazz, context);
        return this.readResolve(instance);
    }

    @Override
    public boolean isZeroByteFree() {
        return false;
    }

    public void renderKeySegment(Key key, Object target, Class clazz, CoderContext context) throws ConversionException {
        if (clazz != this.getClientClass()) {
            throw new ClassCastException("Client class " + this.getClientClass().getName() + " does not match requested class " + clazz.getName());
        }
        this.checkKeyAccessors();
        DefaultValueCoder.Builder keyBuilder = this.getKeyBuilder(context);
        int count = keyBuilder.getSize();
        DefaultValueCoder.Accessor accessor = null;
        try {
            for (int index = 0; index < count; ++index) {
                accessor = this._keyBuilder.getAccessor(index);
                accessor.fromKey(target, key);
            }
        }
        catch (Exception e) {
            throw new ConversionException("Decoding " + accessor.toString() + " for " + this.getClientClass(), e);
        }
    }

    private DefaultValueCoder.Builder getKeyBuilder(CoderContext context) {
        if (context == null || context == this._keyBuilder) {
            return this._keyBuilder;
        }
        if (this._secondaryKeyTupleList != null) {
            int count = this.getSecondaryIndexBuilderCount();
            for (int index = 0; index < count; ++index) {
                if (context != this._secondaryKeyTupleList.get(index)) continue;
                return (DefaultValueCoder.Builder)context;
            }
        }
        throw new ConversionException("No such Builder " + context);
    }

    private void checkKeyAccessors() {
        if (this._keyBuilder.getSize() == 0) {
            throw new ConversionException("ObjectCoder for class " + this.getClientClass().getName() + " has no Key fields or properties");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultObjectCoder(");
        sb.append(this.getClientClass().getName());
        sb.append(",");
        sb.append(this._keyBuilder.toString());
        sb.append(",");
        sb.append(this.getValueBuilder().toString());
        if (this._secondaryKeyTupleList != null) {
            for (int index = 0; index < this._secondaryKeyTupleList.size(); ++index) {
                sb.append(",");
                sb.append(this._secondaryKeyTupleList.get(index));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

