/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.ClassInfo;
import com.persistit.Exchange;
import com.persistit.Persistit;
import com.persistit.SessionId;
import com.persistit.Transaction;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.ConversionException;
import com.persistit.exception.PersistitException;
import java.io.ObjectStreamClass;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class ClassIndex {
    static final int HANDLE_BASE = 64;
    private static final int INITIAL_CAPACITY = 123;
    private static final String BY_HANDLE = "byHandle";
    private static final String BY_NAME = "byName";
    private static final String NEXT_ID = "nextId";
    private static final int EXTRA_FACTOR = 2;
    static final String CLASS_INDEX_TREE_NAME = "_classIndex";
    private final AtomicInteger _size = new AtomicInteger();
    private final Persistit _persistit;
    private final SessionId _sessionId = new SessionId();
    private volatile AtomicReferenceArray<ClassInfoEntry> _hashTable = new AtomicReferenceArray(123);
    private int _testIdFloor = Integer.MIN_VALUE;
    private final AtomicInteger _cacheMisses = new AtomicInteger();
    private final AtomicInteger _discardedDuplicates = new AtomicInteger();

    ClassIndex(Persistit persistit) {
        this._persistit = persistit;
    }

    public int size() {
        return this._size.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassInfo lookupByHandle(int handle) {
        AtomicReferenceArray<ClassInfoEntry> hashTable = this._hashTable;
        ClassInfoEntry cie = hashTable.get(handle % hashTable.length());
        while (cie != null) {
            if (cie._classInfo.getHandle() == handle) {
                return cie._classInfo;
            }
            cie = cie._next;
        }
        this._cacheMisses.incrementAndGet();
        ClassIndex classIndex = this;
        synchronized (classIndex) {
            this._sessionId.assign();
            Exchange ex = null;
            try {
                ex = this.getExchange();
                Transaction txn = ex.getTransaction();
                txn.begin();
                try {
                    ex.clear().append(BY_HANDLE).append(handle).fetch();
                    txn.commit();
                }
                catch (Exception e) {
                    this._persistit.getLogBase().exception.log(e);
                    throw new ConversionException(e);
                }
                finally {
                    txn.end();
                }
                Value value = ex.getValue();
                if (value.isDefined()) {
                    value.setStreamMode(true);
                    int storedId = value.getInt();
                    String storedName = value.getString();
                    long storedSuid = value.getLong();
                    if (storedId != handle) {
                        throw new IllegalStateException("ClassInfo stored for handle=" + handle + " has invalid stored handle=" + storedId);
                    }
                    Class<?> cl = Class.forName(storedName, false, Thread.currentThread().getContextClassLoader());
                    long suid = 0L;
                    ObjectStreamClass osc = ObjectStreamClass.lookupAny(cl);
                    if (osc != null) {
                        suid = osc.getSerialVersionUID();
                    }
                    if (storedSuid != suid) {
                        throw new ConversionException("Class " + cl.getName() + " persistent SUID=" + storedSuid + " does not match current class SUID=" + suid);
                    }
                    ClassInfo ci = new ClassInfo(cl, suid, handle, osc);
                    this.hashClassInfo(ci);
                    ClassInfo classInfo = ci;
                    return classInfo;
                }
                ClassInfo ci = new ClassInfo(null, 0L, handle, null);
                this.hashClassInfo(ci);
                ClassInfo classInfo = ci;
                return classInfo;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConversionException(cnfe);
            }
            catch (PersistitException pe) {
                throw new ConversionException(pe);
            }
            finally {
                if (ex != null) {
                    this.releaseExchange(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ClassInfo lookupByClass(Class<?> clazz) {
        AtomicReferenceArray<ClassInfoEntry> hashTable = this._hashTable;
        ObjectStreamClass osc = null;
        long suid = 0L;
        int nh = clazz.getName().hashCode() & Integer.MAX_VALUE;
        ClassInfoEntry cie = hashTable.get(nh % hashTable.length());
        while (cie != null) {
            if (clazz.equals(cie._classInfo.getDescribedClass())) {
                return cie._classInfo;
            }
            if (cie._classInfo.getDescribedClass() != null && cie._classInfo.getName().equals(clazz.getName())) {
                if (osc == null && (osc = ObjectStreamClass.lookupAny(clazz)) != null) {
                    suid = osc.getSerialVersionUID();
                }
                if (suid == cie._classInfo.getSUID()) {
                    return cie._classInfo;
                }
            }
            cie = cie._next;
        }
        if (osc == null) {
            osc = ObjectStreamClass.lookupAny(clazz);
        }
        if (osc != null) {
            suid = osc.getSerialVersionUID();
        }
        this._cacheMisses.incrementAndGet();
        ClassIndex classIndex = this;
        synchronized (classIndex) {
            ClassInfo ci;
            SessionId saveSessionId = this._persistit.getSessionId();
            Exchange ex = null;
            this._persistit.setSessionId(this._sessionId);
            ex = this.getExchange();
            Transaction txn = ex.getTransaction();
            txn.begin();
            ex.clear().append(BY_NAME).append(clazz.getName()).append(suid).fetch();
            Value value = ex.getValue();
            if (value.isDefined()) {
                value.setStreamMode(true);
                int handle = value.getInt();
                String storedName = value.getString();
                long storedSuid = value.getLong();
                if (storedSuid != suid || !clazz.getName().equals(storedName)) {
                    throw new ConversionException("Class " + clazz.getName() + " persistent SUID=" + storedSuid + " does not match current class SUID=" + suid);
                }
                ci = new ClassInfo(clazz, suid, handle, osc);
            } else {
                ex.clear().append(NEXT_ID).fetch();
                int handle = Math.max(this._testIdFloor, value.isDefined() ? value.getInt() : 64) + 1;
                value.clear().put(handle);
                ex.store();
                value.clear();
                value.setStreamMode(true);
                value.put(handle);
                value.put(clazz.getName());
                value.put(suid);
                ex.clear().append(BY_NAME).append(clazz.getName()).append(suid).store();
                ex.clear().append(BY_HANDLE).append(handle).store();
                ci = new ClassInfo(clazz, suid, handle, osc);
            }
            txn.commit();
            this.hashClassInfo(ci);
            ClassInfo classInfo = ci;
            txn.end();
            if (ex != null) {
                this.releaseExchange(ex);
            }
            this._persistit.setSessionId(saveSessionId);
            return classInfo;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            txn.end();
                            throw throwable;
                        }
                        catch (PersistitException pe) {
                            throw new ConversionException(pe);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (ex != null) {
                            this.releaseExchange(ex);
                        }
                        this._persistit.setSessionId(saveSessionId);
                        throw throwable2;
                    }
                }
            }
        }
    }

    public void registerClass(Class<?> clazz) {
        this.lookupByClass(clazz);
    }

    private void hashClassInfo(ClassInfo ci) {
        int size = this._size.get();
        if (size * 2 > this._hashTable.length()) {
            int discarded = this._discardedDuplicates.get();
            AtomicReferenceArray<ClassInfoEntry> newHashTable = new AtomicReferenceArray<ClassInfoEntry>(4 * size);
            for (int i = 0; i < this._hashTable.length(); ++i) {
                ClassInfoEntry cie = this._hashTable.get(i);
                while (cie != null) {
                    this.addHashEntry(newHashTable, cie._classInfo);
                    cie = cie._next;
                }
            }
            this._hashTable = newHashTable;
            this._discardedDuplicates.set(discarded);
        }
        this.addHashEntry(this._hashTable, ci);
    }

    private void addHashEntry(AtomicReferenceArray<ClassInfoEntry> hashTable, ClassInfo ci) {
        int hh = ci.getHandle() % hashTable.length();
        int nh = ci.getDescribedClass() == null ? -1 : (ci.getDescribedClass().getName().hashCode() & Integer.MAX_VALUE) % hashTable.length();
        boolean added = this.addHashEntry(hashTable, ci, hh);
        if (nh != -1 && nh != hh) {
            added |= this.addHashEntry(hashTable, ci, nh);
        }
        if (!added) {
            this._discardedDuplicates.incrementAndGet();
        }
    }

    private boolean addHashEntry(AtomicReferenceArray<ClassInfoEntry> hashTable, ClassInfo ci, int hash) {
        ClassInfoEntry cie = hashTable.get(hash);
        while (cie != null) {
            if (ci.equals(cie._classInfo)) {
                return false;
            }
            cie = cie._next;
        }
        cie = hashTable.get(hash);
        ClassInfoEntry newCie = new ClassInfoEntry(ci, cie);
        hashTable.set(hash, newCie);
        this._size.incrementAndGet();
        return true;
    }

    private Exchange getExchange() throws PersistitException {
        try {
            Volume volume = this._persistit.getSystemVolume();
            return this._persistit.getExchange(volume, CLASS_INDEX_TREE_NAME, true);
        }
        catch (PersistitException pe) {
            throw new ConversionException(pe);
        }
    }

    private void releaseExchange(Exchange ex) {
        this._persistit.releaseExchange(ex);
    }

    void setTestIdFloor(int id) {
        this._testIdFloor = id;
    }

    void clearAllEntries() throws PersistitException {
        this.getExchange().removeAll();
        this._cacheMisses.set(0);
        this._discardedDuplicates.set(0);
    }

    int getCacheMisses() {
        return this._cacheMisses.get();
    }

    int getDiscardedDuplicates() {
        return this._discardedDuplicates.get();
    }

    private static class ClassInfoEntry {
        final ClassInfoEntry _next;
        final ClassInfo _classInfo;

        ClassInfoEntry(ClassInfo ci, ClassInfoEntry next) {
            this._classInfo = ci;
            this._next = next;
        }
    }
}

