/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.BackupTask;
import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.Exchange;
import com.persistit.IntegrityCheck;
import com.persistit.JournalManager;
import com.persistit.JournalRecord;
import com.persistit.JournalTool;
import com.persistit.KeyFilter;
import com.persistit.KeyParser;
import com.persistit.Persistit;
import com.persistit.StatisticsTask;
import com.persistit.StreamLoader;
import com.persistit.StreamSaver;
import com.persistit.Task;
import com.persistit.TaskCheck;
import com.persistit.Tree;
import com.persistit.TreeSelector;
import com.persistit.Volume;
import com.persistit.VolumeHeader;
import com.persistit.VolumeSpecification;
import com.persistit.exception.PersistitException;
import com.persistit.util.ArgParser;
import com.persistit.util.Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CLI {
    private static final int BUFFER_SIZE = 0x100000;
    private static final long HUGE_BLOCK_SIZE = 1000000000000L;
    private static final char DEFAULT_COMMAND_DELIMITER = ' ';
    private static final char DEFAULT_QUOTE = '\\';
    private static final int MAX_PAGE_NODES = 10000;
    private static final Map<String, Command> COMMANDS = new TreeMap<String, Command>();
    private static final Class<?>[] CLASSES;
    private static final Pattern ALL;
    private LineReader _lineReader;
    PrintWriter _writer = new PrintWriter(System.out);
    private final Stack<BufferedReader> _sourceStack = new Stack();
    private Persistit _persistit;
    private boolean _stop = false;
    private Volume _currentVolume;
    private Tree _currentTree;
    private final boolean _live;
    private int _commandCount;
    private String _lastStatus;

    public static void registerCommands(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Cmd.class)) continue;
            String name = method.getAnnotation(Cmd.class).value();
            Annotation[][] parameters = method.getParameterAnnotations();
            String[] argTemplate = new String[parameters.length];
            int index = 0;
            for (Annotation[] annotations : parameters) {
                Arg argAnnotation = (Arg)annotations[0];
                argTemplate[index++] = argAnnotation.value();
            }
            COMMANDS.put(name, new Command(name, argTemplate, method));
        }
    }

    public static void main(String[] args) throws Exception {
        int c;
        StringBuilder sb = new StringBuilder();
        int port = -1;
        String host = null;
        String[] hostPieces = args[0].split(":");
        switch (hostPieces.length) {
            case 1: {
                port = Integer.parseInt(hostPieces[0]);
                break;
            }
            case 2: {
                host = hostPieces[0];
                port = Integer.parseInt(hostPieces[1]);
            }
        }
        for (int index = 1; index < args.length; ++index) {
            if (index > 1) {
                sb.append(' ');
            }
            sb.append(args[index]);
        }
        sb.append('\n');
        if (port == -1) {
            throw new IllegalArgumentException("Invalid host or port specified by " + args[0]);
        }
        Socket socket = new Socket(host, port);
        OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
        writer.write(sb.toString());
        writer.flush();
        InputStreamReader reader = new InputStreamReader(socket.getInputStream());
        while ((c = reader.read()) != -1) {
            System.out.print((char)c);
        }
        System.out.println();
    }

    public static void runScript(Persistit persistit, BufferedReader reader, PrintWriter writer) throws Exception {
        CLI cli = new CLI(persistit, reader, writer);
        cli.commandLoop();
        cli.close(false);
        writer.println();
        writer.flush();
    }

    private static long availableMemory() {
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long max = mu.getMax();
        if (max == -1L) {
            max = mu.getInit();
        }
        return max;
    }

    public static List<String> pieces(String commandLine) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> strings = new ArrayList<String>();
        char commandDelimiter = ' ';
        char quote = '\\';
        boolean quoted = false;
        for (int index = 0; index < commandLine.length(); ++index) {
            char c = commandLine.charAt(index);
            if (index == 0 && !Character.isLetter(c)) {
                commandDelimiter = c;
                continue;
            }
            if (index == 1 && commandDelimiter != ' ' && !Character.isLetter(c) && c != commandDelimiter) {
                quote = c;
                continue;
            }
            if (quoted) {
                sb.append(c);
                quoted = false;
                continue;
            }
            if (c == quote) {
                quoted = true;
                continue;
            }
            if (c == commandDelimiter) {
                if (sb.length() <= 0) continue;
                strings.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
        }
        return strings;
    }

    static Task parseTask(Persistit persistit, String line) throws Exception {
        List<String> pieces = CLI.pieces(line);
        if (pieces.isEmpty()) {
            return null;
        }
        String commandName = pieces.remove(0);
        Command command = COMMANDS.get(commandName);
        if (command == null) {
            return null;
        }
        Task task = command.createTask(persistit, new ArgParser(commandName, pieces.toArray(new String[pieces.size()]), command.argTemplate).strict());
        if (task != null) {
            task.setPersistit(persistit);
        }
        return task;
    }

    public CLI(Persistit persistit) {
        this._persistit = persistit;
        this._live = persistit != null;
        this._lineReader = new NullReader();
    }

    public CLI(Persistit persistit, int port) throws IOException {
        this._lineReader = new NetworkReader(port);
        this._persistit = persistit;
        this._live = persistit != null;
    }

    public CLI(Persistit persistit, BufferedReader reader, PrintWriter writer) {
        this._lineReader = new ScriptReader(reader, writer);
        this._persistit = persistit;
        this._live = persistit != null;
    }

    Volume getCurrentVolume() {
        return this._currentVolume;
    }

    Tree getCurrentTree() {
        return this._currentTree;
    }

    boolean isLive() {
        return this._live;
    }

    int getCommandCount() {
        return this._commandCount;
    }

    String getLastStatus() {
        return this._lastStatus;
    }

    void setLineReader(LineReader reader) {
        this._lineReader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandLoop() throws Exception {
        while (!this._stop) {
            String input;
            if (!this._sourceStack.isEmpty()) {
                input = this._sourceStack.peek().readLine();
                if (input == null) {
                    this._sourceStack.pop();
                    continue;
                }
            } else {
                input = this._lineReader.readLine();
            }
            if (input == null) break;
            this._writer = this._lineReader.writer();
            ++this._commandCount;
            this._lastStatus = input;
            try {
                Command command;
                String commandName;
                List<String> list = CLI.pieces(input);
                if (list.isEmpty() || (commandName = list.get(0)).startsWith("#")) continue;
                if ("exit".equals(commandName) || "quit".equals(commandName)) {
                    this._stop = true;
                    this.close(false);
                    this._lastStatus = "Done";
                    this._writer.println("Done");
                    this._lineReader.close();
                }
                if ((command = COMMANDS.get(commandName)) != null) {
                    list.remove(0);
                    try {
                        String[] args = list.toArray(new String[list.size()]);
                        ArgParser ap = new ArgParser(commandName, args, command.argTemplate).strict();
                        if (ap.isUsageOnly()) continue;
                        String result = command.execute(this, ap);
                        if (result != null) {
                            this._writer.println(result);
                        }
                        this._lastStatus = this._lastStatus + " - done";
                    }
                    catch (InvocationTargetException e) {
                        this._lastStatus = this._lastStatus + e.getTargetException();
                        this._writer.println(e.getTargetException());
                    }
                    catch (RuntimeException e) {
                        this._lastStatus = this._lastStatus + e;
                        e.printStackTrace(this._writer);
                    }
                    catch (Exception e) {
                        this._lastStatus = this._lastStatus + e;
                        this._writer.println(e);
                    }
                    continue;
                }
                this._lastStatus = this._lastStatus + " - invalid command";
                this._writer.println("No such command " + commandName);
            }
            finally {
                this._writer.flush();
            }
        }
    }

    void checkOpen() throws NotOpenException {
        if (this._persistit == null) {
            throw new NotOpenException();
        }
    }

    @Cmd(value="open")
    String open(@Arg(value="datapath|string|Data path") String datapath, @Arg(value="journalpath|string|Journal path") String journalpath, @Arg(value="volumepath|string|Volume file") String volumepath, @Arg(value="rmiport|int:1099:0:99999|RMI Management port") int rmiport, @Arg(value="_flag|y|Recover committed transactions") boolean y) throws Exception {
        if (this._live) {
            return "Cannot open another Persistit instance within a live system";
        }
        this.close(false);
        String jpath = CLI.journalPath(CLI.filesOnPath(journalpath.isEmpty() ? datapath : journalpath));
        List<VolumeSpecification> volumeSpecifications = CLI.volumeSpecifications(CLI.filesOnPath(volumepath.isEmpty() ? datapath : volumepath), Long.MAX_VALUE);
        HashSet<Integer> bufferSizes = new HashSet<Integer>();
        for (VolumeSpecification vs : volumeSpecifications) {
            bufferSizes.add(vs.getPageSize());
        }
        Properties properties = new Properties();
        long bpoolMemory = CLI.availableMemory() / 2L;
        for (Integer size : bufferSizes) {
            int alloc = (int)((double)size.intValue() * 1.25);
            int count = (int)(bpoolMemory / (long)bufferSizes.size() / (long)alloc);
            properties.put("buffer.count." + size, Integer.toString(count));
        }
        int index = 0;
        for (VolumeSpecification vs : volumeSpecifications) {
            String value = vs.toString();
            if (!y) {
                value = value + ",readOnly";
            }
            properties.put("volume." + ++index, value);
        }
        if (jpath != null) {
            properties.put("journalpath", jpath);
        }
        properties.put("appendonly", "true");
        if (rmiport > 0) {
            properties.put("rmiport", Integer.toString(rmiport));
        }
        properties.put("jmx", "true");
        Persistit persistit = new Persistit();
        if (!y) {
            persistit.getRecoveryManager().setRecoveryDisabledForTestMode(true);
        }
        persistit.setProperties(properties);
        persistit.initialize();
        Volume sysvol = null;
        for (Volume volume : persistit.getVolumes()) {
            if (volume.getTree("_classIndex", false) == null) continue;
            if (sysvol == null) {
                sysvol = volume;
                continue;
            }
            sysvol = null;
            break;
        }
        if (sysvol != null) {
            persistit.getConfiguration().setSysVolume(sysvol.getName());
        }
        this._persistit = persistit;
        return "Last valid checkpoint=" + persistit.getRecoveryManager().getLastValidCheckpoint().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Cmd(value="close")
    String close(@Arg(value="_flag|f|Flush modifications to disk") boolean flush) throws Exception {
        if (this._persistit != null) {
            try {
                if (this._live) {
                    String string = "Detaching from live Persistit instance without closing it";
                    return string;
                }
                this._persistit.shutdownGUI();
                this._persistit.close(flush);
            }
            catch (Exception e) {
                String string = e.toString();
                return string;
            }
            finally {
                this._persistit = null;
                this._currentVolume = null;
                this._currentTree = null;
            }
        }
        return "ok";
    }

    @Cmd(value="list")
    Task list(final @Arg(value="trees|string:*|Volume and/or tree specification") String tstring, final @Arg(value="_flag|r|Regular expression") boolean r) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                if (this._persistit == null) {
                    this.postMessage("Persistit not loaded", 0);
                    return;
                }
                TreeSelector selector = TreeSelector.parseSelector(tstring, r, '\\');
                StringBuilder sb = new StringBuilder();
                for (Volume volume : this._persistit.getVolumes()) {
                    if (!selector.isVolumeNameSelected(volume.getName())) continue;
                    sb.append(volume);
                    sb.append(Util.NEW_LINE);
                    for (String treeName : volume.getTreeNames()) {
                        if (!selector.isTreeNameSelected(volume.getName(), treeName)) continue;
                        Tree tree = volume.getTree(treeName, false);
                        sb.append("   ");
                        sb.append(tree);
                        sb.append(Util.NEW_LINE);
                    }
                }
                this.postMessage(sb.toString(), 0);
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="jview")
    Task jview(final @Arg(value="path|string:|Journal file name") String path, final @Arg(value="start|long:0:0:10000000000000|Start journal address") long start, final @Arg(value="end|long:1000000000000000000:0:1000000000000000000|End journal address") long end, final @Arg(value="types|String:*|Selected record types, for example, \"PA,PM,CP\"") String types, final @Arg(value="pages|String:*|Selected pages, for example, \"0,1,200-299,33333-\"") String pages, final @Arg(value="timestamps|String:*|Selected timestamps, for example, \"132466-132499\"") String timestamps, final @Arg(value="maxkey|int:42:4:10000|Maximum displayed key length") int maxkey, final @Arg(value="maxvalue|int:42:4:100000|Maximum displayed value length") int maxvalue, final @Arg(value="_flag|v|Verbose dump - includes PageMap and TransactionMap details") boolean v) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                JournalTool jt = new JournalTool(this._persistit);
                jt.setAction(new JournalTool.SimpleDumpAction(jt){

                    @Override
                    protected void write(String msg) {
                        this.postMessage(msg, 0);
                    }
                });
                jt.init(path, start, end, types, pages, timestamps, maxkey, maxvalue, v);
                jt.setWriter(new PrintWriter(System.out));
                jt.scan();
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="source")
    Task source(final @Arg(value="file|string|Read commands from file") String fileName) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                if (!fileName.isEmpty()) {
                    FileReader in = new FileReader(fileName);
                    CLI.this._sourceStack.push(new BufferedReader(new BufferedReader(in)));
                    this.postMessage(String.format("Source is %s", fileName), 0);
                    return;
                }
                CLI.this._sourceStack.clear();
                this.postMessage("Source is console", 0);
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="adminui")
    Task adminui(final @Arg(value="_flag|g|Start") boolean g, final @Arg(value="_flag|x|Stop") boolean x) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                if (this._persistit == null) {
                    this.postMessage("Persistit not loaded", 0);
                    return;
                }
                if (g) {
                    this._persistit.setupGUI(false);
                    this.postMessage("Started AdminUI", 0);
                    return;
                }
                if (x) {
                    this._persistit.shutdownGUI();
                    this.postMessage("Stopped AdminUI", 0);
                    return;
                }
                this.postMessage("No action specified", 0);
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="select")
    Task select(final @Arg(value="tree|string:*|Volume and and/or tree specification") String tstring, final @Arg(value="_flag|r|Regular expression") boolean r) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                CLI.this._currentTree = null;
                CLI.this._currentVolume = null;
                if (this._persistit == null) {
                    this.postMessage("Persistit not loaded", 0);
                    return;
                }
                ArrayList<Object> selected = new ArrayList<Object>();
                TreeSelector selector = TreeSelector.parseSelector(tstring, r, '\\');
                for (Volume volume : this._persistit.getVolumes()) {
                    if (!selector.isVolumeNameSelected(volume.getName())) continue;
                    if (selector.isVolumeOnlySelection(volume.getName())) {
                        selected.add(volume);
                        continue;
                    }
                    for (String treeName : volume.getTreeNames()) {
                        if (!selector.isTreeNameSelected(volume.getName(), treeName)) continue;
                        selected.add(volume.getTree(treeName, false));
                    }
                }
                if (selected.isEmpty()) {
                    this.postMessage("No volumes or trees selected", 0);
                    return;
                }
                if (selected.size() > 1) {
                    this.postMessage("Too many volumes or trees selected: " + selected, 0);
                    return;
                }
                if (selected.get(0) instanceof Volume) {
                    CLI.this._currentVolume = (Volume)selected.get(0);
                    CLI.this._currentTree = null;
                    this.postMessage(String.format("Volume %s selected", CLI.this._currentVolume), 0);
                } else {
                    CLI.this._currentTree = (Tree)selected.get(0);
                    CLI.this._currentVolume = CLI.this._currentTree.getVolume();
                    this.postMessage(String.format("Volume %s tree %s selected", CLI.this._currentVolume, CLI.this._currentTree), 0);
                }
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="path")
    Task path(final @Arg(value="key|string|Key") String keyString) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                int depth;
                if (this._persistit == null) {
                    this.postMessage("Persistit not loaded", 0);
                    return;
                }
                if (CLI.this._currentVolume == null || CLI.this._currentTree == null) {
                    this.postMessage("Tree not selected", 0);
                    return;
                }
                Exchange exchange = new Exchange(CLI.this._currentTree);
                if (!keyString.isEmpty()) {
                    new KeyParser(keyString).parseKey(exchange.getKey());
                }
                StringBuilder sb = new StringBuilder();
                int level = depth = CLI.this._currentTree.getDepth();
                while (--level >= 0) {
                    Buffer copy = exchange.fetchBufferCopy(level);
                    if (sb.length() > 0) {
                        sb.append(Util.NEW_LINE);
                    }
                    sb.append(copy);
                }
                this.postMessage(sb.toString(), 0);
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="pview")
    Task pview(final @Arg(value="page|long:-1:-1:99999999999999999|Page address") long pageAddress, final @Arg(value="jaddr|long:-1:-1:99999999999999999|Journal address of a PA page record") long journalAddress, final @Arg(value="index|int:-1:-1:999999999|Buffer pool index") int index, final @Arg(value="pageSize|int:16384:1024:16384|Buffer pool index") int pageSize, final @Arg(value="level|int:0:0:30|Tree level") int level, final @Arg(value="key|string|Key") String keyString, final @Arg(value="find|long:-1:0:99999999999999999|Optional page pointer to find") long findPointer, final @Arg(value="maxkey|int:42:4:10000|Maximum displayed key length") int maxkey, final @Arg(value="maxvalue|int:42:4:100000|Maximum displayed value length") int maxvalue, final @Arg(value="context|int:3:0:100000|Context lines") int context, final @Arg(value="_flag|a|All lines") boolean allLines, final @Arg(value="_flag|s|Summary only") boolean summary) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                Buffer buffer;
                if (this._persistit == null) {
                    this.postMessage("Persistit not loaded", 0);
                    return;
                }
                int specified = 0;
                if (pageAddress >= 0L) {
                    ++specified;
                }
                if (journalAddress >= 0L) {
                    ++specified;
                }
                if (index >= 0) {
                    ++specified;
                }
                if (!keyString.isEmpty()) {
                    ++specified;
                }
                if (specified != 1) {
                    this.postMessage("Specify one of key=<key>, page=<page address> or journal=<journal address>", 0);
                    return;
                }
                if (index >= 0) {
                    BufferPool pool = this._persistit.getBufferPool(pageSize);
                    buffer = pool.getBufferCopy(index);
                } else if (journalAddress >= 0L) {
                    buffer = this._persistit.getJournalManager().readPageBuffer(journalAddress);
                    if (buffer == null) {
                        this.postMessage(String.format("Journal address %,d is not a valid PA record", journalAddress), 0);
                        return;
                    }
                    buffer.setValid();
                } else if (pageAddress >= 0L) {
                    if (CLI.this._currentVolume == null) {
                        this.postMessage("Select a volume", 0);
                        return;
                    }
                    buffer = CLI.this._currentVolume.getPool().getBufferCopy(CLI.this._currentVolume, pageAddress);
                } else {
                    if (CLI.this._currentTree == null) {
                        this.postMessage("Select a tree", 0);
                        return;
                    }
                    Exchange exchange = new Exchange(CLI.this._currentTree);
                    if (!keyString.isEmpty()) {
                        new KeyParser(keyString).parseKey(exchange.getKey());
                    }
                    buffer = exchange.fetchBufferCopy(level);
                }
                if (summary) {
                    this.postMessage(buffer.toString(), 0);
                    return;
                }
                this.postMessage(buffer.toStringDetail(findPointer, maxkey, maxvalue, context, allLines), 0);
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="pviewchain")
    Task pviewchain(final @Arg(value="page|long:0:0:99999999999999999|Starting page address") long pageAddress, final @Arg(value="find|long:-1:0:99999999999999999|Optional page pointer to find") long findPointer, final @Arg(value="count|int:32:1:1000000|Maximum number of pages to display") long maxcount, final @Arg(value="maxkey|int:42:4:10000|Maximum displayed key length") int maxkey, final @Arg(value="maxvalue|int:42:4:100000|Maximum displayed value length") int maxvalue, final @Arg(value="context|int:3:0:100000|Context lines") int context, final @Arg(value="_flag|a|All lines") boolean allLines, final @Arg(value="_flag|s|Summary only") boolean summary) {
        return new Task(){

            @Override
            protected void runTask() throws Exception {
                long currentPage = pageAddress;
                int count = 0;
                while (currentPage > 0L && (long)count++ < maxcount) {
                    if (CLI.this._currentVolume == null) {
                        this.postMessage("Select a volume", 0);
                        return;
                    }
                    Buffer buffer = CLI.this._currentVolume.getPool().getBufferCopy(CLI.this._currentVolume, currentPage);
                    if (summary) {
                        this.postMessage(buffer.toString(), 0);
                    } else {
                        this.postMessage(buffer.toStringDetail(findPointer, maxkey, maxvalue, context, allLines), 0);
                    }
                    currentPage = buffer.getRightSibling();
                }
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="jquery")
    Task jquery(final @Arg(value="page|long:-1|Page address for PageNode to look up") long pageAddress, final @Arg(value="volumeHandle|int:-1|Volume handle for PageNode to look up") int volumeHandle, final @Arg(value="ts|long:-1|Start timestamp of TransactionMapItem to look up") long ts, final @Arg(value="_flag|v|Verbose") boolean verbose, final @Arg(value="_flag|V|Show volume handle map") boolean showTreeMap, final @Arg(value="_flag|T|Show tree handle map") boolean showVolumeMap) {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                SortedMap<Integer, Object> map;
                if (!showVolumeMap && !showTreeMap && pageAddress == -1L && ts == -1L) {
                    this.postMessage("No items requested", 0);
                    return;
                }
                if (showVolumeMap) {
                    this.postMessage("Volume Handle Map", 0);
                    map = this._persistit.getJournalManager().queryVolumeMap();
                    for (Map.Entry entry : map.entrySet()) {
                        this.postMessage(String.format("%,5d -> %s", entry.getKey(), entry.getValue()), 0);
                    }
                }
                if (showVolumeMap) {
                    this.postMessage("Tree Handle Map", 0);
                    map = this._persistit.getJournalManager().queryTreeMap();
                    for (Map.Entry entry : map.entrySet()) {
                        this.postMessage(String.format("%,5d -> %s", entry.getKey(), entry.getValue()), 0);
                    }
                }
                if (ts != -1L) {
                    JournalManager.TransactionMapItem item = this._persistit.getJournalManager().queryTransactionMap(ts);
                    this.postMessage(String.format("TransactionMapItem for ts=%,d -> %s", ts, item), 0);
                }
                if (pageAddress != -1L) {
                    this.postMessage("Page Nodes", 0);
                    if (volumeHandle != -1) {
                        this.queryPageNode(volumeHandle, pageAddress, verbose);
                    } else {
                        SortedMap<Integer, Volume> volumeMap = this._persistit.getJournalManager().queryVolumeMap();
                        Iterator i$ = volumeMap.keySet().iterator();
                        while (i$.hasNext()) {
                            int handle = (Integer)((Object)i$.next());
                            this.queryPageNode(handle, pageAddress, verbose);
                        }
                    }
                }
            }

            private void queryPageNode(int volumeHandle2, long page, boolean verbose2) {
                int count = 0;
                for (JournalManager.PageNode pn = this._persistit.getJournalManager().queryPageNode(volumeHandle2, pageAddress); pn != null && count++ < 10000; pn = pn.getPrevious()) {
                    this.postMessage(String.format("%,5d: %s", count, pn), 0);
                    if (!verbose2) break;
                }
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="dump")
    Task dump(final @Arg(value="file|string|Name of file to receive output") String file, final @Arg(value="_flag|s|Secure") boolean secure, final @Arg(value="_flag|o|Overwrite file") boolean ovewrite, final @Arg(value="_flag|v|Verbose") boolean verbose) throws Exception {
        return new Task(){

            @Override
            public void runTask() throws Exception {
                File target = new File(file);
                if (target.exists() && !ovewrite) {
                    throw new IOException(file + " already exists");
                }
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target), 0x100000));
                String basePath = "PersistitDump_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
                long baseTime = System.currentTimeMillis();
                zos.setLevel(8);
                ZipEntry ze = new ZipEntry(JournalManager.generationToFile(basePath, 0L).getPath());
                ze.setSize(Integer.MAX_VALUE);
                ze.setTime(baseTime);
                zos.putNextEntry(ze);
                DataOutputStream stream = new DataOutputStream(zos);
                ByteBuffer bb = ByteBuffer.allocate(0x100000);
                JournalRecord.JH.putType(bb);
                JournalRecord.JH.putTimestamp(bb, 0L);
                JournalRecord.JH.putVersion(bb, 2L);
                JournalRecord.JH.putBlockSize(bb, 1000000000000L);
                JournalRecord.JH.putBaseJournalAddress(bb, 0L);
                JournalRecord.JH.putCurrentJournalAddress(bb, 0L);
                JournalRecord.JH.putJournalCreatedTime(bb, 0L);
                JournalRecord.JH.putFileCreatedTime(bb, 0L);
                JournalRecord.JH.putPath(bb, basePath);
                bb.position(JournalRecord.JH.getLength(bb));
                ArrayList<BufferPool> pools = new ArrayList<BufferPool>(this._persistit.getBufferPoolHashMap().values());
                for (BufferPool pool : pools) {
                    pool.dump(stream, bb, secure, verbose);
                }
                JournalRecord.CP.putLength(bb, 32);
                JournalRecord.CP.putType(bb);
                JournalRecord.CP.putTimestamp(bb, this._persistit.getTimestampAllocator().getCurrentTimestamp() + 1L);
                JournalRecord.CP.putSystemTimeMillis(bb, baseTime);
                JournalRecord.CP.putBaseAddress(bb, 0L);
                bb.position(32);
                bb.flip();
                stream.write(bb.array(), 0, bb.limit());
                stream.flush();
                zos.closeEntry();
                bb.clear();
                PrintWriter writer = new PrintWriter(zos);
                ze = new ZipEntry(basePath + ".txt");
                ze.setSize(Integer.MAX_VALUE);
                ze.setTime(baseTime);
                zos.putNextEntry(ze);
                List<Volume> volumes = this._persistit.getVolumes();
                writer.printf("@volumes=%d\n", volumes.size());
                for (Volume volume : volumes) {
                    writer.printf("%s\n", volume.toString());
                    List<Tree> trees = volume.getStructure().referencedTrees();
                    writer.printf("@trees=%d\n", trees.size());
                    for (Tree tree : trees) {
                        writer.printf("%s\n", tree.toString());
                    }
                }
                writer.printf("@bufferPools=%d\n", pools.size());
                for (BufferPool pool : pools) {
                    writer.printf("%s\n", pool.toString());
                    writer.printf("@buffers=%d\n", pool.getBufferCount());
                    for (int i = 0; i < pool.getBufferCount(); ++i) {
                        writer.printf("%s\n", pool.toString(i, false));
                    }
                }
                writer.flush();
                zos.closeEntry();
                stream.close();
            }

            @Override
            public String getStatus() {
                return "";
            }
        };
    }

    @Cmd(value="help")
    Task help() throws Exception {
        return new Task(){

            @Override
            public void runTask() {
                for (Command command : COMMANDS.values()) {
                    this.postMessage(command.toString(), 0);
                    this.postMessage("", 0);
                }
            }

            @Override
            public String getStatus() {
                return "done";
            }
        };
    }

    @Cmd(value="cliserver")
    static Task cliserver(final @Arg(value="port|int:9999:1024:99999999") int port) throws Exception {
        Task task = new Task(){
            CLI _cli;

            @Override
            protected void runTask() throws Exception {
                this._cli = new CLI(this._persistit, port);
                this._cli.commandLoop();
            }

            @Override
            public String getStatus() {
                String status;
                CLI cli = this._cli;
                if (cli != null && (status = cli._lastStatus) != null) {
                    return status;
                }
                return "Not initialized yet";
            }
        };
        return task;
    }

    private static String journalPath(List<String> files) {
        String journalPath = null;
        for (String file : files) {
            Matcher matcher = JournalManager.PATH_PATTERN.matcher(file);
            if (!matcher.matches()) continue;
            String path = matcher.group(1);
            if (journalPath == null) {
                journalPath = path;
                continue;
            }
            if (journalPath.equals(path)) continue;
            throw new IllegalArgumentException("Journal path is not unique: " + journalPath + " / " + path);
        }
        return journalPath;
    }

    private static List<VolumeSpecification> volumeSpecifications(List<String> files, long systemTimestamp) {
        ArrayList<VolumeSpecification> list = new ArrayList<VolumeSpecification>();
        for (String path : files) {
            if (JournalManager.PATH_PATTERN.matcher(path).matches()) continue;
            try {
                VolumeSpecification specification = new VolumeSpecification(path);
                if (!VolumeHeader.verifyVolumeHeader(specification, systemTimestamp)) continue;
                list.add(specification);
            }
            catch (PersistitException e) {}
        }
        return list;
    }

    private static List<String> filesOnPath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        File dir = new File(path);
        String name = "";
        if (!dir.isDirectory()) {
            name = dir.getName();
            dir = dir.getParentFile();
        }
        for (String candidate : dir.list()) {
            if (!candidate.startsWith(name)) continue;
            list.add(new File(dir, candidate).getPath());
        }
        Collections.sort(list);
        return list;
    }

    static KeyFilter toKeyFilter(String keyFilterString) {
        if (keyFilterString == null || keyFilterString.isEmpty()) {
            return new KeyFilter();
        }
        return new KeyFilter(keyFilterString);
    }

    static Pattern toRegEx(String pattern, boolean simple) {
        if (pattern == null || pattern.isEmpty()) {
            return ALL;
        }
        if (simple) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < pattern.length(); ++index) {
                char c = pattern.charAt(index);
                if (c == '.') {
                    sb.append("\\.");
                    continue;
                }
                if (c == '*') {
                    sb.append(".*");
                    continue;
                }
                if (c == '?') {
                    sb.append(".");
                    continue;
                }
                sb.append(c);
            }
            return Pattern.compile(sb.toString());
        }
        return Pattern.compile(pattern);
    }

    static {
        for (Class<?> clazz : CLASSES = new Class[]{CLI.class, BackupTask.class, IntegrityCheck.class, StreamSaver.class, StreamLoader.class, StatisticsTask.class, TaskCheck.class, VolumeHeader.class}) {
            CLI.registerCommands(clazz);
        }
        ALL = Pattern.compile(".*");
    }

    private static class NotOpenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NotOpenException() {
        }
    }

    private static class Command {
        final String name;
        final String[] argTemplate;
        final Method method;

        private Command(String name, String[] argTemplate, Method method) {
            this.name = name;
            this.argTemplate = argTemplate;
            this.method = method;
        }

        private String execute(CLI cli, ArgParser ap) throws Exception {
            Object[] args = this.invocationArgs(ap);
            if (this.method.getReturnType() == String.class) {
                String result = (String)this.method.invoke((Object)cli, args);
                return result;
            }
            if (Task.class.isAssignableFrom(this.method.getReturnType())) {
                Task task = (Task)this.method.invoke((Object)cli, args);
                task.setPersistit(cli._persistit);
                task.setMaximumTime(-1L);
                task.setMessageWriter(cli._writer);
                task.runTask();
                task.setPersistit(null);
                return task.getStatus();
            }
            throw new IllegalStateException(this + " must return either a Task or a String");
        }

        private Task createTask(Persistit persistit, ArgParser ap) throws Exception {
            if (Task.class.isAssignableFrom(this.method.getReturnType())) {
                CLI cli = persistit.getSessionCLI();
                Object[] args = this.invocationArgs(ap);
                Task task = (Task)this.method.invoke((Object)cli, args);
                return task;
            }
            return null;
        }

        private Object[] invocationArgs(ArgParser ap) {
            Class<?>[] types = this.method.getParameterTypes();
            Object[] args = new Object[types.length];
            for (int index = 0; index < types.length; ++index) {
                Class<?> type = types[index];
                if (String.class.equals(type)) {
                    args[index] = ap.stringValue(index);
                    continue;
                }
                if (Integer.TYPE.equals(type)) {
                    args[index] = ap.intValue(index);
                    continue;
                }
                if (Long.TYPE.equals(type)) {
                    args[index] = ap.longValue(index);
                    continue;
                }
                if (Boolean.TYPE.equals(type)) {
                    args[index] = ap.booleanValue(index);
                    continue;
                }
                throw new IllegalArgumentException("Method " + this.method + " takes an unsupported argument type " + type);
            }
            return args;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append(Util.NEW_LINE);
            sb.append(new ArgParser(this.name, new String[0], this.argTemplate).strict());
            return sb.toString();
        }
    }

    private static class ScriptReader
    implements LineReader {
        private final BufferedReader _reader;
        private final PrintWriter _writer;

        private ScriptReader(BufferedReader reader, PrintWriter writer) {
            this._reader = reader;
            this._writer = writer;
        }

        @Override
        public String readLine() throws IOException {
            String line = this._reader.readLine();
            if (line != null) {
                this._writer.println();
                this._writer.println(">> " + line);
                this._writer.flush();
            }
            return line;
        }

        @Override
        public PrintWriter writer() {
            return this._writer;
        }

        @Override
        public void close() throws IOException {
            this._reader.close();
            this._writer.close();
        }
    }

    private static class NetworkReader
    implements LineReader {
        final ServerSocket serverSocket;
        Socket socket;
        PrintWriter writer;

        private NetworkReader(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
        }

        @Override
        public String readLine() throws IOException {
            this.close();
            this.socket = this.serverSocket.accept();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            return reader.readLine();
        }

        @Override
        public PrintWriter writer() {
            return this.writer;
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
    }

    private class NullReader
    implements LineReader {
        private NullReader() {
        }

        @Override
        public String readLine() throws IOException {
            return null;
        }

        @Override
        public PrintWriter writer() {
            return CLI.this._writer;
        }

        @Override
        public void close() throws IOException {
        }
    }

    static interface LineReader {
        public String readLine() throws IOException;

        public PrintWriter writer();

        public void close() throws IOException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Arg {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Cmd {
        public String value();
    }
}

