/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.BufferPool;
import com.persistit.CleanupManager;
import com.persistit.Exchange;
import com.persistit.FastIndex;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.KeyState;
import com.persistit.LongRecordHelper;
import com.persistit.MVV;
import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.SharedResource;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.ValueHelper;
import com.persistit.ValueState;
import com.persistit.Volume;
import com.persistit.VolumeHeader;
import com.persistit.exception.InUseException;
import com.persistit.exception.InvalidPageAddressException;
import com.persistit.exception.InvalidPageStructureException;
import com.persistit.exception.InvalidPageTypeException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.RebalanceException;
import com.persistit.exception.VolumeClosedException;
import com.persistit.policy.JoinPolicy;
import com.persistit.policy.SplitPolicy;
import com.persistit.util.Debug;
import com.persistit.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Buffer
extends SharedResource {
    public static final int MIN_BUFFER_SIZE = 1024;
    public static final int MAX_BUFFER_SIZE = 16384;
    public static final int PAGE_TYPE_UNALLOCATED = 0;
    public static final int PAGE_TYPE_DATA = 1;
    public static final int PAGE_TYPE_INDEX_MIN = 2;
    public static final int PAGE_TYPE_INDEX_MAX = 21;
    public static final int PAGE_TYPE_GARBAGE = 30;
    public static final int PAGE_TYPE_LONG_RECORD = 31;
    public static final int PAGE_TYPE_MAX = 31;
    public static final int PAGE_TYPE_HEAD = 32;
    public static final String[] TYPE_NAMES = new String[]{"Unused", "Data", "Index1", "Index2", "Index3", "Index4", "Index5", "Index6", "Index7", "Index8", "Index9", "Index10", "Index11", "Index12", "Index13", "Index14", "Index15", "Index16", "Index17", "Index18", "Index19", "Index20", "Invalid", "Invalid", "Invalid", "Invalid", "Invalid", "Invalid", "Invalid", "Invalid", "Garbage", "LongRec", "Head"};
    public static final int HEADER_SIZE = 32;
    static final long MAX_VALID_PAGE_ADDR = 0x7FFFFFFEL;
    static final int TYPE_OFFSET = 0;
    static final int BUFFER_LENGTH_OFFSET = 1;
    static final int KEY_BLOCK_END_OFFSET = 2;
    static final int FREE_OFFSET = 4;
    static final int SLACK_OFFSET = 6;
    static final int PAGE_ADDRESS_OFFSET = 8;
    static final int RIGHT_SIBLING_OFFSET = 16;
    static final int TIMESTAMP_OFFSET = 24;
    static final int KEY_BLOCK_START = 32;
    static final int KEYBLOCK_LENGTH = 4;
    static final int KEYBLOCK_MASK = -4;
    static final int TAILBLOCK_HDR_SIZE_DATA = 4;
    static final int TAILBLOCK_HDR_SIZE_INDEX = 8;
    static final int TAILBLOCK_POINTER = 4;
    static final int TAILBLOCK_FACTOR = 4;
    static final int TAILBLOCK_MASK = -4;
    static final int TAILBLOCK_SIZE_MASK = 65535;
    static final int TAILBLOCK_KLENGTH_MASK = 0xFFF0000;
    static final int TAILBLOCK_INUSE_MASK = 0x10000000;
    static final int TAILBLOCK_KLENGTH_SHIFT = 16;
    static final int EXACT_MASK = 1;
    static final int P_MASK = 65532;
    static final int DEPTH_MASK = 0xFFF0000;
    static final int DEPTH_SHIFT = 16;
    static final int FIXUP_MASK = 0x40000000;
    private static final int DB_MASK = 255;
    private static final int EBC_MASK = 1048320;
    private static final int TAIL_MASK = -1048576;
    private static final int EBC_SHIFT = 8;
    private static final int TAIL_SHIFT = 18;
    static final int GARBAGE_BLOCK_SIZE = 32;
    private static final int GARBAGE_BLOCK_STATUS = 4;
    private static final int GARBAGE_BLOCK_LEFT_PAGE = 8;
    private static final int GARBAGE_BLOCK_RIGHT_PAGE = 16;
    private static final int GARBAGE_BLOCK_EXPECTED_COUNT = 24;
    static final int LONGREC_TYPE = 255;
    static final int LONGREC_PREFIX_SIZE_OFFSET = 2;
    static final int LONGREC_SIZE_OFFSET = 4;
    static final int LONGREC_PAGE_OFFSET = 12;
    static final int LONGREC_PREFIX_SIZE = 100;
    static final int LONGREC_PREFIX_OFFSET = 20;
    static final int LONGREC_SIZE = 120;
    static final int ANTIVALUE_TYPE = 49;
    static final int INDEX_PAGE_OVERHEAD = 56;
    static final int DATA_PAGE_OVERHEAD = 48;
    static final int MAX_LONG_RECORD_CHAIN = 5000;
    private static final int ESTIMATED_FIXED_BUFFER_OVERHEAD = 200;
    public static final int MAX_KEY_RATIO = 16;
    private static final int BINARY_SEARCH_THRESHOLD = 6;
    private static final int PRUNE_MVV_HELPER_CHANGED = 1;
    private static final int PRUNE_MVV_HELPER_HAS_LONG = 2;
    boolean _toStringDebug = false;
    private final BufferPool _pool;
    private final int _poolIndex;
    private volatile long _page;
    private volatile Volume _vol;
    private volatile long _timestamp;
    private final ByteBuffer _byteBuffer;
    private final int _bufferSize;
    private final byte[] _bytes;
    private final FastIndex _fastIndex;
    private volatile long _rightSibling;
    private volatile int _type;
    private volatile int _tailHeaderSize = 4;
    private volatile int _keyBlockEnd;
    private volatile int _alloc;
    private volatile int _slack;
    private volatile int _mvvCount;
    private Buffer _next = null;
    private volatile long _lastPrunedTime;
    private volatile boolean _enqueuedForAntiValuePruning;

    Buffer(int size, int index, BufferPool pool, Persistit persistit) {
        super(persistit);
        boolean ok = false;
        for (int s = 1024; !ok && s <= 16384; s *= 2) {
            if (s != size) continue;
            ok = true;
        }
        if (!ok) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        this._pool = pool;
        this._poolIndex = index;
        this._byteBuffer = ByteBuffer.allocate(size &= 0xFFFFFFFC);
        this._bytes = this._byteBuffer.array();
        this._bufferSize = size;
        this._fastIndex = new FastIndex(this, 1 + (size - 32) / 16);
    }

    Buffer(Buffer original) {
        this(original._bufferSize, original._poolIndex, original._pool, original._persistit);
        this.setStatus(original);
        this._type = original._type;
        this._timestamp = original._timestamp;
        this._page = original._page;
        this._vol = original._vol;
        this._rightSibling = original._rightSibling;
        this._alloc = original._alloc;
        this._slack = original._slack;
        this._mvvCount = original._mvvCount;
        this.setKeyBlockEnd(original._keyBlockEnd);
        this._tailHeaderSize = original._tailHeaderSize;
        System.arraycopy(original._bytes, 0, this._bytes, 0, this._bytes.length);
    }

    void init(int type) {
        assert (this.isOwnedAsWriterByMe());
        this._type = type;
        this.setKeyBlockEnd(32);
        this._tailHeaderSize = this.isIndexPage() ? 8 : 4;
        this._rightSibling = 0L;
        this._alloc = this._bufferSize;
        this._slack = 0;
        this._mvvCount = 0;
        this.clearEnqueuedForPruning();
        this.bumpGeneration();
    }

    void clearEnqueuedForPruning() {
        this._enqueuedForAntiValuePruning = false;
        this._lastPrunedTime = 0L;
    }

    void load(Volume vol, long page) throws PersistitIOException, InvalidPageAddressException, InvalidPageStructureException, VolumeClosedException, InUseException, PersistitInterruptedException {
        this._vol = vol;
        this._page = page;
        vol.getStorage().readPage(this);
        this.load();
    }

    void load() throws InvalidPageStructureException {
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        this._timestamp = this.getLong(24);
        if (this._page != 0L) {
            int type = this.getByte(0);
            if (type > 31) {
                throw new InvalidPageStructureException("Invalid type " + type);
            }
            this._type = type;
            this.setKeyBlockEnd(this.getChar(2));
            if (type == 0) {
                this._rightSibling = 0L;
                this._alloc = this._bufferSize;
                this._slack = 0;
                this._rightSibling = 0L;
            } else {
                Debug.$assert0.t(this.getByte(1) * 256 == this._bufferSize);
                Debug.$assert0.t(this.getLong(8) == this._page);
                this._alloc = this.getChar(4);
                this._slack = this.getChar(6);
                this._rightSibling = this.getLong(16);
                if (this.isDataPage()) {
                    this._tailHeaderSize = 4;
                    this._mvvCount = Integer.MAX_VALUE;
                    this.clearEnqueuedForPruning();
                } else if (this.isIndexPage()) {
                    this._tailHeaderSize = 8;
                }
            }
        } else {
            this._type = 32;
        }
        this.invalidateFastIndex();
        this.bumpGeneration();
    }

    void writePageOnCheckpoint(long timestamp) throws PersistitException {
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        long checkpointTimestamp = this._persistit.getTimestampAllocator().getProposedCheckpointTimestamp();
        if (this.isDirty() && !this.isTemporary() && this.getTimestamp() < checkpointTimestamp && timestamp > checkpointTimestamp) {
            this.writePage(false);
            this._pool.bumpForcedCheckpointWrites();
        }
    }

    void writePage() throws PersistitException {
        this.writePage(this._persistit.getJournalManager().isWritePagePruningEnabled());
    }

    void writePage(boolean prune) throws PersistitException {
        assert (this.isOwnedAsWriterByMe());
        this._persistit.checkFatal();
        Volume volume = this.getVolume();
        if (volume != null) {
            if (prune) {
                this.pruneMvvValues(null, false, null);
            }
            this.clearSlack();
            this.save();
            this._vol.getStorage().writePage(this);
            this.clearDirty();
            volume.getStatistics().bumpWriteCounter();
            this._pool.bumpWriteCounter();
        }
    }

    @Override
    boolean clearDirty() {
        if (super.clearDirty()) {
            this._pool.decrementDirtyPageCount();
            return true;
        }
        return false;
    }

    @Override
    boolean setDirty() {
        throw new UnsupportedOperationException();
    }

    void setDirtyAtTimestamp(long timestamp) {
        if (!this.isOwnedAsWriterByMe()) {
            throw new IllegalStateException("Exclusive claim required " + this);
        }
        if (super.setDirty()) {
            this._pool.incrementDirtyPageCount();
        }
        this._timestamp = timestamp;
        this.bumpGeneration();
    }

    @Override
    boolean claim(boolean writer) throws PersistitInterruptedException {
        return this.claim(writer, 60000L);
    }

    @Override
    boolean claim(boolean writer, long timeout) throws PersistitInterruptedException {
        if (super.claim(writer, timeout)) {
            if (!this.isDirty()) {
                this._timestamp = this._persistit.getCurrentTimestamp();
            }
            return true;
        }
        return false;
    }

    @Override
    void release() {
        super.release();
    }

    void releaseTouched() {
        this.setTouched();
        this.release();
    }

    void clear() {
        Util.clearBytes(this._bytes, 0, this._bufferSize);
    }

    void clearBytes(int from, int to) {
        Util.clearBytes(this._bytes, from, to);
    }

    void clearSlack() throws InvalidPageStructureException {
        if (this.isGarbagePage()) {
            Util.clearBytes(this._bytes, this._keyBlockEnd, this._alloc);
        } else if (this.isDataPage() || this.isIndexPage()) {
            this.repack();
            this.clearBytes(this._keyBlockEnd, this._alloc);
        }
    }

    void save() {
        this.putLong(24, this._timestamp);
        if (this._page != 0L) {
            this.putByte(0, this._type);
            this.putByte(1, this._bufferSize / 256);
            this.putChar(2, this._keyBlockEnd);
            this.putChar(4, this._alloc);
            this.putChar(6, this._slack);
            this.putLong(8, this._page);
            this.putLong(16, this._rightSibling);
        }
    }

    public Volume getVolume() {
        return this._vol;
    }

    public ByteBuffer getByteBuffer() {
        return this._byteBuffer;
    }

    public long getPageAddress() {
        return this._page;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public int getAvailableSize() {
        if (this._type == 1 || this._type >= 2 && this._type <= 21) {
            return this._alloc - this._keyBlockEnd + this._slack;
        }
        return 0;
    }

    public int getKeyCount() {
        return (this._keyBlockEnd - 32) / 4;
    }

    public int getAlloc() {
        return this._alloc;
    }

    public int getPageType() {
        return this._type;
    }

    public String getPageTypeName() {
        return Buffer.getPageTypeName(this._page, this._type);
    }

    public static String getPageTypeName(long page, int type) {
        if (page == 0L) {
            return TYPE_NAMES[32];
        }
        if (type == 0 || type == 1 || type >= 2 && type <= 21 || type == 30 || type == 31) {
            return TYPE_NAMES[type];
        }
        return "Invalid" + type;
    }

    public int getIndex() {
        return this._poolIndex;
    }

    public long getRightSibling() {
        return this._rightSibling;
    }

    public void setPageAddressAndVolume(long pageAddress, Volume volume) {
        this._page = pageAddress;
        this._vol = volume;
    }

    void setRightSibling(long pageAddress) {
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        this._rightSibling = pageAddress;
    }

    long getVolumeId() {
        Volume volume = this._vol;
        return volume == null ? 0L : volume.getId();
    }

    int getKeyBlockStart() {
        return 32;
    }

    int getKeyBlockEnd() {
        return this._keyBlockEnd;
    }

    int getMvvCount() {
        return this._mvvCount;
    }

    void setKeyBlockEnd(int index) {
        Debug.$assert0.t(index >= 32 && index <= this._pool.getMaxKeys() * 4 + 32 || !this.isDataPage() && !this.isIndexPage() || !this.isValid());
        this._keyBlockEnd = index;
    }

    void setAlloc(int alloc) {
        Debug.$assert0.t(alloc >= 0 && alloc <= this._bufferSize);
        this._alloc = alloc;
    }

    void setNext(Buffer buffer) {
        Debug.$assert0.t(buffer != this);
        this._next = buffer;
    }

    Buffer getNext() {
        return this._next;
    }

    int findKey(Key key) throws PersistitInterruptedException {
        FastIndex fastIndex = this.getFastIndex();
        byte[] kbytes = key.getEncodedBytes();
        int klength = key.getEncodedSize();
        int depth = 0;
        int left = 32;
        int right = this._keyBlockEnd;
        int start = left;
        int tailHeaderSize = this._tailHeaderSize;
        int p = start;
        while (p < right) {
            int kbData = this.getInt(p);
            int index = p - start >> 2;
            int runCount = fastIndex.getRunCount(index);
            int ebc = Buffer.decodeKeyBlockEbc(kbData);
            if (depth < ebc) {
                if (runCount < 0) {
                    runCount = -runCount;
                }
                p += 4 * (runCount + 1);
                continue;
            }
            if (depth > ebc) {
                int result = p | depth << 16;
                return result;
            }
            int kb = kbytes[depth] & 0xFF;
            int db = Buffer.decodeKeyBlockDb(kbData);
            if (kb < db) {
                int result = p | depth << 16;
                return result;
            }
            if (kb > db) {
                if (runCount > 0) {
                    int result;
                    int p2 = p + runCount * 4;
                    int kbData2 = this.getInt(p2);
                    int db2 = Buffer.decodeKeyBlockDb(kbData2);
                    if (runCount == 1) {
                        if (db2 > kb) {
                            result = p2 | depth << 16;
                            return result;
                        }
                        if (db2 < kb) {
                            int runCount2 = fastIndex.getRunCount(index + runCount);
                            assert (runCount2 <= 0);
                            p = p2 + 4 * (-runCount + 1);
                            continue;
                        }
                        p = p2;
                        db = db2;
                    } else if (db2 > kb) {
                        left = p;
                        right = p2;
                        if (runCount > 6) {
                            int distance = right - left >> 2;
                            int oldRight = right;
                            if (distance > kb - db + 1) {
                                right = left + (kb - db + 1 << 2);
                            }
                            if (distance > db2 - kb + 1) {
                                left = oldRight - (db2 - kb + 1 << 2);
                            }
                        }
                        while (right > left) {
                            p = left + right >> 1 & 0xFFFC;
                            if (p == left) {
                                result = right | depth << 16;
                                return result;
                            }
                            int db1 = this.getDb(p);
                            if (db1 == kb) {
                                db = db1;
                                break;
                            }
                            if (db1 > kb) {
                                right = p;
                                continue;
                            }
                            left = p;
                            db = db1;
                        }
                    } else {
                        if (db2 < kb) {
                            index = p2 - start >> 2;
                            runCount = fastIndex.getRunCount(index);
                            assert (runCount <= 0);
                            p = p2 + 4 * (-runCount + 1);
                            continue;
                        }
                        p = p2;
                        db = db2;
                    }
                } else {
                    p += 4 * (-runCount + 1);
                    continue;
                }
            }
            assert (db == kb);
            kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int tlength = Buffer.decodeTailBlockKLength(tbData) + depth + 1;
            int qlength = tlength < klength ? tlength : klength;
            boolean matched = true;
            if (++depth < qlength) {
                int q = tail + tailHeaderSize;
                kb = kbytes[depth];
                db = this._bytes[q++];
                while (kb == db && ++depth < qlength) {
                    kb = kbytes[depth];
                    db = this._bytes[q++];
                }
                if (kb != db) {
                    if ((kb &= 0xFF) < (db &= 0xFF)) {
                        int result = p | depth << 16 | 0x40000000;
                        return result;
                    }
                    matched = false;
                }
            }
            if (matched && depth == qlength) {
                int result;
                if (qlength == tlength) {
                    if (qlength == klength) {
                        result = p | depth << 16 | 1;
                        return result;
                    }
                } else if (tlength > qlength) {
                    result = p | depth << 16 | 0x40000000;
                    return result;
                }
            }
            p += 4;
        }
        int result = right | depth << 16;
        return result;
    }

    boolean isPrimordialAntiValue(int foundAt) {
        int p;
        if (this.isDataPage() && (p = foundAt & 0xFFFC) >= 32 && p < this._keyBlockEnd) {
            int kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int size = Buffer.decodeTailBlockSize(tbData);
            int offset = tail + this._tailHeaderSize + klength;
            int valueSize = size - klength - this._tailHeaderSize;
            return valueSize == 1 && this._bytes[offset] == 49;
        }
        return false;
    }

    long at(int foundAt) {
        int p;
        if ((this.isDataPage() || this.isIndexPage()) && (p = foundAt & 0xFFFC) >= 32 && p < this._keyBlockEnd) {
            int kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int size = Buffer.decodeTailBlockSize(tbData);
            int offset = tail + this._tailHeaderSize + klength;
            int valueSize = size - klength - this._tailHeaderSize;
            return (long)offset << 32 | (long)valueSize;
        }
        return -1L;
    }

    void keyAt(int foundAt, Key key) {
        Debug.$assert0.t(foundAt > 0 && foundAt < this._keyBlockEnd);
        if (this.isDataPage() || this.isIndexPage()) {
            for (int p = 32; p <= foundAt; p += 4) {
                int kbData = this.getInt(p);
                int tail = Buffer.decodeKeyBlockTail(kbData);
                int ebc = Buffer.decodeKeyBlockEbc(kbData);
                int db = Buffer.decodeKeyBlockDb(kbData);
                int tbData = this.getInt(tail);
                int klength = Buffer.decodeTailBlockKLength(tbData);
                byte[] keyBytes = key.getEncodedBytes();
                keyBytes[ebc] = (byte)db;
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, keyBytes, ebc + 1, klength);
                key.setEncodedSize(ebc + klength + 1);
            }
        }
    }

    Value fetch(int foundAt, Value value) {
        if ((foundAt & 1) == 0) {
            value.clear();
        } else {
            Debug.$assert0.t(foundAt > 0 && (foundAt & 0xFFFC) < this._keyBlockEnd);
            int kbData = this.getInt(foundAt & 0xFFFC);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int size = Buffer.decodeTailBlockSize(tbData);
            int valueSize = size - klength - this._tailHeaderSize;
            value.putEncodedBytes(this._bytes, tail + this._tailHeaderSize + klength, valueSize);
        }
        return value;
    }

    long fetchLongRecordPointer(int foundAt) {
        if (!this.isDataPage()) {
            return 0L;
        }
        int kbData = this.getInt(foundAt & 0xFFFC);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = this.getInt(tail);
        int klength = Buffer.decodeTailBlockKLength(tbData);
        int size = Buffer.decodeTailBlockSize(tbData);
        int valueSize = size - klength - this._tailHeaderSize;
        if (valueSize != 120) {
            return 0L;
        }
        if ((this._bytes[tail + this._tailHeaderSize + klength] & 0xFF) != 255) {
            return 0L;
        }
        long pointer = this.getLong(tail + this._tailHeaderSize + klength + 12);
        return pointer;
    }

    void neuterLongRecord(int foundAt) {
        assert (this.isDataPage()) : "Invalid page type for long records: " + this;
        int kbData = this.getInt(foundAt & 0xFFFC);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = this.getInt(tail);
        int klength = Buffer.decodeTailBlockKLength(tbData);
        int size = Buffer.decodeTailBlockSize(tbData);
        int valueSize = size - klength - this._tailHeaderSize;
        if (valueSize != 120) {
            return;
        }
        if ((this._bytes[tail + this._tailHeaderSize + klength] & 0xFF) != 255) {
            return;
        }
        this.putByte(tail + this._tailHeaderSize + klength, 49);
    }

    long getPointer(int foundAt) throws PersistitException {
        if (!this.isIndexPage()) {
            throw new InvalidPageTypeException("type=" + this._type);
        }
        int kbData = this.getInt(foundAt & 0xFFFC);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        return this.getInt(tail + 4);
    }

    int traverse(Key key, Key.Direction mode, int foundAt) {
        boolean exactMatch;
        boolean bl = exactMatch = (foundAt & 1) > 0;
        if (mode == Key.EQ || exactMatch && (mode == Key.LTEQ || mode == Key.GTEQ)) {
            return foundAt;
        }
        if (mode == Key.LT || mode == Key.LTEQ) {
            return this.previousKey(key, foundAt);
        }
        if (mode == Key.GT || mode == Key.GTEQ) {
            return this.nextKey(key, foundAt);
        }
        throw new IllegalArgumentException("Invalid mode: " + (Object)((Object)mode));
    }

    int previousKey(Key key, int foundAt) {
        int ebc;
        int p = (foundAt & 0xFFFC) - 4;
        int depth = (foundAt & 0xFFF0000) >>> 16;
        if (p < 32) {
            return foundAt;
        }
        byte[] kbytes = key.getEncodedBytes();
        int kbData2 = this.getInt(p + 4);
        int ebc2 = Buffer.decodeKeyBlockEbc(kbData2);
        int kbData = this.getInt(p);
        int knownGood = ebc = Buffer.decodeKeyBlockEbc(kbData);
        if (ebc2 < ebc) {
            knownGood = ebc2;
        }
        if (depth < knownGood) {
            knownGood = depth;
        }
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int unknown = Buffer.decodeTailBlockKLength(this.getInt(tail)) + ebc + 1;
        key.setEncodedSize(unknown);
        int result = p | unknown << 16 | 1;
        while (true) {
            if (ebc < unknown) {
                kbytes[ebc] = (byte)Buffer.decodeKeyBlockDb(kbData);
                int more = unknown - ebc - 1;
                if (more > 0) {
                    System.arraycopy(this._bytes, tail + this._tailHeaderSize, kbytes, ebc + 1, more);
                }
                unknown = ebc;
            }
            if (unknown <= knownGood) break;
            Debug.$assert1.t((p -= 4) >= 32);
            kbData = this.getInt(p);
            ebc = Buffer.decodeKeyBlockEbc(kbData);
            tail = Buffer.decodeKeyBlockTail(kbData);
        }
        return result;
    }

    int nextKey(Key key, int foundAt) {
        int p = foundAt & 0xFFFC;
        if ((foundAt & 1) != 0) {
            p += 4;
        }
        if (p >= this._keyBlockEnd) {
            return foundAt;
        }
        byte[] kbytes = key.getEncodedBytes();
        int kbData = this.getInt(p);
        int ebc = Buffer.decodeKeyBlockEbc(kbData);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = this.getInt(tail);
        int klength = Buffer.decodeTailBlockKLength(tbData);
        int keyLength = klength + ebc + 1;
        key.setEncodedSize(keyLength);
        int result = p | keyLength << 16 | 1;
        kbytes[ebc] = (byte)Buffer.decodeKeyBlockDb(kbData);
        System.arraycopy(this._bytes, tail + this._tailHeaderSize, kbytes, ebc + 1, klength);
        return result;
    }

    int nextLongRecord(Value value, int foundAt) {
        Debug.$assert0.t(this.isDataPage());
        for (int p = foundAt & 0xFFFC; p < this._keyBlockEnd; p += 4) {
            int kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int size = Buffer.decodeTailBlockSize(tbData);
            int valueSize = size - klength - this._tailHeaderSize;
            if (valueSize <= 0 || (this._bytes[tail + this._tailHeaderSize + klength] & 0xFF) != 255) continue;
            value.putEncodedBytes(this._bytes, tail + this._tailHeaderSize + klength, valueSize);
            return p;
        }
        return -1;
    }

    int previousKeyBlock(int foundAt) {
        int p = (foundAt & 0xFFFC) - 4;
        if (p < 32 || p > this._keyBlockEnd) {
            return -1;
        }
        return p;
    }

    int nextKeyBlock(int foundAt) {
        int p = (foundAt & 0xFFFC) + 4;
        if (p >= this._keyBlockEnd || p < 32) {
            return -1;
        }
        return p;
    }

    int toKeyBlock(int foundAt) {
        foundAt &= 0xFFFC;
        if (32 >= this._keyBlockEnd) {
            return -1;
        }
        if (foundAt < 32) {
            return 32;
        }
        if (foundAt >= this._keyBlockEnd) {
            return this._keyBlockEnd - 4;
        }
        return foundAt;
    }

    int putValue(Key key, ValueHelper valueHelper) throws PersistitInterruptedException {
        int p = this.findKey(key);
        return this.putValue(key, valueHelper, p, false);
    }

    int putValue(Key key, ValueHelper valueHelper, int foundAt, boolean postSplit) {
        int ebcSuccessor;
        int ebcNew;
        boolean exactMatch = (foundAt & 1) > 0;
        int p = foundAt & 0xFFFC;
        if (exactMatch) {
            return this.replaceValue(key, valueHelper, p);
        }
        int length = this.isIndexPage() ? 0 : valueHelper.requiredLength(this._bytes, 0, -1);
        int depth = (foundAt & 0xFFF0000) >>> 16;
        boolean fixupSuccessor = (foundAt & 0x40000000) > 0;
        byte[] kbytes = key.getEncodedBytes();
        int kbSuccessor = 0;
        int delta = 0;
        int successorTail = 0;
        int successorTailBlock = 0;
        int successorTailSize = 0;
        int free1 = 0;
        int free2 = 0;
        if (fixupSuccessor) {
            kbSuccessor = this.getInt(p);
            ebcNew = Buffer.decodeKeyBlockEbc(kbSuccessor);
            ebcSuccessor = depth;
            delta = ebcSuccessor - ebcNew;
            successorTail = Buffer.decodeKeyBlockTail(kbSuccessor);
            successorTailBlock = this.getInt(successorTail);
            successorTailSize = Buffer.decodeTailBlockSize(successorTailBlock);
            free1 = successorTailSize + 3 & 0xFFFFFFFC;
            free2 = successorTailSize - delta + 3 & 0xFFFFFFFC;
        } else {
            ebcSuccessor = 0;
            ebcNew = depth;
        }
        int klength = key.getEncodedSize() - ebcNew - 1;
        int newTailSize = klength + length + this._tailHeaderSize;
        if (this.getKeyCount() >= this._pool.getMaxKeys() || !this.willFit(newTailSize + 4 - (free1 - free2))) {
            Debug.$assert0.t(!postSplit);
            return -1;
        }
        if (fixupSuccessor && ebcNew != ebcSuccessor) {
            int successorKeyLength = Buffer.decodeTailBlockKLength(successorTailBlock);
            int successorDb = this.getByte(successorTail + this._tailHeaderSize + delta - 1);
            this.putInt(successorTail, Buffer.encodeTailBlock(successorTailSize - delta, successorKeyLength - delta));
            System.arraycopy(this._bytes, successorTail + this._tailHeaderSize + delta, this._bytes, successorTail + this._tailHeaderSize, successorTailSize - this._tailHeaderSize - delta);
            if (free2 < free1) {
                this.deallocTail(successorTail + free2, free1 - free2);
            }
            kbSuccessor = Buffer.encodeKeyBlock(ebcSuccessor, successorDb, successorTail);
            this.putInt(p, kbSuccessor);
        }
        int dbNew = kbytes[ebcNew] & 0xFF;
        this.setKeyBlockEnd(this.getKeyBlockEnd() + 4);
        int newTail = this.allocTail(newTailSize);
        if (newTail == -1) {
            this._keyBlockEnd -= 4;
            this.repack();
            this.setKeyBlockEnd(this.getKeyBlockEnd() + 4);
            newTail = this.allocTail(newTailSize);
            if (newTail == -1) {
                this._persistit.fatal("Insufficient space to insert record in " + this + " at =" + p, null);
            }
        }
        System.arraycopy(this._bytes, p, this._bytes, p + 4, this._keyBlockEnd - p - 4);
        int newKeyBlock = Buffer.encodeKeyBlock(ebcNew, dbNew, newTail);
        this.putInt(p, newKeyBlock);
        this.putInt(newTail, Buffer.encodeTailBlock(newTailSize, klength));
        Debug.$assert0.t(klength >= 0 && ebcNew + 1 >= 0 && ebcNew + 1 + klength <= kbytes.length && newTail + this._tailHeaderSize >= 0 && newTail + this._tailHeaderSize + klength <= this._bytes.length);
        System.arraycopy(kbytes, ebcNew + 1, this._bytes, newTail + this._tailHeaderSize, klength);
        if (this.isIndexPage()) {
            int pointer = (int)valueHelper.getPointerValue();
            Debug.$assert0.t(p + 4 < this._keyBlockEnd ? pointer > 0 : true);
            this.putInt(newTail + 4, pointer);
        } else {
            int offset = newTail + this._tailHeaderSize + klength;
            int storedLength = valueHelper.storeVersion(this._bytes, offset, -1, this._bytes.length);
            this.incCountIfMvv(this._bytes, offset, storedLength & Integer.MAX_VALUE);
            Debug.$assert0.t(MVV.verify(this._persistit.getTransactionIndex(), this._bytes, offset, storedLength & Integer.MAX_VALUE));
        }
        this._fastIndex.insertKeyBlock(p, ebcSuccessor, fixupSuccessor);
        this.bumpGeneration();
        if (p > 32) {
            Debug.$assert0.t(this.adjacentKeyCheck(p - 4));
        }
        if (p + 4 < this._keyBlockEnd) {
            Debug.$assert0.t(this.adjacentKeyCheck(p));
        }
        return p | key.getEncodedSize() << 16 | 1;
    }

    private boolean adjacentKeyCheck(int p) {
        int kbData1 = this.getInt(p &= 0xFFFC);
        int kbData2 = this.getInt(p + 4);
        int db1 = Buffer.decodeKeyBlockDb(kbData1);
        int ebc1 = Buffer.decodeKeyBlockEbc(kbData1);
        int db2 = Buffer.decodeKeyBlockDb(kbData2);
        int ebc2 = Buffer.decodeKeyBlockEbc(kbData2);
        if (db1 == 0 && p > 32) {
            return false;
        }
        if (db2 == 0) {
            return false;
        }
        if (ebc1 == ebc2 && db1 < db2) {
            return true;
        }
        if (ebc2 < ebc1) {
            return true;
        }
        if (ebc2 > ebc1) {
            int tail1 = Buffer.decodeKeyBlockTail(kbData1);
            int tbData1 = this.getInt(tail1);
            int klength1 = Buffer.decodeTailBlockKLength(tbData1);
            int db = -1;
            if (klength1 >= ebc2 - ebc1) {
                db = this._bytes[tail1 + this._tailHeaderSize + ebc2 - ebc1 - 1] & 0xFF;
                return db2 > db;
            }
            return klength1 + 1 == ebc2 - ebc1;
        }
        return false;
    }

    private int replaceValue(Key key, ValueHelper valueHelper, int p) {
        int length;
        int kbData = this.getInt(p);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = this.getInt(tail);
        int klength = Buffer.decodeTailBlockKLength(tbData);
        int oldTailSize = Buffer.decodeTailBlockSize(tbData);
        boolean wasMVV = false;
        boolean isMVV = false;
        if (this.isIndexPage()) {
            length = 0;
        } else {
            length = valueHelper.requiredLength(this._bytes, tail + this._tailHeaderSize + klength, oldTailSize - this._tailHeaderSize - klength);
            wasMVV = Buffer.isValueMVV(this._bytes, tail + this._tailHeaderSize + klength, oldTailSize - this._tailHeaderSize - klength);
        }
        int newTailSize = klength + length + this._tailHeaderSize;
        int oldNext = tail + oldTailSize + 3 & 0xFFFFFFFC;
        int newNext = tail + newTailSize + 3 & 0xFFFFFFFC;
        int newTail = tail;
        if (newNext < oldNext) {
            this.deallocTail(newNext, oldNext - newNext);
        } else if (newNext > oldNext) {
            if (!this.willFit(newNext - oldNext)) {
                return -1;
            }
            this.deallocTail(tail, oldTailSize);
            newTail = this.allocTail(newTailSize);
            if (newTail == -1) {
                this.repack();
                newTail = this.allocTail(newTailSize);
                if (newTail == -1) {
                    this._persistit.fatal("Insufficient space to replace records in " + this + " at =" + p, null);
                }
            }
            this.putInt(p, Buffer.encodeKeyBlockTail(kbData, newTail));
        }
        this.putInt(newTail, Buffer.encodeTailBlock(newTailSize, klength));
        if (newTail != tail) {
            System.arraycopy(key.getEncodedBytes(), key.getEncodedSize() - klength, this._bytes, newTail + this._tailHeaderSize, klength);
        }
        if (this.isIndexPage()) {
            long pointer = valueHelper.getPointerValue();
            Debug.$assert0.t(p + 4 < this._keyBlockEnd ? pointer > 0L : pointer == -1L);
            this.putInt(newTail + 4, (int)pointer);
        } else {
            int offset = newTail + this._tailHeaderSize + klength;
            int storedLength = valueHelper.storeVersion(this._bytes, offset, oldTailSize - this._tailHeaderSize - klength, this._bytes.length);
            isMVV = Buffer.isValueMVV(this._bytes, offset, storedLength & Integer.MAX_VALUE);
            Debug.$assert0.t(MVV.verify(this._persistit.getTransactionIndex(), this._bytes, offset, storedLength & Integer.MAX_VALUE));
        }
        if (!wasMVV && isMVV) {
            ++this._mvvCount;
        } else if (wasMVV && !isMVV) {
            --this._mvvCount;
        }
        return p | key.getEncodedSize() << 16 | 1;
    }

    boolean removeKeys(int foundAt1, int foundAt2, Key spareKey) {
        int kbNext;
        int ebcNext;
        int p1 = foundAt1 & 0xFFFC;
        int p2 = foundAt2 & 0xFFFC;
        if ((foundAt2 & 1) != 0) {
            p2 += 4;
        }
        if (p1 < 32 || p1 > this._keyBlockEnd || p2 < 32 || p2 > this._keyBlockEnd) {
            throw new IllegalArgumentException("p1=" + p1 + " p2=" + p2 + " in " + this.summarize());
        }
        if (p2 <= p1) {
            return false;
        }
        int ebc = Integer.MAX_VALUE;
        byte[] spareBytes = spareKey.getEncodedBytes();
        int keySize = 0;
        for (int p = p1; p < p2; p += 4) {
            int kbData = this.getInt(p);
            int ebcCandidate = Buffer.decodeKeyBlockEbc(kbData);
            if (ebcCandidate < ebc) {
                ebc = ebcCandidate;
            }
            int db = Buffer.decodeKeyBlockDb(kbData);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            spareBytes[ebcCandidate] = (byte)db;
            if (klength > 0) {
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, spareBytes, ebcCandidate + 1, klength);
            }
            keySize = klength + ebcCandidate + 1;
            int size = Buffer.decodeTailBlockSize(tbData) + 3 & 0xFFFFFFFC;
            this.deallocTail(tail, size);
        }
        spareKey.setEncodedSize(keySize);
        System.arraycopy(this._bytes, p2, this._bytes, p1, this._keyBlockEnd - p2);
        this._keyBlockEnd -= p2 - p1;
        if (p1 < this._keyBlockEnd && (ebcNext = Buffer.decodeKeyBlockEbc(kbNext = this.getInt(p1))) > ebc) {
            int tailNext = Buffer.decodeKeyBlockTail(kbNext);
            int dbNext = Buffer.decodeKeyBlockDb(kbNext);
            int tbNext = this.getInt(tailNext);
            int nextTailSize = Buffer.decodeTailBlockSize(tbNext);
            int nextTailBlockSize = nextTailSize + 3 & 0xFFFFFFFC;
            int newNextTailBlockSize = nextTailSize + ebcNext - ebc + 3 & 0xFFFFFFFC;
            int delta = newNextTailBlockSize - nextTailBlockSize;
            boolean freeNextTailBlock = false;
            int newNextTail = tailNext;
            if (delta > 0) {
                newNextTail = this.allocTail(newNextTailBlockSize);
                if (newNextTail == -1) {
                    newNextTail = this.wedgeTail(tailNext, delta);
                    if (newNextTail == -1) {
                        this.repack();
                        kbNext = this.getInt(p1);
                        tailNext = Buffer.decodeKeyBlockTail(kbNext);
                        newNextTail = this.wedgeTail(tailNext, delta);
                    }
                } else {
                    freeNextTailBlock = true;
                }
                if (newNextTail == -1) {
                    this._persistit.fatal("Can't wedge enough space in " + this + " foundAt1=" + foundAt1 + " foundAt2=" + foundAt2 + " spareKey=" + spareKey + " nextTailBlockSize=" + nextTailBlockSize + " newNextTailBlockSize=" + newNextTailBlockSize + " ebc=" + ebc + " ebcNext=" + ebcNext, null);
                }
            }
            if (this.isIndexPage()) {
                this.putInt(newNextTail + 4, this.getInt(tailNext + 4));
            }
            System.arraycopy(this._bytes, tailNext + this._tailHeaderSize, this._bytes, newNextTail + this._tailHeaderSize + ebcNext - ebc, nextTailSize - this._tailHeaderSize);
            this._bytes[newNextTail + this._tailHeaderSize + ebcNext - ebc - 1] = (byte)dbNext;
            System.arraycopy(spareBytes, ebc + 1, this._bytes, newNextTail + this._tailHeaderSize, ebcNext - ebc - 1);
            int newNextKLength = Buffer.decodeTailBlockKLength(tbNext) + ebcNext - ebc;
            int newNextTailSize = nextTailSize + ebcNext - ebc;
            this.putInt(newNextTail, Buffer.encodeTailBlock(newNextTailSize, newNextKLength));
            if (freeNextTailBlock) {
                int toFree = nextTailSize + 3 & 0xFFFFFFFC;
                this.deallocTail(tailNext, toFree);
            }
            int kbNewNext = Buffer.encodeKeyBlock(ebc, spareBytes[ebc], newNextTail);
            this.putInt(p1, kbNewNext);
        }
        this.invalidateFastIndex();
        this.bumpGeneration();
        return true;
    }

    private int wedgeTail(int tail, int delta) {
        if ((delta = delta + 3 & 0xFFFFFFFC) == 0) {
            return tail;
        }
        if (delta < 0) {
            throw new IllegalArgumentException("wedgeTail delta must be positive: " + delta + " is invalid");
        }
        if (this._alloc - this._keyBlockEnd < delta) {
            return -1;
        }
        System.arraycopy(this._bytes, this._alloc, this._bytes, this._alloc - delta, tail - this._alloc);
        this._alloc -= delta;
        for (int p = 32; p < this._keyBlockEnd; p += 4) {
            int kbData = this.getInt(p);
            int oldTail = Buffer.decodeKeyBlockTail(kbData);
            if (oldTail >= tail) continue;
            this.putInt(p, Buffer.encodeKeyBlockTail(kbData, oldTail - delta));
        }
        return tail - delta;
    }

    final int split(Buffer rightSibling, Key key, ValueHelper valueHelper, int foundAt, Key indexKey, Exchange.Sequence sequence, SplitPolicy policy) throws PersistitException {
        int db;
        int kbData;
        int newValueSize;
        int ebcSuccessor;
        int ebcNew;
        Debug.$assert0.t(rightSibling._keyBlockEnd == 32);
        Debug.$assert0.t(rightSibling._alloc == rightSibling._bufferSize);
        if (this._mvvCount > 0) {
            rightSibling._mvvCount = Integer.MAX_VALUE;
        }
        int currentSize = this._bufferSize - this._alloc - this._slack + this._keyBlockEnd - 32;
        int foundAtPosition = foundAt & 0xFFFC;
        boolean exact = (foundAt & 1) != 0;
        int depth = (foundAt & 0xFFF0000) >>> 16;
        boolean fixupSuccessor = (foundAt & 0x40000000) > 0;
        int deltaSuccessorTailSize = 0;
        int deltaSuccessorEbc = 0;
        if (fixupSuccessor) {
            int kbSuccessor = this.getInt(foundAtPosition);
            int tbSuccessor = this.getInt(Buffer.decodeKeyBlockTail(kbSuccessor));
            ebcNew = Buffer.decodeKeyBlockEbc(kbSuccessor);
            ebcSuccessor = depth;
            int tbSize = Buffer.decodeTailBlockSize(tbSuccessor);
            deltaSuccessorEbc = ebcSuccessor - ebcNew;
            int oldSize = tbSize + 3 & 0xFFFFFFFC;
            int newSize = tbSize - deltaSuccessorEbc + 3 & 0xFFFFFFFC;
            deltaSuccessorTailSize = oldSize - newSize;
        } else {
            ebcSuccessor = 0;
            ebcNew = depth;
        }
        int keyBlockSizeDelta = 4;
        int oldTailBlockSize = 0;
        if (exact) {
            int kbData2 = this.getInt(foundAtPosition);
            int tail = Buffer.decodeKeyBlockTail(kbData2);
            int tbData = this.getInt(tail);
            int tbSize = Buffer.decodeTailBlockSize(tbData);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            oldTailBlockSize = tbSize + 3 & 0xFFFFFFFC;
            keyBlockSizeDelta = 0;
            ebcNew = Buffer.decodeKeyBlockEbc(kbData2);
            newValueSize = valueHelper.requiredLength(this._bytes, tail + this._tailHeaderSize + klength, tbSize - this._tailHeaderSize - klength);
        } else {
            newValueSize = valueHelper.requiredLength(this._bytes, 0, -1);
        }
        int newTailBlockSize = (this.isIndexPage() ? 0 : newValueSize) + this._tailHeaderSize + key.getEncodedSize() - ebcNew - 1 + 3 & 0xFFFFFFFC;
        int virtualSize = currentSize + newTailBlockSize - oldTailBlockSize + keyBlockSizeDelta - deltaSuccessorTailSize;
        int splitBest = 0;
        int splitAt = 0;
        int leftSize = 0;
        boolean armed = true;
        int whereInserted = -1;
        int rightKeyBlock = this._keyBlockEnd - 4;
        int p = 32;
        while (p < rightKeyBlock) {
            int tbData;
            int kbData3;
            int splitCandidate = 0;
            if (p == foundAtPosition && armed) {
                int rightSize;
                leftSize += newTailBlockSize + 4;
                if (exact) {
                    p += 4;
                }
                kbData3 = this.getInt(p);
                tbData = this.getInt(Buffer.decodeKeyBlockTail(kbData3));
                int ebc = Buffer.decodeKeyBlockEbc(kbData3);
                int tbSize = Buffer.decodeTailBlockSize(tbData);
                int tbSizeDelta = (tbSize + ebc + 3 & 0xFFFFFFFC) - (tbSize + 3 & 0xFFFFFFFC);
                int edgeTailBlockSize = Buffer.decodeTailBlockKLength(tbData) - deltaSuccessorEbc + this._tailHeaderSize + 3 & 0xFFFFFFFC;
                if (p < rightKeyBlock && (splitCandidate = policy.splitFit(this, p, foundAtPosition, exact, leftSize + 4 + edgeTailBlockSize, rightSize = virtualSize - leftSize + tbSizeDelta, currentSize, virtualSize, this._bufferSize - 32, splitBest, sequence)) > splitBest) {
                    splitBest = splitCandidate;
                    splitAt = p | 1;
                }
                armed = false;
            } else {
                int rightSize;
                int edgeTailBlockSize;
                int tbSizeDelta;
                kbData3 = this.getInt(p);
                tbData = this.getInt(Buffer.decodeKeyBlockTail(kbData3));
                int tailBlockSize = Buffer.decodeTailBlockSize(tbData) + 3 & 0xFFFFFFFC;
                leftSize += tailBlockSize + 4;
                if ((p += 4) == foundAtPosition && armed) {
                    tbSizeDelta = ((this.isIndexPage() ? 0 : newValueSize) + this._tailHeaderSize + key.getEncodedSize() + 3 & 0xFFFFFFFC) - newTailBlockSize;
                    edgeTailBlockSize = key.getEncodedSize() - depth + this._tailHeaderSize + 3 & 0xFFFFFFFC;
                } else {
                    kbData3 = this.getInt(p);
                    tbData = this.getInt(Buffer.decodeKeyBlockTail(kbData3));
                    int ebc = Buffer.decodeKeyBlockEbc(kbData3);
                    int tbSize = Buffer.decodeTailBlockSize(tbData);
                    tbSizeDelta = (tbSize + ebc + 3 & 0xFFFFFFFC) - (tbSize + 3 & 0xFFFFFFFC);
                    edgeTailBlockSize = Buffer.decodeTailBlockKLength(tbData) + this._tailHeaderSize + 3 & 0xFFFFFFFC;
                }
                if (p < rightKeyBlock && (splitCandidate = policy.splitFit(this, p, foundAtPosition, exact, leftSize + 4 + edgeTailBlockSize, rightSize = virtualSize - leftSize + tbSizeDelta, currentSize, virtualSize, this._bufferSize - 32, splitBest, sequence)) > splitBest) {
                    splitBest = splitCandidate;
                    splitAt = p;
                }
            }
            if (splitCandidate != 0 || splitBest == 0) continue;
            break;
        }
        if (splitBest == 0) {
            throw new InvalidPageStructureException("Can't split page " + this + " exact=" + exact + " insertAt=" + foundAtPosition + " currentSize=" + currentSize + " virtualSize=" + virtualSize + " leftSize=" + leftSize);
        }
        byte[] indexKeyBytes = indexKey.getEncodedBytes();
        int splitAtPosition = splitAt & 0xFFFC;
        boolean lastLeft = (splitAt & 1) != 0;
        boolean firstRight = !lastLeft && splitAtPosition == foundAtPosition;
        int indexKeyDepth = 0;
        int scanStart = 32;
        if (foundAtPosition <= splitAt) {
            scanStart = foundAtPosition;
            indexKeyDepth = key.getEncodedSize();
            System.arraycopy(key.getEncodedBytes(), 0, indexKeyBytes, 0, indexKeyDepth);
        }
        if (!firstRight) {
            for (int p2 = scanStart; p2 <= splitAtPosition; p2 += 4) {
                kbData = this.getInt(p2);
                int ebc = Buffer.decodeKeyBlockEbc(kbData);
                db = Buffer.decodeKeyBlockDb(kbData);
                int tail = Buffer.decodeKeyBlockTail(kbData);
                if (ebc > indexKeyDepth) {
                    throw new InvalidPageStructureException("ebc at " + p2 + " ebc=" + ebc + " > indexKeyDepth=" + indexKeyDepth);
                }
                indexKeyDepth = ebc;
                indexKeyBytes[indexKeyDepth++] = (byte)db;
                int tbData = this.getInt(tail);
                int klength = Buffer.decodeTailBlockKLength(tbData);
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, indexKeyBytes, indexKeyDepth, klength);
                indexKeyDepth += klength;
            }
        }
        indexKey.setEncodedSize(indexKeyDepth);
        rightSibling.setKeyBlockEnd(this._keyBlockEnd - (splitAtPosition - 32));
        int rightP = 32;
        for (int p3 = splitAtPosition; p3 < this._keyBlockEnd; p3 += 4) {
            int newDataSize;
            int newEbc;
            int newDb;
            int newKeyLength;
            int kbData4 = this.getInt(p3);
            db = Buffer.decodeKeyBlockDb(kbData4);
            int ebc = Buffer.decodeKeyBlockEbc(kbData4);
            int tail = Buffer.decodeKeyBlockTail(kbData4);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int tailBlockSize = Buffer.decodeTailBlockSize(tbData);
            int dataSize = tailBlockSize - this._tailHeaderSize - klength;
            if (p3 == splitAtPosition) {
                newKeyLength = klength + ebc;
                newDb = ebc > 0 ? indexKeyBytes[0] : db;
                newEbc = 0;
            } else {
                newKeyLength = klength;
                newDb = db;
                newEbc = ebc;
            }
            if (exact && this.isDataPage() && foundAtPosition == p3) {
                newDataSize = newValueSize;
                Debug.$assert0.t(newDataSize > dataSize);
            } else {
                newDataSize = dataSize;
            }
            newTailBlockSize = newKeyLength + newDataSize + this._tailHeaderSize;
            int newTailBlock = rightSibling.allocTail(newTailBlockSize);
            Debug.$assert0.t(newTailBlock >= 0 && newTailBlock < rightSibling._bufferSize);
            Debug.$assert0.t(newTailBlock != -1);
            rightSibling.putInt(newTailBlock, Buffer.encodeTailBlock(newTailBlockSize, newKeyLength));
            if (p3 == splitAtPosition && ebc > 0) {
                System.arraycopy(indexKeyBytes, 1, rightSibling._bytes, newTailBlock + this._tailHeaderSize, ebc - 1);
                rightSibling.putByte(newTailBlock + this._tailHeaderSize + ebc - 1, db);
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, rightSibling._bytes, newTailBlock + this._tailHeaderSize + ebc, klength);
            } else {
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, rightSibling._bytes, newTailBlock + this._tailHeaderSize, klength);
            }
            if (this.isDataPage()) {
                System.arraycopy(this._bytes, tail + this._tailHeaderSize + klength, rightSibling._bytes, newTailBlock + this._tailHeaderSize + newKeyLength, dataSize);
            } else {
                rightSibling.putInt(newTailBlock + 4, this.getInt(tail + 4));
            }
            rightSibling.putInt(rightP, Buffer.encodeKeyBlock(newEbc, newDb, newTailBlock));
            rightP += 4;
            if (p3 != splitAtPosition || firstRight && !exact) {
                this.deallocTail(tail, tailBlockSize);
                continue;
            }
            if (this.isDataPage()) {
                int newSize = tailBlockSize - dataSize + 3 & 0xFFFFFFFC;
                currentSize = tailBlockSize + 3 & 0xFFFFFFFC;
                if (newSize != currentSize) {
                    this.deallocTail(tail + newSize, currentSize - newSize);
                }
                this.putInt(tail, Buffer.encodeTailBlock(this._tailHeaderSize + klength, klength));
                continue;
            }
            this.putInt(tail + 4, -1);
        }
        kbData = this.getInt(splitAtPosition);
        int edgeTail = Buffer.decodeKeyBlockTail(kbData);
        int ebc = Buffer.decodeKeyBlockEbc(kbData);
        depth = (foundAt & 0xFFF0000) >>> 16;
        if (firstRight && !exact) {
            if (fixupSuccessor) {
                depth = ebc;
            }
            byte db2 = indexKeyBytes[depth];
            int edgeKeyLength = indexKey.getEncodedSize() - depth - 1;
            int edgeTailBlockSize = edgeKeyLength + this._tailHeaderSize;
            edgeTail = this.allocTail(edgeTailBlockSize);
            if (edgeTail == -1) {
                this.setKeyBlockEnd(splitAtPosition);
                this.repack();
                edgeTail = this.allocTail(edgeTailBlockSize);
            }
            if (edgeTail == -1) {
                this._persistit.fatal("Insufficient space for edgeTail records in " + this + " at =" + splitAtPosition, null);
            }
            this.putInt(edgeTail, Buffer.encodeTailBlock(edgeTailBlockSize, edgeKeyLength));
            System.arraycopy(indexKeyBytes, depth + 1, this._bytes, edgeTail + this._tailHeaderSize, edgeKeyLength);
            this.putInt(splitAtPosition, Buffer.encodeKeyBlock(depth, db2, edgeTail));
        }
        this.setKeyBlockEnd(splitAtPosition + 4);
        if (this.isIndexPage()) {
            this.putInt(edgeTail + 4, -1);
        }
        this.invalidateFastIndex();
        rightSibling.invalidateFastIndex();
        Debug.$assert0.t(rightSibling._keyBlockEnd > 36 ? rightSibling.adjacentKeyCheck(32) : true);
        if (!exact) {
            int t;
            if (!(foundAtPosition < splitAtPosition || lastLeft && foundAtPosition <= splitAtPosition)) {
                foundAt -= splitAtPosition - 32;
                if (firstRight && !fixupSuccessor) {
                    foundAt = foundAt & 0xFFFC | (ebc > 0 ? 0x40000000 : 0) | ebc << 16;
                }
                t = rightSibling.putValue(key, valueHelper, foundAt, true);
                whereInserted = -foundAt;
                Debug.$assert0.t(t != -1);
            } else {
                t = this.putValue(key, valueHelper, foundAt, true);
                whereInserted = foundAt;
                Debug.$assert0.t(t != -1);
            }
        } else {
            whereInserted = foundAtPosition < splitAtPosition ? this.replaceValue(key, valueHelper, foundAtPosition) : rightSibling.replaceValue(key, valueHelper, foundAtPosition - splitAtPosition + 32);
            Debug.$assert0.t(whereInserted > 0);
            if (whereInserted <= 0) {
                throw new IllegalStateException("p = " + whereInserted + " foundAtPosition=" + foundAtPosition + " splitAtPosition=" + splitAtPosition);
            }
        }
        Debug.$assert0.t(36 < this._keyBlockEnd);
        Debug.$assert0.t(36 < rightSibling._keyBlockEnd);
        this.bumpGeneration();
        rightSibling.bumpGeneration();
        return whereInserted;
    }

    final boolean join(Buffer buffer, int foundAt1, int foundAt2, Key indexKey, Key spareKey, JoinPolicy policy) throws RebalanceException {
        boolean result;
        boolean okayToRejoin;
        int newEbc;
        if (buffer == this || (foundAt1 &= 0xFFFC) <= 32 || foundAt1 >= this._keyBlockEnd || (foundAt2 &= 0xFFFC) <= 32 || foundAt2 >= buffer._keyBlockEnd) {
            Debug.$assert0.t(false);
            throw new IllegalArgumentException("foundAt1=" + foundAt1 + " foundAt2=" + foundAt2 + " _keyBlockEnd=" + this._keyBlockEnd + " buffer._keyBlockEnd=" + buffer._keyBlockEnd);
        }
        boolean hasMVV = this._mvvCount > 0 || buffer.getMvvCount() > 0;
        byte[] spareKeyBytes = spareKey.getEncodedBytes();
        byte[] indexKeyBytes = indexKey.getEncodedBytes();
        buffer.keyAt(foundAt2, spareKey);
        long measureLeft = this.joinMeasure(foundAt1, this._keyBlockEnd);
        long measureRight = buffer.joinMeasure(32, foundAt2);
        int kbData = buffer.getInt(foundAt2);
        int oldEbc = Buffer.decodeKeyBlockEbc(kbData);
        if (this._rightSibling == buffer._page) {
            newEbc = Math.min(oldEbc, Math.min((int)(measureLeft >>> 32), (int)(measureRight >>> 32)));
        } else {
            this.keyAt(foundAt1, indexKey);
            int firstUnique = indexKey.firstUniqueByteIndex(spareKey);
            newEbc = Math.min(Math.min(oldEbc, firstUnique), Math.min((int)(measureLeft >>> 32), (int)(measureRight >>> 32)));
        }
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = buffer.getInt(tail);
        int oldSize = Buffer.decodeTailBlockSize(tbData);
        int newSize = oldSize + (oldEbc - newEbc);
        int adjustmentForNewEbc = (newSize + 3 & 0xFFFFFFFC) - (oldSize + 3 & 0xFFFFFFFC);
        int virtualSize = this.inUseSize() + buffer.inUseSize() - (int)measureLeft - (int)measureRight + adjustmentForNewEbc + 32;
        int virtualKeyCount = (foundAt1 - 32 + (buffer.getKeyBlockEnd() - foundAt2)) / 4;
        boolean bl = okayToRejoin = virtualKeyCount < this._pool.getMaxKeys() && policy.acceptJoin(this, virtualSize);
        if (okayToRejoin) {
            Debug.$assert0.t(virtualSize <= this._bufferSize);
            this.joinDeallocateTails(foundAt1, this._keyBlockEnd);
            if (newEbc < oldEbc) {
                buffer.joinDeallocateTails(32, foundAt2);
                buffer.reduceEbc(foundAt2, newEbc, spareKeyBytes);
            }
            this.setKeyBlockEnd(foundAt1);
            this.moveRecords(buffer, foundAt2, buffer._keyBlockEnd, foundAt1, false);
            buffer.setKeyBlockEnd(32);
            buffer.clearBytes(32, this._bufferSize);
            buffer.setAlloc(this._bufferSize);
            long rightSibling = buffer.getRightSibling();
            this.setRightSibling(rightSibling);
            if (hasMVV) {
                this._mvvCount = Integer.MAX_VALUE;
            }
            this.invalidateFastIndex();
            result = false;
        } else {
            int joinOffset = this.joinMeasureRebalanceOffset(buffer, virtualSize, foundAt1, foundAt2, adjustmentForNewEbc, policy);
            if (joinOffset == 0) {
                throw new RebalanceException();
            }
            if (joinOffset < 0) {
                joinOffset = -joinOffset;
                buffer.keyAt(joinOffset, indexKey);
                this.joinDeallocateTails(foundAt1, this._keyBlockEnd);
                this.clearBytes(foundAt1, this._keyBlockEnd);
                this.setKeyBlockEnd(foundAt1);
                buffer.joinDeallocateTails(32, foundAt2);
                buffer.clearBytes(32, foundAt2);
                buffer.reduceEbc(foundAt2, newEbc, spareKeyBytes);
                int rightSize = buffer._keyBlockEnd - joinOffset;
                this.moveRecords(buffer, foundAt2, joinOffset, this._keyBlockEnd, true);
                System.arraycopy(buffer._bytes, joinOffset, buffer._bytes, 32, rightSize);
                buffer.clearBytes(32 + rightSize, buffer._keyBlockEnd);
                buffer.setKeyBlockEnd(32 + rightSize);
                buffer.reduceEbc(32, 0, indexKeyBytes);
            } else {
                this.keyAt(joinOffset, indexKey);
                this.joinDeallocateTails(foundAt1, this._keyBlockEnd);
                this.clearBytes(foundAt1, this._keyBlockEnd);
                this.setKeyBlockEnd(foundAt1);
                buffer.joinDeallocateTails(32, foundAt2);
                int rightSize = buffer._keyBlockEnd - foundAt2;
                System.arraycopy(buffer._bytes, foundAt2, buffer._bytes, 32, rightSize);
                buffer.clearBytes(32 + rightSize, buffer._keyBlockEnd);
                buffer.setKeyBlockEnd(32 + rightSize);
                buffer.reduceEbc(32, newEbc, spareKeyBytes);
                if (joinOffset != foundAt1) {
                    buffer.moveRecords(this, joinOffset, foundAt1, 32, false);
                    this.setKeyBlockEnd(joinOffset);
                }
                this.moveRecords(buffer, 32, 32, joinOffset, true);
                buffer.reduceEbc(32, 0, indexKeyBytes);
            }
            this.setRightSibling(buffer.getPageAddress());
            this.invalidateFastIndex();
            buffer.invalidateFastIndex();
            if (hasMVV) {
                this._mvvCount = Integer.MAX_VALUE;
                buffer._mvvCount = Integer.MAX_VALUE;
            }
            result = true;
        }
        Debug.$assert0.t(36 < this._keyBlockEnd);
        if (result) {
            Debug.$assert0.t(36 < buffer._keyBlockEnd);
        }
        this.bumpGeneration();
        buffer.bumpGeneration();
        return result;
    }

    int inUseSize() {
        return this._keyBlockEnd - 32 + (this._bufferSize - this._alloc) - this._slack;
    }

    long joinMeasure(int from, int to) {
        int minimumEbc = Integer.MAX_VALUE;
        int totalDeallocatedSize = 0;
        for (int index = from; index < to; index += 4) {
            int kbData = this.getInt(index);
            int ebc = Buffer.decodeKeyBlockEbc(kbData);
            if (index != 32 && ebc < minimumEbc) {
                minimumEbc = ebc;
            }
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int size = Buffer.decodeTailBlockSize(tbData);
            totalDeallocatedSize += (size + 3 & 0xFFFFFFFC) + 4;
        }
        return (long)minimumEbc << 32 | (long)totalDeallocatedSize;
    }

    void joinDeallocateTails(int from, int to) {
        for (int index = from; index < to; index += 4) {
            int kbData = this.getInt(index);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int size = Buffer.decodeTailBlockSize(tbData) + 3 & 0xFFFFFFFC;
            this.deallocTail(tail, size);
        }
    }

    int joinMeasureRebalanceOffset(Buffer buffer, int virtualSize, int foundAt1, int foundAt2, int adjustmentForNewEbc, JoinPolicy policy) {
        int delta;
        int klength;
        int size;
        int tbData;
        int tail;
        int ebc;
        int kbData;
        int p;
        int joinBest = 0;
        int joinOffset = 0;
        int leftSize = 0;
        for (p = 32; p < foundAt1; p += 4) {
            kbData = this.getInt(p);
            ebc = Buffer.decodeKeyBlockEbc(kbData);
            tail = Buffer.decodeKeyBlockTail(kbData);
            tbData = this.getInt(tail);
            size = Buffer.decodeTailBlockSize(tbData);
            klength = Buffer.decodeTailBlockKLength(tbData);
            delta = (size + ebc + 3 & 0xFFFFFFFC) - (size + 3 & 0xFFFFFFFC);
            int candidateRightSize = virtualSize - leftSize + delta;
            int candidateLeftSize = leftSize + 4 + (klength + 3 & 0xFFFFFFFC) + this._tailHeaderSize;
            int rightKeyCount = (buffer.getKeyBlockEnd() - foundAt2 + (foundAt1 - p)) / 4;
            int joinFit = policy.rebalanceFit(this, buffer, p, foundAt1, foundAt2, virtualSize, candidateLeftSize, candidateRightSize, this._bufferSize - 32);
            if (joinFit > joinBest && rightKeyCount < this._pool.getMaxKeys()) {
                joinBest = joinFit;
                joinOffset = p;
            }
            leftSize += 4 + (size + 3 & 0xFFFFFFFC);
        }
        for (p = foundAt2; p < buffer._keyBlockEnd; p += 4) {
            kbData = buffer.getInt(p);
            ebc = Buffer.decodeKeyBlockEbc(kbData);
            tail = Buffer.decodeKeyBlockTail(kbData);
            tbData = buffer.getInt(tail);
            size = Buffer.decodeTailBlockSize(tbData);
            klength = Buffer.decodeTailBlockKLength(tbData);
            delta = (size + ebc + 3 & 0xFFFFFFFC) - (size + 3 & 0xFFFFFFFC);
            int adjustment = p == foundAt2 ? adjustmentForNewEbc : 0;
            int candidateRightSize = virtualSize - leftSize + delta;
            int candidateLeftSize = leftSize + (klength + 3 & 0xFFFFFFFC) + adjustment + this._tailHeaderSize + 4;
            int leftKeyCount = (foundAt1 - 32 + (p - foundAt2)) / 4;
            int joinFit = policy.rebalanceFit(this, buffer, p, foundAt1, foundAt2, virtualSize, candidateLeftSize, candidateRightSize, this._bufferSize - 32);
            if (joinFit > joinBest && leftKeyCount < this._pool.getMaxKeys()) {
                joinBest = joinFit;
                joinOffset = -p;
            }
            leftSize += 4 + (size + 3 & 0xFFFFFFFC) + adjustment;
        }
        return joinOffset;
    }

    synchronized void invalidateFastIndex() {
        this._fastIndex.invalidate();
    }

    synchronized FastIndex getFastIndex() {
        if (!this._fastIndex.isValid()) {
            this._fastIndex.recompute();
        }
        return this._fastIndex;
    }

    private void reduceEbc(int p, int newEbc, byte[] indexKeyBytes) {
        int newTail;
        int kbData = this.getInt(p);
        int oldDb = Buffer.decodeKeyBlockDb(kbData);
        int oldEbc = Buffer.decodeKeyBlockEbc(kbData);
        int tail = Buffer.decodeKeyBlockTail(kbData);
        int tbData = this.getInt(tail);
        int size = Buffer.decodeTailBlockSize(tbData);
        int klength = Buffer.decodeTailBlockKLength(tbData);
        if (newEbc == oldEbc) {
            return;
        }
        if (newEbc > oldEbc) {
            throw new IllegalArgumentException("newEbc=" + newEbc + " must be less than oldEbc=" + oldEbc);
        }
        int delta = (size + oldEbc - newEbc + 3 & 0xFFFFFFFC) - (size + 3 & 0xFFFFFFFC);
        boolean wedged = false;
        if (delta == 0) {
            newTail = tail;
        } else {
            newTail = this.allocTail(size + delta);
            if (newTail == -1) {
                newTail = this.wedgeTail(tail, delta);
                if (newTail == -1) {
                    this.repack();
                    kbData = this.getInt(p);
                    tail = Buffer.decodeKeyBlockTail(kbData);
                    newTail = this.wedgeTail(tail, delta);
                    if (newTail == -1) {
                        this._persistit.fatal("Insufficient space for reduceEbc records in " + this + " at =" + p, null);
                    }
                }
                wedged = true;
            }
        }
        if (newTail != tail && this.isIndexPage()) {
            this.putInt(newTail + 4, this.getInt(tail + 4));
        }
        System.arraycopy(this._bytes, tail + this._tailHeaderSize, this._bytes, newTail + this._tailHeaderSize + oldEbc - newEbc, size - this._tailHeaderSize);
        this._bytes[newTail + this._tailHeaderSize + oldEbc - newEbc - 1] = (byte)oldDb;
        System.arraycopy(indexKeyBytes, newEbc + 1, this._bytes, newTail + this._tailHeaderSize, oldEbc - newEbc - 1);
        if (newTail != tail && !wedged) {
            this.deallocTail(tail, size);
        }
        int newDb = indexKeyBytes[newEbc] & 0xFF;
        this.putInt(newTail, Buffer.encodeTailBlock(size += oldEbc - newEbc, klength += oldEbc - newEbc));
        this.putInt(p, Buffer.encodeKeyBlock(newEbc, newDb, newTail));
    }

    void moveRecords(Buffer buffer, int p1, int p2, int insertAt, boolean includesRightEdge) {
        if (p2 - p1 + this._keyBlockEnd > this._alloc) {
            this.repack();
        }
        if (insertAt < this._keyBlockEnd) {
            System.arraycopy(this._bytes, insertAt, this._bytes, insertAt + p2 - p1, this._keyBlockEnd - insertAt);
        }
        this.clearBytes(insertAt, insertAt + p2 - p1);
        this.setKeyBlockEnd(this.getKeyBlockEnd() + p2 - p1);
        if (includesRightEdge) {
            this.setKeyBlockEnd(this.getKeyBlockEnd() + 4);
        }
        for (int p = p1; p < p2 || includesRightEdge && p == p2; p += 4) {
            int newTail;
            boolean edgeCase;
            int kbData = buffer.getInt(p);
            int ebc = Buffer.decodeKeyBlockEbc(kbData);
            int db = Buffer.decodeKeyBlockDb(kbData);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = buffer.getInt(tail);
            int size = Buffer.decodeTailBlockSize(tbData);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int newSize = size;
            boolean bl = edgeCase = includesRightEdge && p == p2;
            if (edgeCase) {
                newSize = this._tailHeaderSize + klength;
            }
            if ((newTail = this.allocTail(newSize)) == -1) {
                this.repack();
                newTail = this.allocTail(newSize);
            }
            if (newTail == -1) {
                this._persistit.fatal("Insufficient space to move records in " + this + "from " + buffer + " at =" + p, null);
            }
            System.arraycopy(buffer._bytes, tail + 4, this._bytes, newTail + 4, newSize - 4);
            this.putInt(newTail, Buffer.encodeTailBlock(newSize, klength));
            if (edgeCase && this.isIndexPage()) {
                this.putInt(newTail + 4, -1);
            }
            this.putInt(insertAt, Buffer.encodeKeyBlock(ebc, db, newTail));
            insertAt += 4;
            if (edgeCase) continue;
            buffer.deallocTail(tail, size);
            buffer.putInt(p, 0);
        }
    }

    private int allocTail(int size) {
        int alloc = this._alloc - (size = size + 3 & 0xFFFFFFFC);
        if (alloc >= this._keyBlockEnd) {
            this._alloc = alloc;
            return alloc;
        }
        return -1;
    }

    private void deallocTail(int tail, int size) {
        Debug.$assert0.t((size = size + 3 & 0xFFFFFFFC) > 0 && size <= this._bufferSize - this._alloc && tail >= this._alloc && tail < this._bufferSize && tail + size <= this._bufferSize);
        if (tail == this._alloc) {
            int kbNext;
            while (tail + size < this._bufferSize && ((kbNext = this.getInt(tail + size)) & 0x10000000) == 0) {
                int sizeNext = Buffer.decodeTailBlockSize(kbNext);
                Debug.$assert0.t((sizeNext & 3) == 0 && sizeNext != 0);
                this._slack -= sizeNext;
                this.putInt(tail + size, 0);
                size += sizeNext;
            }
            this._alloc += size;
        } else {
            this.putInt(tail, Buffer.encodeFreeBlock(size));
            this._slack += size;
        }
    }

    private void repack() {
        int size;
        Debug.$assert0.t(this.isOwnedAsWriterByMe());
        int[] plan = this.getRepackPlanBuffer();
        int free = 0;
        int back = 0;
        for (int tail = this._alloc; tail < this._bufferSize; tail += size) {
            int tbData = this.getInt(tail);
            size = Buffer.decodeTailBlockSize(tbData) + 3 & 0xFFFFFFFC;
            if (size <= 0) {
                this._persistit.fatal("Buffer has invalid tailblock length " + size + " at " + tail + " in " + this, null);
            }
            if ((tbData & 0x10000000) != 0) {
                plan[tail / 4] = back << 16 | free;
                free = 0;
                back = tail;
                continue;
            }
            free += size;
        }
        int alloc = this._bufferSize;
        int moveFrom = 0;
        int moveSize = 0;
        int tail = back;
        while (tail != 0) {
            moveFrom = tail;
            if (free > 0) {
                moveSize += alloc - tail - free;
            }
            alloc = tail + free;
            int planData = plan[tail / 4];
            plan[tail / 4] = free + tail;
            int deltaFree = planData & 0xFFFF;
            if (deltaFree > 0 && moveSize > 0 && free > 0) {
                System.arraycopy(this._bytes, moveFrom, this._bytes, moveFrom + free, moveSize);
                moveSize = 0;
            }
            free += deltaFree;
            tail = planData >>> 16;
        }
        if (moveSize > 0 && free > 0) {
            System.arraycopy(this._bytes, moveFrom, this._bytes, moveFrom + free, moveSize);
        }
        this._alloc = alloc;
        this._slack = 0;
        if (free > 0) {
            for (int p = 32; p < this._keyBlockEnd; p += 4) {
                int tail2;
                int newTail;
                int kbData = this.getInt(p);
                if (kbData == 0 || (newTail = plan[(tail2 = Buffer.decodeKeyBlockTail(kbData)) / 4]) == tail2) continue;
                this.putInt(p, Buffer.encodeKeyBlockTail(kbData, newTail));
            }
        }
    }

    private boolean willFit(int needed) {
        return needed <= this._alloc - this._keyBlockEnd + this._slack;
    }

    boolean isAfterRightEdge(int foundAt) {
        int p = foundAt & 0xFFFC;
        return p >= this._keyBlockEnd || p == this._keyBlockEnd - 4 && (foundAt & 1) != 0;
    }

    boolean isBeforeLeftEdge(int foundAt) {
        return (foundAt & 1) == 0 && (foundAt & 0xFFFC) <= 32 || (foundAt & 0xFFFC) < 32;
    }

    byte[] getBytes() {
        return this._bytes;
    }

    int getByte(int index) {
        return this._bytes[index] & 0xFF;
    }

    int getChar(int index) {
        return this._bytes[index + 1] & 0xFF | (this._bytes[index] & 0xFF) << 8;
    }

    int getInt(int index) {
        return this._bytes[index + 3] & 0xFF | (this._bytes[index + 2] & 0xFF) << 8 | (this._bytes[index + 1] & 0xFF) << 16 | (this._bytes[index] & 0xFF) << 24;
    }

    long getLong(int index) {
        return (long)(this._bytes[index + 7] & 0xFF) | (long)(this._bytes[index + 6] & 0xFF) << 8 | (long)(this._bytes[index + 5] & 0xFF) << 16 | (long)(this._bytes[index + 4] & 0xFF) << 24 | (long)(this._bytes[index + 3] & 0xFF) << 32 | (long)(this._bytes[index + 2] & 0xFF) << 40 | (long)(this._bytes[index + 1] & 0xFF) << 48 | (long)(this._bytes[index] & 0xFF) << 56;
    }

    int getDb(int index) {
        return this._bytes[index + 3] & 0xFF;
    }

    void putByte(int index, int value) {
        Debug.$assert0.t(index >= 0 && index + 1 <= this._bytes.length);
        this._bytes[index] = (byte)value;
    }

    void putChar(int index, int value) {
        Debug.$assert0.t(index >= 0 && index + 2 <= this._bytes.length);
        this._bytes[index + 1] = (byte)value;
        this._bytes[index] = (byte)(value >>> 8);
    }

    void putInt(int index, int value) {
        Debug.$assert0.t(index >= 0 && index + 4 <= this._bytes.length);
        this._bytes[index + 3] = (byte)value;
        this._bytes[index + 2] = (byte)(value >>> 8);
        this._bytes[index + 1] = (byte)(value >>> 16);
        this._bytes[index] = (byte)(value >>> 24);
    }

    void putLong(int index, long value) {
        Debug.$assert0.t(index >= 0 && index + 8 <= this._bytes.length);
        this._bytes[index + 7] = (byte)value;
        this._bytes[index + 6] = (byte)(value >>> 8);
        this._bytes[index + 5] = (byte)(value >>> 16);
        this._bytes[index + 4] = (byte)(value >>> 24);
        this._bytes[index + 3] = (byte)(value >>> 32);
        this._bytes[index + 2] = (byte)(value >>> 40);
        this._bytes[index + 1] = (byte)(value >>> 48);
        this._bytes[index] = (byte)(value >>> 56);
    }

    static void writeLongRecordDescriptor(byte[] bytes, int size, long pageAddr) {
        if (bytes.length != 120) {
            throw new IllegalArgumentException("Bad LONG_RECORD descriptor size: " + size);
        }
        bytes[0] = -1;
        bytes[1] = 0;
        Util.putChar(bytes, 2, 100);
        Util.putLong(bytes, 4, size);
        Util.putLong(bytes, 12, pageAddr);
    }

    static int decodeLongRecordDescriptorSize(byte[] bytes, int offset) {
        int type = bytes[offset] & 0xFF;
        if (type != 255) {
            throw new IllegalArgumentException("Bad LONG_RECORD descriptor type: " + type);
        }
        return (int)Util.getLong(bytes, offset + 4);
    }

    static long decodeLongRecordDescriptorPointer(byte[] bytes, int offset) {
        int type = bytes[offset] & 0xFF;
        if (type != 255) {
            throw new IllegalArgumentException("Bad LONG_RECORD descriptor type: " + type);
        }
        return Util.getLong(bytes, offset + 12);
    }

    static int bufferSizeWithOverhead(int bufferSize) {
        int fastIndexSize = (bufferSize - 32) / 16 * 2;
        return bufferSize + fastIndexSize + 200;
    }

    public boolean isUnallocatedPage() {
        return this._type == 0;
    }

    public boolean isDataPage() {
        return this._type == 1;
    }

    public boolean isIndexPage() {
        return this._type >= 2 && this._type <= 21;
    }

    public boolean isGarbagePage() {
        return this._type == 30;
    }

    public boolean isHeadPage() {
        return this._type == 32;
    }

    public boolean isLongRecordPage() {
        return this._type == 31;
    }

    static int tailBlockSize(int size) {
        return size + 3 & 0xFFFFFFFC;
    }

    static int encodeKeyBlock(int ebc, int db, int tail) {
        return ebc << 8 & 0xFFF00 | db & 0xFF | tail << 18 & 0xFFF00000;
    }

    static int encodeKeyBlockTail(int kbData, int tail) {
        return kbData & 0xFFFFF | tail << 18 & 0xFFF00000;
    }

    static int encodeTailBlock(int size, int klength) {
        return klength << 16 & 0xFFF0000 | size & 0xFFFF | 0x10000000;
    }

    static int encodeFreeBlock(int size) {
        return size & 0xFFFF;
    }

    static int decodeKeyBlockEbc(int kbData) {
        return (kbData & 0xFFF00) >>> 8;
    }

    static int decodeKeyBlockDb(int kbData) {
        return kbData & 0xFF;
    }

    static int decodeKeyBlockTail(int kbData) {
        return (kbData & 0xFFF00000) >>> 18;
    }

    static int decodeTailBlockSize(int tbData) {
        return tbData & 0xFFFF;
    }

    static int decodeTailBlockKLength(int tbData) {
        return (tbData & 0xFFF0000) >>> 16;
    }

    static boolean decodeTailBlockInUse(int tbData) {
        return (tbData & 0x10000000) != 0;
    }

    static int decodeDepth(int foundAt) {
        return (foundAt & 0xFFF0000) >>> 16;
    }

    final int[] getRepackPlanBuffer() {
        return this._persistit.getThreadLocalIntArray(4096);
    }

    PersistitException verify(Key key, VerifyVisitor visitor) {
        try {
            int size;
            if (this._page == 0L) {
                return new InvalidPageStructureException("head page is neither a data page nor an index page");
            }
            if (!this.isIndexPage() && !this.isDataPage()) {
                return new InvalidPageStructureException("page type " + this._type + " is neither data page nor an index page");
            }
            if (key == null) {
                key = new Key(this._persistit);
            }
            byte[] kb = key.getEncodedBytes();
            int[] plan = this.getRepackPlanBuffer();
            for (int index = 0; index < plan.length; ++index) {
                plan[index] = 0;
            }
            if (visitor != null) {
                visitor.visitPage(this.getTimestamp(), this.getVolume(), this.getPageAddress(), this.getPageType(), this.getBufferSize(), this.getKeyBlockStart(), this.getKeyBlockEnd(), this.getAlloc(), this.getAvailableSize(), this.getRightSibling());
            }
            for (int p = 32; p < this._keyBlockEnd; p += 4) {
                int dbPrev;
                int kbData = this.getInt(p);
                int db = Buffer.decodeKeyBlockDb(kbData);
                int ebc = Buffer.decodeKeyBlockEbc(kbData);
                int tail = Buffer.decodeKeyBlockTail(kbData);
                if (p == 32 && ebc != 0) {
                    return new InvalidPageStructureException("invalid initial ebc " + ebc + " for keyblock at " + p + " --[" + this.summarize() + "]");
                }
                if (tail < this._keyBlockEnd || tail < this._alloc || tail > this._bufferSize - this._tailHeaderSize || (tail & 3) != 0) {
                    return new InvalidPageStructureException("invalid tail block offset " + tail + " for keyblock at " + p + " --[" + this.summarize() + "]");
                }
                int tbData = this.getInt(tail);
                int klength = Buffer.decodeTailBlockKLength(tbData);
                if ((tbData & 0x10000000) == 0) {
                    return new InvalidPageStructureException("not in-use tail block offset " + tail + " for keyblock at " + p + " --[" + this.summarize() + "]");
                }
                if (p == 32 && key.getEncodedSize() != 0) {
                    int index = 0;
                    int compare = 0;
                    int size2 = key.getEncodedSize();
                    if (klength < size2) {
                        size2 = klength + 1;
                    }
                    compare = (kb[0] & 0xFF) - db;
                    while (compare == 0 && ++index < size2) {
                        compare = (kb[index] & 0xFF) - (this._bytes[tail + this._tailHeaderSize + index - 1] & 0xFF);
                    }
                    if (compare != 0) {
                        String s = compare < 0 ? "too big" : "too small";
                        return new InvalidPageStructureException("initial key " + s + " at offset " + index + " for keyblock at " + p + " --[" + this.summarize() + "]");
                    }
                }
                if (p > 32 && ebc < key.getEncodedSize() && db < (dbPrev = kb[ebc] & 0xFF)) {
                    return new InvalidPageStructureException("db not greater: db=" + db + " dbPrev=" + dbPrev + " for keyblock at " + p + " --[" + this.summarize() + "]");
                }
                if (this.isIndexPage()) {
                    int pointer = this.getInt(tail + 4);
                    if (visitor != null) {
                        visitor.visitIndexRecord(key, p, tail, klength, pointer);
                    }
                    if (pointer == -1 && p + 4 != this._keyBlockEnd) {
                        return new InvalidPageStructureException("index pointer has pointer to -1  for keyblock at " + p + " --[" + this.summarize() + "]");
                    }
                } else if (this.isDataPage()) {
                    int size3 = Buffer.decodeTailBlockSize(tbData);
                    int offset = tail + this._tailHeaderSize + klength;
                    int length = size3 - klength - this._tailHeaderSize;
                    if (visitor != null) {
                        visitor.visitDataRecord(key, p, tail, klength, offset, length, this.getBytes());
                    }
                    if (!MVV.verify(this._bytes, offset, length)) {
                        throw new InvalidPageStructureException("invalid MVV record at offset/length=" + offset + "/" + length);
                    }
                }
                if (this._pool != null && this.getKeyCount() > this._pool.getMaxKeys()) {
                    return new InvalidPageStructureException("page has too many keys: has " + this.getKeyCount() + " but max is " + this._pool.getMaxKeys());
                }
                kb[ebc] = (byte)db;
                System.arraycopy(this._bytes, tail + this._tailHeaderSize, kb, ebc + 1, klength);
                key.setEncodedSize(ebc + klength + 1);
                plan[tail / 4] = p;
            }
            int formerBlock = this._alloc;
            for (int tail = this._alloc; tail < this._bufferSize; tail += size + 3 & 0xFFFFFFFC) {
                if ((tail & 3) != 0 || tail < 0 || tail > this._bufferSize) {
                    return new InvalidPageStructureException("Tail block at " + formerBlock + " is invalid");
                }
                int tbData = this.getInt(tail);
                size = Buffer.decodeTailBlockSize(tbData);
                if (size <= 3 || size >= this._bufferSize - this._keyBlockEnd) {
                    return new InvalidPageStructureException("Tailblock at " + tail + " has invalid size=" + size);
                }
                if ((tbData & 0x10000000) != 0) {
                    if (plan[tail / 4] == 0) {
                        return new InvalidPageStructureException("Tailblock at " + tail + " is in use, but no key " + " block points to it.");
                    }
                    int klength = Buffer.decodeTailBlockKLength(tbData);
                    if (klength + this._tailHeaderSize <= size) continue;
                    return new InvalidPageStructureException("Tailblock at " + tail + " has klength=" + klength + " longer than size=" + size + " - headerSize=" + this._tailHeaderSize);
                }
                if (plan[tail / 4] == 0) continue;
                return new InvalidPageStructureException("Tailblock at " + tail + " is marked free, but the " + " key block at " + plan[tail / 4] + " points to it.");
            }
            return null;
        }
        catch (PersistitException pe) {
            return pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pruneMvvValues(Tree tree, boolean pruneLongMVVs, List<CleanupManager.CleanupAction> cleanupActions) throws PersistitException {
        boolean changed = false;
        boolean hasLongMvvRecords = false;
        if (!this.isOwnedAsWriterByMe()) {
            throw new IllegalStateException("Exclusive claim required " + this);
        }
        if (this.isDataPage() && this._mvvCount != 0) {
            long timestamp = this._persistit.getTimestampAllocator().updateTimestamp();
            this._mvvCount = 0;
            this.writePageOnCheckpoint(timestamp);
            int flags = this.pruneMvvValuesHelper(tree, cleanupActions);
            changed = (flags & 1) != 0;
            boolean bl = hasLongMvvRecords = (flags & 2) != 0;
            if (changed) {
                this.setDirtyAtTimestamp(timestamp);
            }
            ArrayList<MVV.PrunedVersion> prunedVersions = new ArrayList<MVV.PrunedVersion>();
            if (pruneLongMVVs && hasLongMvvRecords) {
                Buffer copy = new Buffer(this);
                ArrayList<PersistitException> deferredExceptions = new ArrayList<PersistitException>();
                ArrayList<Long> oldChainsToDeallocate = new ArrayList<Long>();
                boolean copyChanged = copy.pruneLongMvvValues(tree, prunedVersions, deferredExceptions, oldChainsToDeallocate, cleanupActions);
                if (copyChanged) {
                    changed = true;
                    long copyTimestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                    this.writePageOnCheckpoint(copyTimestamp);
                    System.arraycopy(copy._bytes, 0, this._bytes, 0, this._bufferSize);
                    this._alloc = copy._alloc;
                    this._slack = copy._slack;
                    this._mvvCount = copy._mvvCount;
                    if (this._keyBlockEnd != copy._keyBlockEnd) {
                        this._keyBlockEnd = copy._keyBlockEnd;
                        this.invalidateFastIndex();
                    }
                    this.setDirtyAtTimestamp(copyTimestamp);
                    Buffer.deallocatePrunedVersions(this._persistit, this._vol, prunedVersions);
                    for (Long oldLongRecordChain : oldChainsToDeallocate) {
                        this._vol.getStructure().deallocateGarbageChain(oldLongRecordChain, 0L);
                    }
                }
                if (!deferredExceptions.isEmpty()) {
                    ++this._mvvCount;
                    throw (PersistitException)deferredExceptions.get(0);
                }
            }
        }
        return changed;
    }

    private int pruneMvvValuesHelper(Tree tree, List<CleanupManager.CleanupAction> cleanupActions) throws PersistitException {
        boolean changed = false;
        boolean hasLongMvvRecords = false;
        ArrayList<MVV.PrunedVersion> prunedVersions = new ArrayList<MVV.PrunedVersion>();
        for (int p = 32; p < this._keyBlockEnd; p += 4) {
            int kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int oldTailSize = Buffer.decodeTailBlockSize(tbData);
            int offset = tail + this._tailHeaderSize + klength;
            int oldSize = oldTailSize - klength - this._tailHeaderSize;
            if (oldSize <= 0) continue;
            int valueByte = this._bytes[offset] & 0xFF;
            if (Buffer.isLongMVV(this._bytes, offset, oldSize)) {
                hasLongMvvRecords = true;
            }
            if (valueByte == 254) {
                int newSize = MVV.prune(this._bytes, offset, oldSize, this._persistit.getTransactionIndex(), true, prunedVersions);
                if (newSize != oldSize) {
                    changed = true;
                    int newTailSize = klength + newSize + this._tailHeaderSize;
                    int newNext = tail + newTailSize + 3 & 0xFFFFFFFC;
                    int oldNext = tail + oldTailSize + 3 & 0xFFFFFFFC;
                    if (newNext < oldNext) {
                        this.deallocTail(newNext, oldNext - newNext);
                    } else {
                        Debug.$assert0.t(newNext == oldNext);
                    }
                    this.putInt(tail, Buffer.encodeTailBlock(newTailSize, klength));
                    Debug.$assert0.t(MVV.verify(this._bytes, offset, newSize));
                }
                valueByte = newSize > 0 ? this._bytes[offset] & 0xFF : -1;
                this.incCountIfMvv(this._bytes, offset, newSize);
            }
            if (!this.pruneAntiValue(valueByte, p, tree, cleanupActions)) continue;
            changed = true;
            p -= 4;
        }
        Buffer.deallocatePrunedVersions(this._persistit, this._vol, prunedVersions);
        prunedVersions.clear();
        return (changed ? 1 : 0) | (hasLongMvvRecords ? 2 : 0);
    }

    private boolean pruneLongMvvValues(Tree tree, List<MVV.PrunedVersion> prunedVersions, List<PersistitException> deferredExceptions, List<Long> toDeallocate, List<CleanupManager.CleanupAction> cleanupActions) {
        boolean changed = false;
        for (int p = 32; p < this._keyBlockEnd; p += 4) {
            int kbData = this.getInt(p);
            int tail = Buffer.decodeKeyBlockTail(kbData);
            int tbData = this.getInt(tail);
            int klength = Buffer.decodeTailBlockKLength(tbData);
            int oldTailSize = Buffer.decodeTailBlockSize(tbData);
            int offset = tail + this._tailHeaderSize + klength;
            int oldSize = oldTailSize - klength - this._tailHeaderSize;
            if (oldSize <= 0) continue;
            int valueByte = this._bytes[offset] & 0xFF;
            if (Buffer.isLongMVV(this._bytes, offset, oldSize)) {
                Value value = this._persistit.getThreadLocalValue();
                boolean pruned = false;
                try {
                    pruned = this.pruneLongMvv(this._bytes, offset, oldSize, value, prunedVersions, toDeallocate);
                }
                catch (PersistitException pe) {
                    deferredExceptions.add(pe);
                }
                if (pruned) {
                    changed = true;
                    int newSize = value.getEncodedSize();
                    assert (newSize <= oldSize) : "Pruned long value overflow";
                    System.arraycopy(value.getEncodedBytes(), 0, this._bytes, offset, newSize);
                    int newTailSize = klength + newSize + this._tailHeaderSize;
                    int oldNext = tail + oldTailSize + 3 & 0xFFFFFFFC;
                    int newNext = tail + newTailSize + 3 & 0xFFFFFFFC;
                    if (newNext < oldNext) {
                        this.deallocTail(newNext, oldNext - newNext);
                    } else {
                        Debug.$assert0.t(newNext == oldNext);
                    }
                    this.putInt(tail, Buffer.encodeTailBlock(newTailSize, klength));
                    valueByte = newSize > 0 ? this._bytes[offset] & 0xFF : -1;
                    value.changeLongRecordMode(false);
                }
            }
            if (!this.pruneAntiValue(valueByte, p, tree, cleanupActions)) continue;
            changed = true;
            p -= 4;
        }
        return changed;
    }

    private boolean pruneAntiValue(int valueByte, int p, Tree tree, List<CleanupManager.CleanupAction> cleanupActions) {
        if (valueByte == 49) {
            if (p == 32) {
                if (tree != null) {
                    int treeHandle = tree.getHandle();
                    assert (treeHandle != 0) : "MVV found in a temporary tree " + tree;
                    if (cleanupActions != null) {
                        cleanupActions.add(new CleanupManager.CleanupAntiValue(treeHandle, this.getPageAddress()));
                    } else if (!this._enqueuedForAntiValuePruning && this._persistit.getCleanupManager().offer(new CleanupManager.CleanupAntiValue(treeHandle, this.getPageAddress()))) {
                        this._enqueuedForAntiValuePruning = true;
                    }
                } else {
                    ++this._mvvCount;
                }
            } else if (p == this._keyBlockEnd - 4) {
                Debug.$assert1.t(false);
            } else {
                boolean removed = this.removeKeys(p | 1, p | 1, this._persistit.getThreadLocalKey());
                Debug.$assert0.t(removed);
                return true;
            }
        }
        return false;
    }

    private boolean pruneLongMvv(byte[] bytes, int offset, int oldSize, Value value, List<MVV.PrunedVersion> prunedVersions, List<Long> toDeallocate) throws PersistitException {
        assert (Buffer.isLongMVV(bytes, offset, oldSize)) : "Not a long MVV";
        long oldLongRecordChain = Buffer.decodeLongRecordDescriptorPointer(bytes, offset);
        value.changeLongRecordMode(false);
        value.ensureFit(oldSize);
        System.arraycopy(bytes, offset, value.getEncodedBytes(), 0, oldSize);
        value.setEncodedSize(oldSize);
        LongRecordHelper helper = new LongRecordHelper(this._persistit, this._vol);
        helper.fetchLongRecord(value, Integer.MAX_VALUE, 60000L);
        byte[] rawBytes = value.getEncodedBytes();
        int oldLongSize = value.getEncodedSize();
        Debug.$assert0.t(MVV.verify(rawBytes, 0, oldLongSize));
        ArrayList<MVV.PrunedVersion> provisionalPrunedVersions = new ArrayList<MVV.PrunedVersion>();
        int newLongSize = MVV.prune(rawBytes, 0, oldLongSize, this._persistit.getTransactionIndex(), true, provisionalPrunedVersions);
        if (newLongSize == oldLongSize) {
            return false;
        }
        value.setEncodedSize(newLongSize);
        if (newLongSize > oldSize) {
            helper.storeLongRecord(value, false);
        }
        if (oldLongRecordChain != 0L) {
            toDeallocate.add(oldLongRecordChain);
        }
        prunedVersions.addAll(provisionalPrunedVersions);
        return true;
    }

    public String summarize() {
        return String.format("Page=%,d type=%s rightSibling=%,d status=%s start=%d end=%d size=%d alloc=%d slack=%d index=%d timestamp=%,d generation=%,d", this._page, this.getPageTypeName(), this._rightSibling, this.getStatusDisplayString(), 32, this._keyBlockEnd, this._bufferSize, this._alloc, this._slack, this.getIndex(), this.getTimestamp(), this.getGeneration());
    }

    @Override
    public String toString() {
        if (this._toStringDebug) {
            return this.toStringDetail();
        }
        return String.format("Page %,d in volume %s at index %,d timestamp=%,d status=%s type=%s", this._page, this._vol, this._poolIndex, this._timestamp, this.getStatusDisplayString(), this.getPageTypeName());
    }

    public String toStringDetail() {
        return this.toStringDetail(-1L, 42, 42, 0, true);
    }

    String toStringDetail(long findPointer, int maxKeyDisplayLength, int maxValueDisplayLength, int contextLines, boolean all) {
        StringBuilder sb = new StringBuilder(String.format("Page %,d in volume %s at index @%,d status %s type %s", this._page, this._vol, this._poolIndex, this.getStatusDisplayString(), this.getPageTypeName()));
        if (!this.isValid()) {
            sb.append(" - invalid");
        } else if (this.isDataPage() || this.isIndexPage()) {
            sb.append(String.format("\n  type=%,d  alloc=%,d  slack=%,d  keyBlockStart=%,d  keyBlockEnd=%,d timestamp=%,d generation=%,d right=%,d hash=%,d", this._type, this._alloc, this._slack, 32, this._keyBlockEnd, this.getTimestamp(), this.getGeneration(), this.getRightSibling(), this._pool.hashIndex(this._vol, this._page)));
            try {
                Key key = new Key(this._persistit);
                Value value = new Value(this._persistit);
                Management.RecordInfo[] records = this.getRecords();
                int foundPointerRecord = -1;
                if (this.isIndexPage() && findPointer >= 0L) {
                    for (int index = 0; index < records.length; ++index) {
                        if (records[index].getPointerValue() != findPointer) continue;
                        foundPointerRecord = index;
                    }
                }
                boolean elision = false;
                for (int index = 0; index < records.length; ++index) {
                    boolean selected;
                    Management.RecordInfo r = records[index];
                    String mark = " ";
                    boolean bl = selected = all | index < contextLines || index >= records.length - contextLines;
                    if (foundPointerRecord >= 0) {
                        selected |= index >= foundPointerRecord - contextLines && index <= foundPointerRecord + contextLines;
                        if (index == foundPointerRecord) {
                            mark = "*";
                        }
                    }
                    if (selected) {
                        String valueString;
                        String keyString;
                        if (r.getKeyState() != null) {
                            r.getKeyState().copyTo(key);
                            keyString = Util.abridge(key.toString(), maxKeyDisplayLength);
                        } else {
                            keyString = "*error*";
                        }
                        if (this.isDataPage() && r.getValueState() != null) {
                            r.getValueState().copyTo(value);
                            valueString = Util.abridge(value.toString(), maxValueDisplayLength);
                        } else {
                            valueString = "*error*";
                        }
                        if (elision) {
                            sb.append(String.format("\n     ...", new Object[0]));
                            elision = false;
                        }
                        if (this.isDataPage()) {
                            r.getValueState().copyTo(value);
                            sb.append(String.format("\n%s   %5d: db=%3d ebc=%3d tb=%,5d [%,d]%s=[%,d]%s", mark, r.getKbOffset(), r.getDb(), r.getEbc(), r.getTbOffset(), r.getKLength(), keyString, r.getValueState().getEncodedBytes().length, valueString));
                        } else {
                            sb.append(String.format("\n%s  %5d: db=%3d ebc=%3d tb=%,5d [%,d]%s->%,d", mark, r.getKbOffset(), r.getDb(), r.getEbc(), r.getTbOffset(), r.getKLength(), keyString, r.getPointerValue()));
                        }
                        if (r.getError() == null) continue;
                        sb.append(String.format(" !! %s", r.getError()));
                        continue;
                    }
                    elision = true;
                }
            }
            catch (Exception e) {
                sb.append(" - " + e);
            }
        } else if (this.isHeadPage()) {
            sb.append(String.format("\n  type=%,d  timestamp=%,d generation=%,d right=%,d hash=%,d", this._type, this.getTimestamp(), this.getGeneration(), this.getRightSibling(), this._pool.hashIndex(this._vol, this._page)));
            sb.append(String.format("\n  nextAvailablePage=%,d extendedPageCount=%,d  directoryRootPage=%,d garbageRootPage=%,d id=%,d ", VolumeHeader.getNextAvailablePage(this._bytes), VolumeHeader.getExtendedPageCount(this._bytes), VolumeHeader.getDirectoryRoot(this._bytes), VolumeHeader.getGarbageRoot(this._bytes), VolumeHeader.getId(this._bytes)));
        } else if (this.isGarbagePage()) {
            sb.append(String.format("\n  type=%,d  timestamp=%,d generation=%,d right=%,d hash=%,d", this._type, this.getTimestamp(), this.getGeneration(), this.getRightSibling(), this._pool.hashIndex(this._vol, this._page)));
            for (int p = this._alloc; p < this._bufferSize; p += 32) {
                sb.append(String.format("\n  garbage chain @%,6d : %,d -> %,d", p, this.getLong(p + 8), this.getLong(p + 16)));
            }
        } else {
            sb.append(String.format("\n  type=%,d  timestamp=%,d generation=%,d right=%,d hash=%,d\n", this._type, this.getTimestamp(), this.getGeneration(), this.getRightSibling(), this._pool.hashIndex(this._vol, this._page)));
        }
        return sb.toString();
    }

    String foundAtString(int p) {
        StringBuilder sb = new StringBuilder("<");
        sb.append(p & 0xFFFC);
        if ((p & 1) != 0) {
            sb.append(":exact");
        }
        if ((p & 0x40000000) > 0) {
            sb.append(":fixup");
        }
        sb.append(":depth=");
        sb.append(Buffer.decodeDepth(p));
        if ((p &= 0xFFFC) < 32) {
            sb.append(":before");
        } else if (p >= this._keyBlockEnd) {
            sb.append(":after");
        } else if (p + 4 == this._keyBlockEnd) {
            sb.append(":end");
        } else {
            int kbData = this.getInt(p);
            sb.append(":ebc=" + Buffer.decodeKeyBlockEbc(kbData));
            sb.append(":db=" + Buffer.decodeKeyBlockDb(kbData));
            sb.append(":tail=" + Buffer.decodeKeyBlockTail(kbData));
        }
        sb.append(">");
        return sb.toString();
    }

    public Management.RecordInfo[] getRecords() {
        Management.RecordInfo[] result;
        block12: {
            block11: {
                result = null;
                if (!this.isIndexPage() && !this.isDataPage()) break block11;
                Key key = new Key(this._persistit);
                Value value = new Value(this._persistit);
                int count = (this._keyBlockEnd - 32) / 4;
                result = new Management.RecordInfo[count];
                int n = 0;
                for (int p = 32; p < this._keyBlockEnd; p += 4) {
                    Management.RecordInfo rec;
                    block10: {
                        rec = new Management.RecordInfo();
                        try {
                            int tail;
                            rec._kbOffset = p;
                            int kbData = this.getInt(p);
                            int db = Buffer.decodeKeyBlockDb(kbData);
                            int ebc = Buffer.decodeKeyBlockEbc(kbData);
                            rec._tbOffset = tail = Buffer.decodeKeyBlockTail(kbData);
                            rec._ebc = ebc;
                            rec._db = db;
                            int tbData = tail != 0 ? this.getInt(tail) : 0;
                            int size = Buffer.decodeTailBlockSize(tbData);
                            int klength = Buffer.decodeTailBlockKLength(tbData);
                            boolean inUse = Buffer.decodeTailBlockInUse(tbData);
                            rec._klength = klength;
                            rec._size = size;
                            rec._inUse = inUse;
                            byte[] kbytes = key.getEncodedBytes();
                            kbytes[ebc] = (byte)db;
                            System.arraycopy(this._bytes, tail + this._tailHeaderSize, kbytes, ebc + 1, klength);
                            key.setEncodedSize(ebc + 1 + klength);
                            rec._key = new KeyState(key);
                            if (this.isIndexPage()) {
                                rec._pointerValue = this.getInt(tail + 4);
                            } else {
                                int vsize = size - this._tailHeaderSize - klength;
                                if (vsize < 0) {
                                    vsize = 0;
                                }
                                value.putEncodedBytes(this._bytes, tail + this._tailHeaderSize + klength, vsize);
                                if (value.isDefined() && (value.getEncodedBytes()[0] & 0xFF) == 255) {
                                    value.setLongRecordMode(true);
                                } else {
                                    value.setLongRecordMode(false);
                                }
                                rec._value = new ValueState(value);
                            }
                        }
                        catch (Exception e) {
                            rec._error = e.toString();
                            if (rec._key == null) {
                                rec._key = new KeyState(new Key(this._persistit));
                            }
                            if (rec._value != null) break block10;
                            rec._value = new ValueState(new Value(this._persistit));
                        }
                    }
                    result[n++] = rec;
                }
                break block12;
            }
            if (!this.isGarbagePage()) break block12;
            int count = (this._bufferSize - this._alloc) / 32;
            result = new Management.RecordInfo[count];
            int n = 0;
            for (int p = this._alloc; p < this._bufferSize; p += 32) {
                Management.RecordInfo rec = new Management.RecordInfo();
                rec._tbOffset = p;
                rec._garbageStatus = this.getInt(p + 4);
                rec._garbageLeftPage = this.getLong(p + 8);
                rec._garbageRightPage = this.getLong(p + 16);
                result[n++] = rec;
            }
        }
        return result;
    }

    void assertVerify() {
    }

    boolean addGarbageChain(long left, long right, long expectedCount) {
        Debug.$assert0.t(left > 0L && left <= 0x7FFFFFFEL && left != this._page && right != this._page && this.isGarbagePage());
        if (this._alloc - 32 < this._keyBlockEnd) {
            return false;
        }
        assert (!this.chainIsRedundant(left)) : "Attempting to add a redundate garbage chain " + left + "->" + right + " to " + this;
        this._alloc -= 32;
        this.putInt(this._alloc + 4, 0);
        this.putLong(this._alloc + 8, left);
        this.putLong(this._alloc + 16, right);
        this.putLong(this._alloc + 24, expectedCount);
        this.bumpGeneration();
        return true;
    }

    private boolean chainIsRedundant(long left) {
        for (int p = this._alloc; p < this._bufferSize; p += 32) {
            long oldLeft = this.getGarbageChainLeftPage(p);
            if (oldLeft != left) continue;
            return true;
        }
        return false;
    }

    int getGarbageChainStatus() {
        Debug.$assert0.t(this.isGarbagePage());
        if (this._alloc + 32 > this._bufferSize) {
            return -1;
        }
        return this.getInt(this._alloc + 4);
    }

    long getGarbageChainLeftPage() {
        Debug.$assert0.t(this.isGarbagePage());
        if (this._alloc + 32 > this._bufferSize) {
            return -1L;
        }
        long page = this.getLong(this._alloc + 8);
        Debug.$assert0.t(page > 0L && page <= 0x7FFFFFFEL && page != this._page);
        return page;
    }

    long getGarbageChainRightPage() {
        Debug.$assert1.t(this.isGarbagePage());
        if (this._alloc + 32 > this._bufferSize) {
            return -1L;
        }
        return this.getLong(this._alloc + 16);
    }

    long getGarbageChainLeftPage(int p) {
        long page = this.getLong(p + 8);
        Debug.$assert1.t(page > 0L && page <= 0x7FFFFFFEL && page != this._page);
        return page;
    }

    long getGarbageChainRightPage(int p) {
        return this.getLong(p + 16);
    }

    void removeGarbageChain() {
        Debug.$assert1.t(this.isGarbagePage() && this._alloc + 32 <= this._bufferSize);
        this.clearBytes(this._alloc, this._alloc + 32);
        this._alloc += 32;
        this.bumpGeneration();
    }

    void setGarbageLeftPage(long left) {
        Debug.$assert1.t(this.isOwnedAsWriterByMe() && this.isGarbagePage() && left > 0L && left <= 0x7FFFFFFEL && left != this._page && this._alloc + 32 <= this._bufferSize && this._alloc >= this._keyBlockEnd);
        this.putLong(this._alloc + 8, left);
        this.bumpGeneration();
    }

    void populateInfo(Management.BufferInfo info) {
        info.poolIndex = this._poolIndex;
        info.pageAddress = this._page;
        info.rightSiblingAddress = this._rightSibling;
        Volume vol = this._vol;
        info.volumeName = vol != null ? vol.getPath() : null;
        info.type = this._type;
        info.typeName = this.getPageTypeName();
        info.bufferSize = this._bufferSize;
        info.keyBlockStart = 32;
        info.keyBlockEnd = this._keyBlockEnd;
        info.availableBytes = this.getAvailableSize();
        info.alloc = this._alloc;
        info.slack = this._slack;
        info.timestamp = this._timestamp;
        info.status = this.getStatus();
        info.statusName = this.getStatusCode();
        Thread writerThread = this.getWriterThread();
        info.writerThreadName = writerThread != null ? writerThread.getName() : null;
        info.updateAcquisitonTime();
    }

    void enqueuePruningAction(int treeHandle) {
        long delay;
        if (this._mvvCount > 0 && (delay = this._persistit.getCleanupManager().getMinimumPruningDelay()) > 0L) {
            long last = this._lastPrunedTime;
            long now = System.currentTimeMillis();
            if (now - last > delay) {
                this._lastPrunedTime = now;
                this._persistit.getCleanupManager().offer(new CleanupManager.CleanupPruneAction(treeHandle, this.getPageAddress()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(ByteBuffer bb, boolean secure, boolean verbose, Set<Volume> identifiedVolumes) throws Exception {
        int volumeHandle;
        long timestamp;
        long rightSibling;
        Volume volume;
        long page;
        int slack;
        int alloc;
        int keyBlockEnd;
        int type;
        int bufferSize;
        byte[] bytes = new byte[this._bufferSize];
        boolean claimed = this.claim(false, 500L);
        try {
            bufferSize = this._bufferSize;
            type = this._type;
            keyBlockEnd = this._keyBlockEnd;
            alloc = this._alloc;
            slack = this._slack;
            page = this._page;
            volume = this._vol;
            rightSibling = this._rightSibling;
            timestamp = this._timestamp;
            System.arraycopy(this._bytes, 0, bytes, 0, bufferSize);
        }
        finally {
            if (claimed) {
                this.release();
            }
        }
        String toString = this.toString();
        if (verbose) {
            System.out.println(toString);
        }
        int n = volumeHandle = volume == null ? 0 : volume.getHandle();
        if (volume != null && !identifiedVolumes.contains(volume)) {
            JournalRecord.IV.putType(bb);
            JournalRecord.IV.putHandle(bb, volumeHandle);
            JournalRecord.IV.putVolumeId(bb, volume.getId());
            JournalRecord.IV.putTimestamp(bb, 0L);
            if (this._persistit.getConfiguration().isUseOldVSpec()) {
                JournalRecord.IV.putVolumeSpecification(bb, volume.getName());
            } else {
                JournalRecord.IV.putVolumeSpecification(bb, volume.getSpecification().toString());
            }
            bb.position(bb.position() + JournalRecord.IV.getLength(bb));
            identifiedVolumes.add(volume);
        }
        boolean isDataPage = type == 1;
        boolean isIndexPage = type >= 2 && type <= 21;
        boolean isLongRecordPage = type == 31;
        Util.putLong(bytes, 24, timestamp);
        if (page != 0L) {
            Util.putByte(bytes, 0, type);
            Util.putByte(bytes, 1, bufferSize / 256);
            Util.putChar(bytes, 2, keyBlockEnd);
            Util.putChar(bytes, 4, alloc);
            Util.putChar(bytes, 6, slack);
            Util.putLong(bytes, 8, page);
            Util.putLong(bytes, 16, rightSibling);
        }
        if (isDataPage && secure) {
            this.dumpSecureOverwriteValues(bytes);
        }
        int left = bufferSize;
        int right = 0;
        if (isDataPage || isIndexPage) {
            if (32 <= keyBlockEnd && keyBlockEnd <= alloc && alloc < left) {
                right = left - alloc;
                left = keyBlockEnd;
            }
        } else if (secure && isLongRecordPage) {
            left = 32;
        }
        int recordSize = 36 + left + right;
        JournalRecord.PA.putLength(bb, recordSize);
        JournalRecord.PA.putType(bb);
        JournalRecord.PA.putVolumeHandle(bb, volumeHandle);
        JournalRecord.PA.putTimestamp(bb, timestamp);
        JournalRecord.PA.putLeftSize(bb, left);
        JournalRecord.PA.putBufferSize(bb, bufferSize);
        JournalRecord.PA.putPageAddress(bb, page);
        bb.position(bb.position() + 36);
        bb.put(bytes, 0, left);
        bb.put(bytes, bufferSize - right, right);
    }

    private void dumpSecureOverwriteValues(byte[] bytes) {
        int tbSize;
        if (bytes[0] != 1) {
            return;
        }
        for (int p = 32; p < Util.getInt(bytes, 2); p += 4) {
            int tail;
            int kbData = Util.getInt(bytes, p);
            int db = Buffer.decodeKeyBlockDb(kbData);
            if (db == 0 && p == 32) continue;
            if (db != 128 || bytes[(tail = Buffer.decodeKeyBlockTail(kbData)) + 4] != 95) break;
            return;
        }
        for (int tail = Util.getChar(bytes, 4); tail < bytes.length; tail += tbSize) {
            int keep;
            int tbData = Util.getInt(bytes, tail);
            tbSize = Buffer.decodeTailBlockSize(tbData) + 3 & 0xFFFFFFFC;
            int tbKLength = Buffer.decodeTailBlockKLength(tbData);
            if (tbSize < 4 || tbSize + tail > bytes.length) break;
            boolean tbInUse = Buffer.decodeTailBlockInUse(tbData);
            if (tbInUse) {
                keep = 4 + tbKLength;
                if (tbSize - keep >= 100 && Util.getByte(bytes, tail + keep) == 255) {
                    keep += 20;
                }
                if (keep < 4 && keep > tbSize) {
                    keep = tbSize;
                }
            } else {
                keep = 4;
            }
            for (int fill = keep; fill < tbSize; ++fill) {
                bytes[tail + fill] = (byte)(fill == keep ? 32 : 120);
            }
        }
    }

    static void deallocatePrunedVersions(Persistit persistit, Volume volume, List<MVV.PrunedVersion> prunedVersions) {
        for (MVV.PrunedVersion pv : prunedVersions) {
            TransactionStatus ts = persistit.getTransactionIndex().getStatus(pv.getTs());
            if (ts != null && ts.getTc() == Long.MIN_VALUE) {
                ts.decrementMvvCount();
            }
            if (pv.getLongRecordPage() == 0L) continue;
            try {
                volume.getStructure().deallocateGarbageChain(pv.getLongRecordPage(), 0L);
            }
            catch (PersistitException e) {
                persistit.getLogBase().pruneException.log(e, ts);
            }
        }
        prunedVersions.clear();
    }

    static boolean isLongRecord(byte[] bytes, int offset, int length) {
        return length > 0 && (bytes[offset] & 0xFF) == 255;
    }

    static boolean isLongMVV(byte[] bytes, int offset, int length) {
        return Buffer.isLongRecord(bytes, offset, length) && length > 20 && MVV.isArrayMVV(bytes, offset + 20, length - 20);
    }

    static boolean isValueMVV(byte[] bytes, int offset, int length) {
        return MVV.isArrayMVV(bytes, offset, length) || Buffer.isLongMVV(bytes, offset, length);
    }

    private void incCountIfMvv(byte[] bytes, int offset, int length) {
        if (Buffer.isValueMVV(bytes, offset, length)) {
            ++this._mvvCount;
        }
    }

    static abstract class VerifyVisitor {
        VerifyVisitor() {
        }

        protected void visitPage(long timestamp, Volume volume, long page, int type, int bufferSize, int keyBlockStart, int keyBlockEnd, int alloc, int available, long rightSibling) throws PersistitException {
        }

        protected void visitIndexRecord(Key key, int foundAt, int tail, int kLength, long pointer) throws PersistitException {
        }

        protected void visitDataRecord(Key key, int foundAt, int tail, int klength, int offset, int length, byte[] bytes) throws PersistitException {
        }
    }
}

