/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AccumulatorState;
import com.persistit.Exchange;
import com.persistit.Transaction;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Accumulator {
    static final Comparator<Accumulator> SORT_COMPARATOR = new Comparator<Accumulator>(){

        @Override
        public int compare(Accumulator a, Accumulator b) {
            String treeNameB;
            String treeNameA = a.getTree() == null ? "" : a.getTree().getName();
            int compare = treeNameA.compareTo(treeNameB = b.getTree() == null ? "" : b.getTree().getName());
            if (compare != 0) {
                return compare;
            }
            return a.getIndex() - b.getIndex();
        }
    };
    static final int MAX_INDEX = 63;
    static final int MAX_SERIALIZED_SIZE = 536;
    private final Tree _tree;
    private final int _index;
    private final TransactionIndex _transactionIndex;
    private final AtomicLong _liveValue = new AtomicLong();
    private volatile long _baseValue;
    private volatile long _checkpointValue;
    private volatile long _checkpointTimestamp;
    private long _checkpointTemp;
    private final long[] _bucketValues;
    final AccumulatorRef _accumulatorRef;

    private Accumulator(Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
        if (index < 0 || index > 63) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
        this._tree = tree;
        this._index = index;
        this._baseValue = baseValue;
        this._checkpointValue = baseValue;
        this._liveValue.set(baseValue);
        this._transactionIndex = transactionIndex;
        this._bucketValues = new long[transactionIndex.getHashTableSize()];
        this._accumulatorRef = new AccumulatorRef(this);
    }

    abstract long applyValue(long var1, long var3);

    abstract long updateValue(long var1, long var3);

    abstract long selectValue(long var1, long var3);

    abstract Type getType();

    void aggregate(int hashIndex, Delta delta) {
        this._bucketValues[hashIndex] = this.applyValue(this._bucketValues[hashIndex], delta.getValue());
    }

    AccumulatorRef getAccumulatorRef() {
        return this._accumulatorRef;
    }

    void checkpointNeeded(long timestamp) {
        this._accumulatorRef.checkpointNeeded(this, timestamp);
    }

    long getBucketValue(int hashIndex) {
        return this._bucketValues[hashIndex];
    }

    void setCheckpointValueAndTimestamp(long value, long timestamp) {
        this._checkpointValue = value;
        this._checkpointTimestamp = timestamp;
    }

    long getCheckpointValue() {
        return this._checkpointValue;
    }

    long getCheckpointTimestamp() {
        return this._checkpointTimestamp;
    }

    void setCheckpointTemp(long value) {
        this._checkpointTemp = value;
    }

    long getCheckpointTemp() {
        return this._checkpointTemp;
    }

    static Accumulator accumulator(Type type, Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
        switch (type) {
            case SUM: {
                return new SumAccumulator(tree, index, baseValue, transactionIndex);
            }
            case MAX: {
                return new MaxAccumulator(tree, index, baseValue, transactionIndex);
            }
            case MIN: {
                return new MinAccumulator(tree, index, baseValue, transactionIndex);
            }
            case SEQ: {
                return new SeqAccumulator(tree, index, baseValue, transactionIndex);
            }
        }
        throw new IllegalArgumentException("No such type " + (Object)((Object)type));
    }

    long getBaseValue() {
        return this._baseValue;
    }

    public long getLiveValue() {
        return this._liveValue.get();
    }

    public long getSnapshotValue(Transaction txn) throws PersistitInterruptedException {
        txn.checkActive();
        return this.getSnapshotValue(txn.getStartTimestamp(), txn.getStep());
    }

    long getSnapshotValue(long timestamp, int step) throws PersistitInterruptedException {
        try {
            return this._transactionIndex.getAccumulatorSnapshot(this, timestamp, step, this._baseValue);
        }
        catch (InterruptedException ie) {
            throw new PersistitInterruptedException(ie);
        }
    }

    void updateBaseValue(long value, long commitTimestamp) {
        this._baseValue = this.applyValue(this._baseValue, value);
        this._liveValue.set(this._baseValue);
        this.checkpointNeeded(commitTimestamp);
    }

    public long update(long value, Transaction txn) {
        txn.checkActive();
        return this.update(value, txn.getTransactionStatus(), txn.getStep());
    }

    long update(long value, TransactionStatus status, int step) {
        long updated;
        long previous;
        if (status.getTc() != Long.MAX_VALUE) {
            throw new IllegalStateException("Transaction has already committed or aborted");
        }
        while (!this._liveValue.compareAndSet(previous = this._liveValue.get(), updated = this.updateValue(previous, value))) {
        }
        long selectedValue = this.selectValue(value, updated);
        this._transactionIndex.addOrCombineDelta(status, this, step, selectedValue);
        return updated;
    }

    Tree getTree() {
        return this._tree;
    }

    int getIndex() {
        return this._index;
    }

    public String toString() {
        return String.format("Accumulator(tree=%s index=%d type=%s base=%,d live=%,d)", new Object[]{this._tree == null ? "null" : this._tree.getName(), this._index, this.getType(), this._baseValue, this._liveValue.get()});
    }

    void store(Value value) {
        value.put(this._tree == null ? "" : this._tree.getName());
        value.put(this._index);
        value.put(this.getType().toString());
        value.put(this.getCheckpointValue());
    }

    static AccumulatorState getAccumulatorState(Tree tree, int index) throws PersistitException {
        Exchange exchange = tree.getVolume().getStructure().directoryExchange();
        exchange.clear().append("_directory").append("totals").append(tree.getName()).append(index).fetch();
        if (exchange.getValue().isDefined()) {
            return (AccumulatorState)exchange.getValue().get();
        }
        return null;
    }

    static void saveAccumulatorCheckpointValues(List<Accumulator> list) throws PersistitException {
        Exchange exchange = null;
        for (Accumulator accumulator : list) {
            Volume volume = accumulator.getTree().getVolume();
            if (exchange == null || !exchange.getVolume().equals(volume)) {
                exchange = volume.getStructure().accumulatorExchange();
            }
            exchange.clear().append("_directory").append("totals").append(accumulator.getTree().getName()).append(accumulator.getIndex());
            exchange.getValue().put(accumulator);
            exchange.store();
        }
    }

    static final class AccumulatorRef {
        final WeakReference<Accumulator> _weakRef;
        final AtomicLong _latestUpdate = new AtomicLong();
        volatile Accumulator _checkpointRef;

        AccumulatorRef(Accumulator acc) {
            this._weakRef = new WeakReference<Accumulator>(acc);
        }

        Accumulator takeCheckpointRef(long timestamp) {
            Accumulator result = this._checkpointRef;
            if (timestamp > this._latestUpdate.get()) {
                this._checkpointRef = null;
                if (timestamp <= this._latestUpdate.get()) {
                    this._checkpointRef = result;
                }
            }
            return result;
        }

        void checkpointNeeded(Accumulator acc, long timestamp) {
            long latest;
            do {
                if ((latest = this._latestUpdate.get()) <= timestamp) continue;
                return;
            } while (!this._latestUpdate.compareAndSet(latest, timestamp));
            this._checkpointRef = acc;
        }

        boolean isLive() {
            return this._weakRef.get() != null || this._checkpointRef != null;
        }
    }

    static final class Delta {
        Accumulator _accumulator;
        int _step;
        long _value;
        Delta _next;

        Delta() {
        }

        Accumulator getAccumulator() {
            return this._accumulator;
        }

        int getStep() {
            return this._step;
        }

        long getValue() {
            return this._value;
        }

        void setAccumulator(Accumulator accumulator) {
            this._accumulator = accumulator;
        }

        void setValue(long newValue) {
            this._value = newValue;
        }

        void setStep(int step) {
            this._step = step;
        }

        Delta getNext() {
            return this._next;
        }

        void setNext(Delta delta) {
            this._next = delta;
        }

        void merge(long value) {
            this._value = this._accumulator.applyValue(this._value, value);
        }

        boolean canMerge(Accumulator accumulator, int step) {
            return this._accumulator == accumulator && this._step == step;
        }

        public String toString() {
            return String.format("Delta(type=%s value=%,d%s)", this._accumulator == null ? "Null" : this._accumulator.getType().toString(), this._value, this._next == null ? "" : "*");
        }
    }

    static final class SeqAccumulator
    extends Accumulator {
        private SeqAccumulator(Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
            super(tree, index, baseValue, transactionIndex);
        }

        @Override
        long applyValue(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        long updateValue(long a, long b) {
            if (b > 0L) {
                return a + b;
            }
            throw new IllegalArgumentException("Update value must be positive");
        }

        @Override
        long selectValue(long value, long updated) {
            return updated;
        }

        @Override
        Type getType() {
            return Type.SEQ;
        }
    }

    static final class MaxAccumulator
    extends Accumulator {
        private MaxAccumulator(Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
            super(tree, index, baseValue, transactionIndex);
        }

        @Override
        long applyValue(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        long updateValue(long a, long b) {
            return this.applyValue(a, b);
        }

        @Override
        long selectValue(long value, long updated) {
            return value;
        }

        @Override
        Type getType() {
            return Type.MAX;
        }
    }

    static final class MinAccumulator
    extends Accumulator {
        private MinAccumulator(Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
            super(tree, index, baseValue, transactionIndex);
        }

        @Override
        long applyValue(long a, long b) {
            return Math.min(a, b);
        }

        @Override
        long updateValue(long a, long b) {
            return this.applyValue(a, b);
        }

        @Override
        long selectValue(long value, long updated) {
            return value;
        }

        @Override
        Type getType() {
            return Type.MIN;
        }
    }

    static final class SumAccumulator
    extends Accumulator {
        private SumAccumulator(Tree tree, int index, long baseValue, TransactionIndex transactionIndex) {
            super(tree, index, baseValue, transactionIndex);
        }

        @Override
        long applyValue(long a, long b) {
            return a + b;
        }

        @Override
        long updateValue(long a, long b) {
            return this.applyValue(a, b);
        }

        @Override
        long selectValue(long value, long updated) {
            return value;
        }

        @Override
        Type getType() {
            return Type.SUM;
        }
    }

    public static enum Type {
        SUM,
        MAX,
        MIN,
        SEQ;

    }
}

