/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.resolver;

import com.googlecode.ehcache.annotations.CacheNotFoundException;
import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.SelfPopulatingCacheScope;
import com.googlecode.ehcache.annotations.TriggersRemove;
import com.googlecode.ehcache.annotations.resolver.CacheResolverFactory;
import com.googlecode.ehcache.annotations.resolver.CacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.SingletonCacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.SingletonTriggersRemoveCacheResolver;
import com.googlecode.ehcache.annotations.resolver.TriggersRemoveCacheResolver;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.util.ProductInfo;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultCacheResolverFactory
implements CacheResolverFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean badSelfPopulatingCache;
    private final ConcurrentMap<String, SelfPopulatingCacheTracker> selfPopulatingCaches = new ConcurrentHashMap<String, SelfPopulatingCacheTracker>();
    private final CacheManager cacheManager;
    private boolean createCaches = false;
    private SelfPopulatingCacheScope selfPopulatingCacheScope = SelfPopulatingCacheScope.SHARED;

    public DefaultCacheResolverFactory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        ProductInfo productInfo = new ProductInfo();
        String version = productInfo.getVersion();
        this.badSelfPopulatingCache = version.equals("2.3.0") || version.equals("2.3.1");
    }

    public boolean isCreateCaches() {
        return this.createCaches;
    }

    public void setCreateCaches(boolean createCaches) {
        this.createCaches = createCaches;
    }

    public void setSelfPopulatingCacheScope(SelfPopulatingCacheScope selfPopulatingCacheScope) {
        this.selfPopulatingCacheScope = selfPopulatingCacheScope;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CacheableCacheResolver getCacheResolver(Cacheable cacheable, Method method) {
        String exceptionCacheName;
        String cacheName = cacheable.cacheName();
        Ehcache cache = this.getCache(cacheName);
        ThreadLocal<MethodInvocation> entryFactory = null;
        if (cacheable.selfPopulating()) {
            if (this.badSelfPopulatingCache) {
                this.logger.error("SelfPopulatingCache in Ehcache 2.3.0 & 2.3.1 has a bug which can result in unexpected behavior, see EHC-828. {} may not behave as expected", (Object)cacheName);
            }
            SelfPopulatingCacheTracker selfPopulatingCacheTracker = this.createSelfPopulatingCacheInternal(cache);
            cache = selfPopulatingCacheTracker.selfPopulatingCache;
            entryFactory = selfPopulatingCacheTracker.cacheEntryFactory;
        }
        if (StringUtils.hasLength((String)(exceptionCacheName = cacheable.exceptionCacheName()))) {
            Ehcache exceptionCache = this.getCache(exceptionCacheName);
            return new SingletonCacheableCacheResolver(cache, entryFactory, exceptionCache);
        }
        return new SingletonCacheableCacheResolver(cache, entryFactory);
    }

    public TriggersRemoveCacheResolver getCacheResolver(TriggersRemove triggersRemove, Method method) {
        String[] cacheNames = triggersRemove.cacheName();
        LinkedHashSet<Ehcache> caches = new LinkedHashSet<Ehcache>(cacheNames.length);
        for (String cacheName : cacheNames) {
            Ehcache cache = this.getCache(cacheName);
            caches.add(cache);
        }
        return new SingletonTriggersRemoveCacheResolver(caches);
    }

    protected Ehcache getCache(String cacheName) {
        CacheManager cacheManager = this.getCacheManager();
        Ehcache cache = cacheManager.getEhcache(cacheName);
        if (cache == null) {
            if (this.createCaches) {
                this.logger.warn("No cache named '{}' exists, it will be created from the defaultCache", (Object)cacheName);
                try {
                    cacheManager.addCache(cacheName);
                }
                catch (ObjectExistsException oee) {
                    this.logger.trace("Race condition creating missing cache '{}', ignoring and retrieving existing cache", (Object)cacheName);
                }
                cache = cacheManager.getEhcache(cacheName);
            } else {
                throw new CacheNotFoundException(cacheName);
            }
        }
        return cache;
    }

    protected final SelfPopulatingCacheTracker createSelfPopulatingCacheInternal(Ehcache cache) {
        SelfPopulatingCacheTracker existing;
        if (SelfPopulatingCacheScope.METHOD == this.selfPopulatingCacheScope) {
            return this.createSelfPopulatingCache(cache);
        }
        String cacheName = cache.getName();
        SelfPopulatingCacheTracker selfPopulatingCacheTracker = (SelfPopulatingCacheTracker)this.selfPopulatingCaches.get(cacheName);
        if (selfPopulatingCacheTracker == null && (existing = this.selfPopulatingCaches.putIfAbsent(cacheName, selfPopulatingCacheTracker = this.createSelfPopulatingCache(cache))) != null) {
            selfPopulatingCacheTracker = existing;
        }
        return selfPopulatingCacheTracker;
    }

    protected SelfPopulatingCacheTracker createSelfPopulatingCache(Ehcache cache) {
        ThreadLocalCacheEntryFactory cacheEntryFactory = new ThreadLocalCacheEntryFactory();
        SelfPopulatingCache selfPopulatingCache = new SelfPopulatingCache(cache, (CacheEntryFactory)cacheEntryFactory);
        return new SelfPopulatingCacheTracker(selfPopulatingCache, cacheEntryFactory.entryFactory);
    }

    protected static class ThreadLocalCacheEntryFactory
    implements CacheEntryFactory {
        public final ThreadLocal<MethodInvocation> entryFactory = new ThreadLocal();

        protected ThreadLocalCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            MethodInvocation methodInvocation = this.entryFactory.get();
            if (methodInvocation == null) {
                throw new RuntimeException("No MethodInvocation specified in the ThreadLocal");
            }
            try {
                return methodInvocation.proceed();
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Exception(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelfPopulatingCacheTracker {
        public final SelfPopulatingCache selfPopulatingCache;
        public final ThreadLocal<MethodInvocation> cacheEntryFactory;

        public SelfPopulatingCacheTracker(SelfPopulatingCache selfPopulatingCache, ThreadLocal<MethodInvocation> cacheEntryFactory) {
            this.selfPopulatingCache = selfPopulatingCache;
            this.cacheEntryFactory = cacheEntryFactory;
        }
    }
}

