/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReflectionHelper;
import com.googlecode.ehcache.annotations.key.ReflectionHelperAware;
import com.googlecode.ehcache.annotations.key.SimpleReflectionHelper;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeepCacheKeyGenerator<G, T extends Serializable>
extends AbstractCacheKeyGenerator<T>
implements ReflectionHelperAware {
    private ReflectionHelper reflectionHelper = new SimpleReflectionHelper();
    private boolean useReflection = false;

    public AbstractDeepCacheKeyGenerator() {
    }

    public AbstractDeepCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        super(includeMethod, includeParameterTypes);
    }

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    @Override
    public void setReflectionHelper(ReflectionHelper reflectionHelper) {
        Assert.notNull((Object)reflectionHelper);
        this.reflectionHelper = reflectionHelper;
    }

    public final boolean isUseReflection() {
        return this.useReflection;
    }

    public final void setUseReflection(boolean useReflection) {
        this.useReflection = useReflection;
    }

    @Override
    public final T generateKey(Object ... data) {
        G generator = this.getGenerator(data);
        this.deepHashCode(generator, data);
        return this.generateKey(generator);
    }

    protected void deepHashCode(G generator, Object[] a) {
        this.beginRecursion(generator, a);
        for (Object element : a) {
            this.deepHashCode(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void deepHashCode(G generator, Iterable<?> a) {
        this.beginRecursion(generator, a);
        for (Object element : a) {
            this.deepHashCode(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void deepHashCode(G generator, Map.Entry<?, ?> e) {
        this.beginRecursion(generator, e);
        this.deepHashCode(generator, e.getKey());
        this.deepHashCode(generator, e.getValue());
        this.endRecursion(generator, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deepHashCode(G generator, Object element) {
        if (element == null) {
            this.appendNull(generator);
            return;
        }
        if (!this.register(element)) {
            this.appendGraphCycle(generator, element);
            return;
        }
        try {
            if (element instanceof byte[]) {
                this.append(generator, (byte[])element);
            } else if (element instanceof short[]) {
                this.append(generator, (short[])element);
            } else if (element instanceof int[]) {
                this.append(generator, (int[])element);
            } else if (element instanceof long[]) {
                this.append(generator, (long[])element);
            } else if (element instanceof char[]) {
                this.append(generator, (char[])element);
            } else if (element instanceof float[]) {
                this.append(generator, (float[])element);
            } else if (element instanceof double[]) {
                this.append(generator, (double[])element);
            } else if (element instanceof boolean[]) {
                this.append(generator, (boolean[])element);
            } else if (element instanceof Object[]) {
                this.deepHashCode(generator, (Object[])element);
            } else if (element instanceof Iterable) {
                this.deepHashCode(generator, (Iterable)element);
            } else if (element instanceof Map) {
                this.deepHashCode(generator, ((Map)element).entrySet());
            } else if (element instanceof Map.Entry) {
                this.deepHashCode(generator, (Map.Entry)element);
            } else if (this.useReflection) {
                this.reflectionDeepHashCode(generator, element);
            } else {
                this.append(generator, element);
            }
        }
        finally {
            this.unregister(element);
        }
    }

    protected final void reflectionDeepHashCode(G generator, Object element) {
        if (element instanceof Class) {
            this.append(generator, element);
            return;
        }
        if (!this.shouldReflect(element)) {
            this.append(generator, element);
            return;
        }
        LinkedList<Object> reflectiveObject = new LinkedList<Object>();
        reflectiveObject.add(element.getClass());
        try {
            for (Class<?> targetClass = element.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
                AccessibleObject[] fields = targetClass.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                for (int i = 0; i < fields.length; ++i) {
                    AccessibleObject field = fields[i];
                    int modifiers = ((Field)field).getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    Object fieldValue = ((Field)field).get(element);
                    reflectiveObject.add(fieldValue);
                }
            }
        }
        catch (IllegalAccessException exception) {
            ReflectionUtils.handleReflectionException((Exception)exception);
        }
        this.deepHashCode(generator, reflectiveObject);
    }

    protected boolean shouldReflect(Object element) {
        return !this.reflectionHelper.implementsHashCode(element) || !this.reflectionHelper.implementsEquals(element);
    }

    protected abstract G getGenerator(Object ... var1);

    protected abstract T generateKey(G var1);

    protected abstract void append(G var1, Object var2);

    protected abstract void appendGraphCycle(G var1, Object var2);

    protected abstract void appendNull(G var1);

    protected void append(G generator, boolean[] a) {
        this.beginRecursion(generator, a);
        for (boolean element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, byte[] a) {
        this.beginRecursion(generator, a);
        for (byte element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, char[] a) {
        this.beginRecursion(generator, a);
        for (char element : a) {
            this.append(generator, Character.valueOf(element));
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, double[] a) {
        this.beginRecursion(generator, a);
        for (double element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, float[] a) {
        this.beginRecursion(generator, a);
        for (float element : a) {
            this.append(generator, Float.valueOf(element));
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, int[] a) {
        this.beginRecursion(generator, a);
        for (int element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, long[] a) {
        this.beginRecursion(generator, a);
        for (long element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void append(G generator, short[] a) {
        this.beginRecursion(generator, a);
        for (short element : a) {
            this.append(generator, element);
        }
        this.endRecursion(generator, a);
    }

    protected void beginRecursion(G generator, Object e) {
    }

    protected void endRecursion(G generator, Object e) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + "includeMethod=" + this.isIncludeMethod() + ", " + "includeParameterTypes=" + this.isIncludeParameterTypes() + ", " + "useReflection=" + this.isUseReflection() + ", " + "checkforCycles=" + this.isCheckforCycles() + "]";
    }
}

