/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class OneShotLatch {
    private final Sync sync = new Sync();

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public void release() {
        this.sync.release(0);
    }

    public void await() {
        this.sync.acquireShared(0);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(0, unit.toNanos(timeout));
    }

    public String toString() {
        return "OneShotLatch[sync=" + this.sync + ']';
    }

    static class Sync
    extends AbstractQueuedSynchronizer {
        private static final int STATE_UNAVAILABLE = -1;
        private static final int STATE_RELEASED = 1;

        Sync() {
            this.setState(-1);
            this.setExclusiveOwnerThread(Thread.currentThread());
        }

        boolean isHeldByCurrentThread() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (!this.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException(this.toString());
            }
            this.setExclusiveOwnerThread(null);
            this.setState(1);
            return true;
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            int state = this.getState();
            if (state == -1 && this.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException(this.toString());
            }
            return state;
        }

        @Override
        public String toString() {
            return "Sync[state=" + this.getState() + "; owner=" + this.getExclusiveOwnerThread() + ']';
        }
    }
}

