/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork.results;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RssResult
extends WebWorkResultSupport {
    private static final Logger log = Logger.getLogger(RssResult.class);
    private static final String DEFAULT_DEFAULT_ENCODING = "UTF-8";
    public static final String RSS = "rss";
    public static final String RSS1 = "rss1";
    public static final String RSS2 = "rss2";
    public static final String ATOM = "atom";

    protected void doExecute(String finalDestination, ActionInvocation actionInvocation) throws Exception {
        block7: {
            ServletActionContext.getRequest().getSession(false);
            HttpServletResponse response = ServletActionContext.getResponse();
            if (finalDestination.startsWith(RSS)) {
                response.setContentType("application/rss+xml; charset=UTF-8");
            } else if (finalDestination.startsWith(ATOM)) {
                response.setContentType("application/atom+xml; charset=UTF-8");
            } else {
                response.setContentType("text/xml; charset=UTF-8");
            }
            SyndFeed feed = (SyndFeed)actionInvocation.getStack().findValue("syndFeed");
            if (feed == null) {
                throw new ServletException("Unable to find feed for this action");
            }
            WireFeed outFeed = feed.createWireFeed(finalDestination);
            outFeed.setEncoding(DEFAULT_DEFAULT_ENCODING);
            new WireFeedOutput().output(outFeed, (Writer)response.getWriter());
            try {
                response.flushBuffer();
            }
            catch (IOException e) {
                log.info((Object)"Client aborted (closed the connection) before the rss feed could be returned.");
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Error sending rss result to client", (Throwable)e);
            }
        }
    }
}

