/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork.interceptors;

import com.atlassian.xwork.interceptors.TransactionalInvocation;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public abstract class XWorkTransactionInterceptor
implements Interceptor {
    public abstract PlatformTransactionManager getTransactionManager();

    protected abstract boolean shouldIntercept(ActionInvocation var1);

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.shouldIntercept(invocation)) {
            return new TransactionalInvocation(this.getTransactionManager()).invokeInTransaction(invocation);
        }
        return invocation.invoke();
    }

    public static TransactionStatus currentTransactionStatus() throws RuntimeException {
        TransactionStatus status = (TransactionStatus)TransactionalInvocation.currentTransactionThreadLocal.get();
        if (status == null) {
            throw new RuntimeException("No transaction status in scope");
        }
        return status;
    }
}

