/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.appender.fluentd;

import com.atlassian.logging.log4j.appender.fluentd.FluentdRetryableException;
import com.atlassian.logging.log4j.appender.fluentd.FluentdSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.helpers.LogLog;

public class FluentdHttpSender
implements FluentdSender {
    private static final int EXPECTED_RESPONSE_CODE = 200;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 1;
    private final String fluentdEndpoint;
    private final CloseableHttpClient httpClient = HttpClients.custom().setMaxConnPerRoute(1).build();

    public FluentdHttpSender(String fluentdEndpoint) {
        this.fluentdEndpoint = this.resolveHostName(fluentdEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String payload) throws FluentdRetryableException {
        HttpPost httpPost = new HttpPost(this.fluentdEndpoint);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("json", (ContentBody)new StringBody(payload, ContentType.APPLICATION_JSON)).build();
        httpPost.setEntity(reqEntity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new FluentdRetryableException("Bad status code return from fluentD: " + response.getStatusLine());
            }
        }
        catch (IOException e) {
            throw new FluentdRetryableException(e);
        }
    }

    private String resolveHostName(String endpoint) {
        try {
            String hostName = new URL(endpoint).getHost();
            InetAddress[] arr$ = InetAddress.getAllByName(hostName);
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                InetAddress address = arr$[i$];
                return endpoint.replace(hostName, address.getHostAddress());
            }
        }
        catch (MalformedURLException | UnknownHostException exc) {
            LogLog.error((String)"Cannot resolve hostname of the endpoint", (Throwable)exc);
        }
        return endpoint;
    }
}

