/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.spi.LoggingEvent;

public class LogMessageUtil {
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char VERTICAL_TAB = '\u000b';
    public static final char FORM_FEED = '\f';
    public static final char NEXT_LINE = '\u0085';
    public static final char LINE_SEPARATOR = '\u2028';
    public static final char PARAGRAPH_SEPARATOR = '\u2029';

    private LogMessageUtil() {
    }

    public static String appendLineIndent(String messageText, String lineIndent) {
        int i;
        if (StringUtils.isEmpty((String)messageText)) {
            return messageText;
        }
        char[] chars = messageText.toCharArray();
        int lastPos = 0;
        StringBuilder builder = null;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r' && chars[i] != '\n' && chars[i] != '\u000b' && chars[i] != '\f' && chars[i] != '\u0085' && chars[i] != '\u2028' && chars[i] != '\u2029') continue;
            if (builder == null) {
                builder = new StringBuilder(messageText.length());
            }
            if (i + 1 < chars.length && chars[i] == '\r' && chars[i + 1] == '\n') {
                ++i;
            }
            builder.append(chars, lastPos, i + 1 - lastPos).append(lineIndent);
            lastPos = i + 1;
        }
        if (builder == null) {
            return messageText;
        }
        if (lastPos < chars.length) {
            builder.append(chars, lastPos, i - lastPos);
        }
        return builder.toString();
    }

    public static int getSize(LoggingEvent event) {
        int result;
        Preconditions.checkNotNull((Object)event);
        int n = result = event.getMessage() != null ? event.getMessage().toString().length() : 0;
        if (event.getThrowableInformation() != null) {
            for (String str : event.getThrowableInformation().getThrowableStrRep()) {
                result += str.length();
            }
        }
        return result;
    }
}

