/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.atlassian.logging.log4j.CategoryCollapsingPatternParser;
import com.atlassian.logging.log4j.NewLineSupport;
import com.atlassian.logging.log4j.StackTraceCompressor;
import com.atlassian.logging.log4j.StackTraceInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class FilteredPatternLayout
extends PatternLayout {
    private boolean filteringApplied = true;
    private boolean filteringAppliedToDebugLevel = false;
    private String filteredFrames;
    private String filterEveryThingAfterFrames;
    private String markerAtFrames;
    private String filterEveryThingAfterMessage = "\t\t(The rest of the stack trace has been filtered ...)";
    private String filterReplacementToken = "... ";
    private String markerAtMessage = NewLineSupport.NL;
    private int minimumLines = 6;
    private boolean showEludedSummary = false;
    private boolean stackTracePackagingExamined = true;
    private int categoryNameCollapsePrecision = -1;
    private StackTraceCompressor stackTraceCompressor;
    protected CategoryCollapsingPatternParser collapsingParser;

    public void setFilteredFrames(String filterSpec) {
        this.filteredFrames = filterSpec;
    }

    public void setFilterEveryThingAfterFrames(String filterSpec) {
        this.filterEveryThingAfterFrames = filterSpec;
    }

    public void setMarkerAtFrames(String filterSpec) {
        this.markerAtFrames = filterSpec;
    }

    public boolean isFilteringAppliedToDebugLevel() {
        return this.filteringAppliedToDebugLevel;
    }

    public void setFilteringAppliedToDebugLevel(boolean filteringAppliedToDebugLevel) {
        this.filteringAppliedToDebugLevel = filteringAppliedToDebugLevel;
    }

    public String getFilterReplacementToken() {
        return this.filterReplacementToken;
    }

    public void setFilterReplacementToken(String filterReplacementToken) {
        this.filterReplacementToken = StringUtils.defaultString((String)filterReplacementToken);
    }

    public String getFilterEveryThingAfterMessage() {
        return this.filterEveryThingAfterMessage;
    }

    public void setFilterEveryThingAfterMessage(String filterEveryThingAfterMessage) {
        this.filterEveryThingAfterMessage = StringUtils.defaultString((String)filterEveryThingAfterMessage);
    }

    public String getMarkerAtMessage() {
        return this.filterEveryThingAfterMessage;
    }

    public void setMarkerAtMessage(String markerAtMessage) {
        this.markerAtMessage = StringUtils.defaultString((String)markerAtMessage);
    }

    public boolean isFilteringApplied() {
        return this.filteringApplied;
    }

    public void setFilteringApplied(boolean filteringApplied) {
        this.filteringApplied = filteringApplied;
    }

    public int getMinimumLines() {
        return this.minimumLines;
    }

    public void setMinimumLines(int minimumLines) {
        this.minimumLines = minimumLines;
    }

    public boolean isShowEludedSummary() {
        return this.showEludedSummary;
    }

    public void setShowEludedSummary(boolean showEludedSummary) {
        this.showEludedSummary = showEludedSummary;
    }

    public boolean isStackTracePackagingExamined() {
        return this.stackTracePackagingExamined;
    }

    public void setStackTracePackagingExamined(boolean stackTracePackagingExamined) {
        this.stackTracePackagingExamined = stackTracePackagingExamined;
    }

    public int getCategoryNameCollapsePrecision() {
        return this.categoryNameCollapsePrecision;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    protected PatternParser createPatternParser(String pattern) {
        this.collapsingParser = new CategoryCollapsingPatternParser(pattern, this.categoryNameCollapsePrecision);
        return this.collapsingParser;
    }

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        String superFormatted = super.format(event);
        if (throwableInformation == null) {
            return superFormatted;
        }
        return this.formatStackTrace(event, throwableInformation, superFormatted);
    }

    private String formatStackTrace(LoggingEvent event, ThrowableInformation throwableInformation, String formattedByPattern) {
        StringBuffer buffer = new StringBuffer(formattedByPattern);
        String[] stackTraceLines = this.getThrowableStrRep(throwableInformation);
        if (!this.filteringApplied || Level.DEBUG.equals((Object)event.getLevel()) && !this.filteringAppliedToDebugLevel) {
            this.outputPlainThrowable(buffer, stackTraceLines);
        } else {
            this.stackTraceCompressor.filterStackTrace(buffer, stackTraceLines);
        }
        return buffer.toString();
    }

    protected String[] getThrowableStrRep(ThrowableInformation throwableInformation) {
        return new StackTraceInfo(throwableInformation.getThrowable(), "    ", this.isStackTracePackagingExamined()).getThrowableStrRep();
    }

    private void outputPlainThrowable(StringBuffer buffer, String[] stackTraceLines) {
        NewLineSupport.join(buffer, stackTraceLines);
    }

    public void activateOptions() {
        this.stackTraceCompressor = StackTraceCompressor.defaultBuilder(this.getMinimumLines(), this.isShowEludedSummary()).filteredFrames(this.filteredFrames).filteredEveryThingAfterFrames(this.filterEveryThingAfterFrames).filteredEveryThingAfterMessage(this.getFilterEveryThingAfterMessage()).markerAtFrames(this.markerAtFrames).markerAtMessage(this.getMarkerAtMessage()).replacementToken(this.getFilterReplacementToken()).build();
    }
}

