/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.lang.reflect.Method;
import org.apache.logging.log4j.status.StatusLogger;

public final class Throwables {
    private static final Method ADD_SUPPRESSED;
    private static final Method GET_SUPPRESSED;

    public static Throwable[] getSuppressed(Throwable throwable) {
        if (GET_SUPPRESSED != null) {
            try {
                return (Throwable[])GET_SUPPRESSED.invoke((Object)throwable, new Object[0]);
            }
            catch (Exception e) {
                StatusLogger.getLogger().error(e);
                return null;
            }
        }
        return null;
    }

    private Throwables() {
    }

    static {
        Method[] methods;
        Method getSuppressed = null;
        Method addSuppressed = null;
        for (Method method : methods = Throwable.class.getMethods()) {
            if (method.getName().equals("getSuppressed")) {
                getSuppressed = method;
                continue;
            }
            if (!method.getName().equals("addSuppressed")) continue;
            addSuppressed = method;
        }
        GET_SUPPRESSED = getSuppressed;
        ADD_SUPPRESSED = addSuppressed;
    }
}

