/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceDependencyResolver
implements ResourceDependencyResolver {
    public static final String IMPLICIT_CONTEXT_NAME = "_super".toString();
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceDependencyResolver.class);
    private final WebResourceIntegration webResourceIntegration;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final Cache cached = new Cache();

    public DefaultResourceDependencyResolver(WebResourceIntegration webResourceIntegration, ResourceBatchingConfiguration batchingConfiguration) {
        this.webResourceIntegration = webResourceIntegration;
        this.batchingConfiguration = batchingConfiguration;
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getSuperBatchDependencies(ConditionState conditionsRun) {
        SuperBatch superBatch = (SuperBatch)this.cached.lazy.get();
        conditionsRun.addAll(superBatch.conditionsRun);
        return this.cached.resourceMap().values();
    }

    private Iterable<String> getSuperBatchDependencyKeys() {
        return this.cached.resourceMap().keySet();
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependencies(String moduleKey, boolean excludeSuperBatchedResources, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        LinkedHashMap<String, WebResourceModuleDescriptor> orderedResources = new LinkedHashMap<String, WebResourceModuleDescriptor>();
        List<String> superBatchResources = excludeSuperBatchedResources ? this.getSuperBatchDependencyKeys() : Collections.emptyList();
        this.resolveDependencies(moduleKey, orderedResources, superBatchResources, new Stack<String>(), null, conditionsRun, conditionsCache);
        return orderedResources.values();
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        return this.getDependenciesInContext(context, new LinkedHashSet<String>(), conditionsRun, conditionsCache);
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, boolean excludeSuperBatchedResources, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        return this.getDependenciesInContext(context, excludeSuperBatchedResources, new LinkedHashSet<String>(), conditionsRun, conditionsCache);
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, Set<String> skippedResources, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        return this.getDependenciesInContext(context, true, skippedResources, conditionsRun, conditionsCache);
    }

    @Override
    public Iterable<WebResourceModuleDescriptor> getDependenciesInContext(String context, boolean excludeSuperBatchedResources, Set<String> skippedResources, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        LinkedHashSet<WebResourceModuleDescriptor> contextResources = new LinkedHashSet<WebResourceModuleDescriptor>();
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : this.modulesInContext(context, conditionsRun)) {
            LinkedHashMap<String, WebResourceModuleDescriptor> dependencies = new LinkedHashMap<String, WebResourceModuleDescriptor>();
            List<String> superBatchResources = excludeSuperBatchedResources ? this.getSuperBatchDependencyKeys() : Collections.emptyList();
            this.resolveDependencies(webResourceModuleDescriptor.getCompleteKey(), dependencies, superBatchResources, new Stack<String>(), skippedResources, conditionsRun, conditionsCache);
            for (WebResourceModuleDescriptor dependency : dependencies.values()) {
                contextResources.add(dependency);
            }
        }
        return Collections.unmodifiableCollection(contextResources);
    }

    private Iterable<? extends WebResourceModuleDescriptor> modulesInContext(final String context, ConditionState conditionsRun) {
        if (IMPLICIT_CONTEXT_NAME.equals(context)) {
            return this.getSuperBatchDependencies(conditionsRun);
        }
        Class<WebResourceModuleDescriptor> clazz = WebResourceModuleDescriptor.class;
        return Iterables.filter((Iterable)this.webResourceIntegration.getPluginAccessor().getEnabledModuleDescriptorsByClass(clazz), (Predicate)new Predicate<WebResourceModuleDescriptor>(){

            public boolean apply(@Nullable WebResourceModuleDescriptor descriptor) {
                return descriptor.getContexts().contains(context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies(String moduleKey, Map<String, WebResourceModuleDescriptor> orderedResourceKeys, Iterable<String> superBatchResources, Stack<String> stack, Set<String> skippedResources, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        boolean displayImmediate;
        DecoratingCondition condition;
        ModuleDescriptor moduleDescriptor;
        if (Iterables.contains(superBatchResources, (Object)moduleKey)) {
            log.debug("Not requiring resource: {} because it is part of a super-batch", (Object)moduleKey);
            return;
        }
        if (stack.contains(moduleKey)) {
            log.warn("Cyclic plugin resource dependency has been detected with: {} \nStack trace: {}", (Object)moduleKey, stack);
            return;
        }
        try {
            moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleKey);
        }
        catch (IllegalArgumentException e) {
            log.warn("Cannot find web resource module for: {}", (Object)moduleKey);
            return;
        }
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            if (Boolean.getBoolean("atlassian.dev.mode")) {
                if (this.webResourceIntegration.getPluginAccessor().getPluginModule(moduleKey) != null) {
                    log.warn("Cannot include disabled web resource module: {}", (Object)moduleKey);
                } else {
                    log.warn("Cannot find web resource module for: {}", (Object)moduleKey);
                }
            }
            return;
        }
        WebResourceModuleDescriptor webResourceModuleDescriptor = (WebResourceModuleDescriptor)moduleDescriptor;
        boolean skipDependencies = false;
        if (!webResourceModuleDescriptor.canEncodeStateIntoUrl()) {
            if (null != skippedResources) {
                skippedResources.add(moduleKey);
                return;
            }
            condition = webResourceModuleDescriptor.getCondition();
            displayImmediate = webResourceModuleDescriptor.shouldDisplayImmediate(conditionsCache);
            if (condition != null) {
                conditionsRun.addCondition(condition, displayImmediate);
            }
            if (!displayImmediate) {
                log.debug("Cannot include web resource module {} as its condition fails", (Object)moduleDescriptor.getCompleteKey());
                return;
            }
            conditionsRun.addWebResourceModuleDescriptor(webResourceModuleDescriptor);
        } else {
            condition = webResourceModuleDescriptor.getCondition();
            if (condition != null) {
                displayImmediate = webResourceModuleDescriptor.shouldDisplayImmediate(conditionsCache);
                conditionsRun.addCondition(condition, displayImmediate);
                conditionsRun.addWebResourceModuleDescriptor(webResourceModuleDescriptor);
                skipDependencies = !displayImmediate;
            }
        }
        List<String> dependencies = webResourceModuleDescriptor.getDependencies();
        log.debug("About to add resource [{}] and its dependencies: {}", (Object)moduleKey, dependencies);
        stack.push(moduleKey);
        try {
            if (!skipDependencies) {
                for (String dependency : dependencies) {
                    if (orderedResourceKeys.get(dependency) != null) continue;
                    this.resolveDependencies(dependency, orderedResourceKeys, superBatchResources, stack, skippedResources, conditionsRun, conditionsCache);
                }
            }
        }
        finally {
            stack.pop();
        }
        orderedResourceKeys.put(moduleKey, webResourceModuleDescriptor);
    }

    static final class SuperBatch {
        final String version;
        final Map<String, WebResourceModuleDescriptor> resources;
        final ConditionState conditionsRun;

        SuperBatch(String version, Map<String, WebResourceModuleDescriptor> resources, ConditionState conditionsRun) {
            this.conditionsRun = conditionsRun;
            this.version = (String)Preconditions.checkNotNull((Object)version);
            this.resources = (Map)Preconditions.checkNotNull(resources);
        }
    }

    final class Cache {
        ResettableLazyReference<SuperBatch> lazy = new ResettableLazyReference<SuperBatch>(){

            protected SuperBatch create() throws Exception {
                String version = DefaultResourceDependencyResolver.this.webResourceIntegration.getSuperBatchVersion();
                ConditionState conditionsRun = new ConditionState();
                ConditionsCache conditionsCache = new ConditionsCache();
                Map<String, WebResourceModuleDescriptor> resources = this.loadDescriptors(DefaultResourceDependencyResolver.this.batchingConfiguration.getSuperBatchModuleCompleteKeys(), conditionsRun, conditionsCache);
                return new SuperBatch(version, resources, conditionsRun);
            }

            Map<String, WebResourceModuleDescriptor> loadDescriptors(Iterable<String> moduleKeys, ConditionState conditionsRun, ConditionsCache conditionsCache) {
                if (Iterables.isEmpty(moduleKeys)) {
                    return Collections.emptyMap();
                }
                LinkedHashMap resources = new LinkedHashMap();
                for (String moduleKey : moduleKeys) {
                    DefaultResourceDependencyResolver.this.resolveDependencies(moduleKey, resources, Collections.emptyList(), new Stack(), null, conditionsRun, conditionsCache);
                }
                return Collections.unmodifiableMap(resources);
            }
        };

        Cache() {
        }

        Map<String, WebResourceModuleDescriptor> resourceMap() {
            if (!DefaultResourceDependencyResolver.this.batchingConfiguration.isSuperBatchingEnabled()) {
                log.debug("Super batching not enabled, but getSuperBatchDependencies() called. Returning empty.");
                return Collections.emptyMap();
            }
            while (true) {
                SuperBatch batch = (SuperBatch)this.lazy.get();
                if (batch.version.equals(DefaultResourceDependencyResolver.this.webResourceIntegration.getSuperBatchVersion())) {
                    return batch.resources;
                }
                this.lazy.reset();
            }
        }
    }
}

