/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.config.providers.XmlHelper;
import com.opensymphony.xwork.util.DomHelper;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ValidatorFileParser {
    private static final Log LOG = LogFactory.getLog((Class)ValidatorFileParser.class);
    static final String MULTI_TEXTVALUE_SEPARATOR = " ";
    static final Map VALIDATOR_CONFIG_DTD_MAPPINGS = new HashMap(){
        {
            this.put("-//OpenSymphony Group//XWork Validator 1.0//EN", "xwork-validator-1.0.dtd");
            this.put("-//OpenSymphony Group//XWork Validator 1.0.2//EN", "xwork-validator-1.0.2.dtd");
            this.put("-//OpenSymphony Group//XWork Validator 1.0.3//EN", "xwork-validator-1.0.3.dtd");
        }
    };
    static final Map VALIDATOR_DEFINITION_DTD_MAPPINGS = new HashMap(){
        {
            this.put("-//OpenSymphony Group//XWork Validator Definition 1.0//EN", "xwork-validator-definition-1.0.dtd");
        }
    };

    public static List parseActionValidatorConfigs(InputStream is, String resourceName) {
        ArrayList validatorCfgs = new ArrayList();
        Document doc = null;
        InputSource in = new InputSource(is);
        in.setSystemId(resourceName);
        doc = DomHelper.parse(in, VALIDATOR_CONFIG_DTD_MAPPINGS);
        if (doc != null) {
            NodeList fieldNodes = doc.getElementsByTagName("field");
            NodeList validatorNodes = doc.getElementsByTagName("validator");
            ValidatorFileParser.addValidatorConfigs(validatorNodes, new HashMap(), validatorCfgs);
            for (int i = 0; i < fieldNodes.getLength(); ++i) {
                Element fieldElement = (Element)fieldNodes.item(i);
                String fieldName = fieldElement.getAttribute("name");
                HashMap<String, String> extraParams = new HashMap<String, String>();
                extraParams.put("fieldName", fieldName);
                NodeList validatorNodes2 = fieldElement.getElementsByTagName("field-validator");
                ValidatorFileParser.addValidatorConfigs(validatorNodes2, extraParams, validatorCfgs);
            }
        }
        return validatorCfgs;
    }

    public static void parseValidatorDefinitions(InputStream is) {
        ValidatorFileParser.parseValidatorDefinitions(is, null);
    }

    public static void parseValidatorDefinitions(InputStream is, String resourceName) {
        InputSource in = new InputSource(is);
        in.setSystemId(resourceName);
        Document doc = DomHelper.parse(in, VALIDATOR_DEFINITION_DTD_MAPPINGS);
        NodeList nodes = doc.getElementsByTagName("validator");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element validatorElement = (Element)nodes.item(i);
            String name = validatorElement.getAttribute("name");
            String className = validatorElement.getAttribute("class");
            try {
                ObjectFactory.getObjectFactory().buildValidator(className, new HashMap(), null);
                ValidatorFactory.registerValidator(name, className);
                continue;
            }
            catch (Exception e) {
                throw new XworkException("Unable to load validator class " + className, e, validatorElement);
            }
        }
    }

    private static void addValidatorConfigs(NodeList validatorNodes, Map extraParams, List validatorCfgs) {
        for (int j = 0; j < validatorNodes.getLength(); ++j) {
            Element validatorElement = (Element)validatorNodes.item(j);
            String validatorType = validatorElement.getAttribute("type");
            HashMap params = new HashMap(extraParams);
            params.putAll(XmlHelper.getParams(validatorElement));
            ValidatorFactory.lookupRegisteredValidatorType(validatorType);
            ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
            vCfg.setLocation(DomHelper.getLocationObject(validatorElement));
            vCfg.setShortCircuit(Boolean.valueOf(validatorElement.getAttribute("short-circuit")));
            NodeList messageNodes = validatorElement.getElementsByTagName("message");
            Element messageElement = (Element)messageNodes.item(0);
            Node defaultMessageNode = messageElement.getFirstChild();
            String defaultMessage = defaultMessageNode == null ? "" : defaultMessageNode.getNodeValue();
            vCfg.setDefaultMessage(defaultMessage);
            Map messageParams = XmlHelper.getParams(messageElement);
            String key = messageElement.getAttribute("key");
            if (key != null && key.trim().length() > 0) {
                vCfg.setMessageKey(key);
                if (messageParams.containsKey("defaultMessage")) {
                    vCfg.setDefaultMessage((String)messageParams.get("defaultMessage"));
                }
                TreeMap sortedMessageParameters = new TreeMap();
                Iterator i = messageParams.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry messageParamEntry = i.next();
                    try {
                        int _order = Integer.parseInt((String)messageParamEntry.getKey());
                        sortedMessageParameters.put(new Integer(_order), messageParamEntry.getValue());
                    }
                    catch (NumberFormatException e) {}
                }
                vCfg.setMessageParams(sortedMessageParameters.values().toArray(new String[0]));
            } else if (messageParams != null && messageParams.size() > 0) {
                LOG.warn((Object)("validator of type [" + validatorType + "] have i18n message parameters defined but no i18n message key, it's parameters will be ignored"));
            }
            validatorCfgs.add(vCfg);
        }
    }
}

