package org.objectweb.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;

import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TMService;

/**
 * @author jmesnil
 *
 */
public class DataSourceFactory implements ObjectFactory {

    private static Hashtable table = new Hashtable();

    static {
        try {
            jotm = new Jotm(true, false);
        } catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public static TMService jotm;

    /**
    * @see javax.naming.spi.ObjectFactory#getObjectInstance(java.lang.Object, javax.naming.Name, javax.naming.Context, java.util.Hashtable)
    */
    public Object getObjectInstance(
        Object obj,
        Name n,
        Context nameCtx,
        Hashtable environment)
        throws Exception {
        StandardXAPoolDataSource xads = null;
        StandardXADataSource ds = null;
        try {

            Reference ref = (Reference) obj;
            ds = new StandardXADataSource();
            xads = new StandardXAPoolDataSource(ds);
            Enumeration addrs = ref.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr addr = (RefAddr) addrs.nextElement();
                String name = addr.getType();
                String value = (String) addr.getContent();
                if (name.equals("driverClassName")) {
                    ds.setDriverName(value);
                } else if (name.equals("url")) {
                    ds.setUrl(value);
                } else if (name.equals("username")) {
                    xads.user = value;
                    ds.setUser(value);
                } else if (name.equals("password")) {
                    ds.setPassword(value);
                    xads.password = value;
                } else if (name.equals("min")) {
                    try {
                        int min = Integer.parseInt(value);
                        xads.setMinSize(min);
                    } catch (NumberFormatException e) {
                        // we do nothing (default value will be used)
                    }
                } else if (name.equals("max")) {
                    try {
                        int max = Integer.parseInt(value);
                        xads.setMaxSize(max);
                    } catch (NumberFormatException e) {
                        // we do nothing (default value will be used)
                    }
                }
            }
            xads.setTransactionManager(jotm.getTransactionManager());
            xads.setDataSource(ds);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (table.containsKey(ds)) {
            return table.get(ds);
        } else {
            table.put(ds, xads);
            return xads;
        }
    }
}
