/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.rmi.Remote;
import java.util.ArrayList;
import org.objectweb.carol.cmi.SecureRandom;

public class StubListRandomChooser {
    private Object[] stubs;
    private Object[] chooser;
    private int first;
    private int returned;

    public StubListRandomChooser(ArrayList stublist) {
        this.stubs = stublist.toArray();
        this.chooser = null;
        this.returned = 0;
    }

    public void restart() {
        this.returned = 0;
    }

    public Remote next() {
        int len = this.stubs.length;
        switch (this.returned) {
            case 0: {
                this.first = SecureRandom.getInt(len);
                this.returned = 1;
                return (Remote)this.stubs[this.first];
            }
            case 1: {
                if (this.chooser == null) {
                    this.chooser = new Object[len];
                }
                int i = 0;
                while (i < len) {
                    this.chooser[i] = this.stubs[i];
                    ++i;
                }
                this.chooser[this.first] = this.stubs[0];
            }
        }
        if (this.returned >= len) {
            return null;
        }
        int c = this.returned + SecureRandom.getInt(len - this.returned);
        Object obj = this.chooser[c];
        this.chooser[c] = this.chooser[this.returned];
        ++this.returned;
        return (Remote)obj;
    }

    public Remote get() {
        this.returned = 0;
        return this.next();
    }
}

