/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.carol.cmi.ClusterConfig;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.ClusterObject;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.Config;
import org.objectweb.carol.cmi.Random;
import org.objectweb.carol.cmi.RoundRobin;
import org.objectweb.carol.cmi.SecureRandom;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.WeakList;

public class ClusterStubData {
    private ClusterConfig cfg;
    private long randomSeed;
    private boolean stubDebug = false;
    private Class clusterStubClass;
    private HashMap idMap;
    private HashMap stubMap;
    private volatile ClusterStub clusterStub;
    private WeakList lbList = new WeakList();
    private static Class[] cnstr_params = new Class[]{class$org$objectweb$carol$cmi$ClusterStubData == null ? (class$org$objectweb$carol$cmi$ClusterStubData = ClusterStubData.class$("org.objectweb.carol.cmi.ClusterStubData")) : class$org$objectweb$carol$cmi$ClusterStubData};
    static /* synthetic */ Class class$org$objectweb$carol$cmi$ClusterStubData;

    private ClusterStubData() {
    }

    public ClusterStubData(ClusterId serverId, Remote stub, int factor) throws RemoteException {
        StubData sd = new StubData(serverId, stub, factor);
        this.idMap = new HashMap();
        this.idMap.put(serverId, sd);
        this.stubMap = new HashMap();
        this.stubMap.put(stub, sd);
        this.randomSeed = SecureRandom.getLong();
        this.stubDebug = Config.isStubDebug();
        try {
            this.clusterStubClass = ClusterObject.getClusterStubClass(stub.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException("No valid cluster stub class for " + stub.getClass().getName());
        }
    }

    public ClusterStubData(Remote stub) throws RemoteException {
        StubData sd = new StubData(null, stub, 100);
        this.stubMap = new HashMap();
        this.stubMap.put(stub, sd);
        this.randomSeed = SecureRandom.getLong();
        this.stubDebug = Config.isStubDebug();
        try {
            this.clusterStubClass = ClusterObject.getClusterStubClass(stub.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException("No valid cluster stub class for " + stub.getClass().getName());
        }
    }

    private ClusterStub generateClusterStub(Class cl) throws RemoteException {
        try {
            Constructor cnstr = this.clusterStubClass.getConstructor(cnstr_params);
            return (ClusterStub)cnstr.newInstance(this);
        }
        catch (Exception e) {
            throw new RemoteException("Can not instanciate cluster stub" + e.toString());
        }
    }

    public ClusterStub getClusterStub() throws RemoteException {
        ClusterStub cs = this.clusterStub;
        if (cs == null) {
            this.clusterStub = cs = this.generateClusterStub(this.clusterStubClass);
        }
        return cs;
    }

    public boolean isValidRemote(Remote r) {
        try {
            return this.clusterStubClass.getName().equals(ClusterObject.getClusterStubClass(r.getClass()).getName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStub(ClusterId serverId, Remote stub, int factor) {
        StubData sd;
        if (this.idMap == null) {
            return false;
        }
        if (!this.isValidRemote(stub)) {
            return false;
        }
        try {
            sd = new StubData(serverId, stub, factor);
        }
        catch (RemoteException e) {
            return false;
        }
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            this.idMap.put(serverId, sd);
            this.stubMap.put(stub, sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStub(Remote stub) {
        StubData sd;
        if (this.idMap != null) {
            return false;
        }
        if (!this.isValidRemote(stub)) {
            return false;
        }
        try {
            sd = new StubData(null, stub, 100);
        }
        catch (RemoteException e) {
            return false;
        }
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            this.stubMap.put(stub, sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectOutput out) throws IOException {
        out.writeObject(this.cfg);
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            Iterator it = this.stubMap.entrySet().iterator();
            int l = this.stubMap.size();
            if (this.idMap == null) {
                out.writeInt(-l);
                int i = 0;
                while (i < l) {
                    Map.Entry e = it.next();
                    StubData sd = (StubData)e.getValue();
                    out.writeInt(sd.getFactor());
                    out.writeObject(sd.getStub());
                    ++i;
                }
            } else {
                out.writeInt(l);
                int i = 0;
                while (i < l) {
                    Map.Entry e = it.next();
                    StubData sd = (StubData)e.getValue();
                    sd.getId().write(out);
                    out.writeInt(sd.getFactor());
                    out.writeObject(sd.getStub());
                    ++i;
                }
            }
        }
        out.writeLong(this.randomSeed);
        out.writeBoolean(this.stubDebug);
    }

    public static ClusterStubData read(ObjectInput in, ClusterStub cs) throws IOException, ClassNotFoundException {
        ClusterStubData csd = new ClusterStubData();
        try {
            csd.cfg = (ClusterConfig)in.readObject();
            int l = in.readInt();
            if (l == 0) {
                throw new IOException("invalid serialized stub : 0 stubs");
            }
            HashMap<ClusterId, StubData> idm = null;
            HashMap<Remote, StubData> stubm = new HashMap<Remote, StubData>();
            if (l < 0) {
                l = -l;
                int i = 0;
                while (i < l) {
                    int f = in.readInt();
                    Remote r = (Remote)in.readObject();
                    StubData sd = new StubData(null, r, f);
                    stubm.put(r, sd);
                    ++i;
                }
            } else {
                idm = new HashMap<ClusterId, StubData>(l);
                int i = 0;
                while (i < l) {
                    ClusterId id = ClusterId.read(in);
                    int f = in.readInt();
                    Remote r = (Remote)in.readObject();
                    StubData sd = new StubData(id, r, f);
                    stubm.put(r, sd);
                    idm.put(id, sd);
                    ++i;
                }
            }
            csd.idMap = idm;
            csd.stubMap = stubm;
            csd.randomSeed = in.readLong() ^ System.currentTimeMillis();
            SecureRandom.setSeed(csd.randomSeed);
            csd.stubDebug = in.readBoolean();
        }
        catch (ClassCastException ce) {
            throw new IOException("invalid serialized stub" + ce.toString());
        }
        csd.clusterStub = cs;
        csd.clusterStubClass = cs.getClass();
        return csd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStub(ClusterId serverId) {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            StubData sd = (StubData)this.idMap.remove(serverId);
            if (sd == null) {
                return true;
            }
            if (this.idMap.size() == 0) {
                this.idMap.put(serverId, sd);
                return false;
            }
            this.stubMap.remove(sd.getStub());
            this.removeFromLB(sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStub(Remote stub) {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            StubData sd = (StubData)this.stubMap.remove(stub);
            if (sd == null) {
                return true;
            }
            if (this.stubMap.size() == 0) {
                this.stubMap.put(stub, sd);
                return false;
            }
            this.idMap.remove(sd.getId());
            this.removeFromLB(sd);
        }
        return true;
    }

    private void removeFromLB(StubData sd) {
        Iterator it = this.lbList.iterator();
        while (it.hasNext()) {
            StubLB lb = (StubLB)it.next();
            lb.remove(sd);
        }
    }

    public void setClusterConfig(ClusterConfig cfg) {
        this.cfg = cfg;
    }

    public ClusterConfig getClusterConfig() {
        return this.cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubLB getRoundRobin() {
        RoundRobin lb;
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            lb = new RoundRobin(this, this.stubMap.values());
        }
        this.lbList.put(lb);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubLB getRandom() {
        Random lb;
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            lb = new Random(this, this.stubMap.values());
        }
        this.lbList.put(lb);
        return lb;
    }

    public boolean isStubDebug() {
        return this.stubDebug;
    }

    public void debug(String mesg) {
        System.out.println("ClusterStub: " + mesg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

