<%@ page import="com.atlassian.jira.ComponentManager" %>
<%@ page import="com.atlassian.plugin.Plugin" %>
<%@ page import="com.atlassian.plugin.PluginAccessor" %>
<%@ page import="com.atlassian.plugin.osgi.container.OsgiContainerManager" %>
<%@ page import="org.osgi.framework.Bundle" %>
<%@ page import="org.osgi.framework.ServiceReference" %>
<%@ page import="java.util.Iterator" %>

<html>
<head>
    <title>Plugins</title>
</head>
    <h2>Plugins</h2>
    <ul>
<%
    PluginAccessor pluginAccessor = (PluginAccessor) ComponentManager.getComponentInstanceOfType(PluginAccessor.class);
    OsgiContainerManager osgiContainerManager = (OsgiContainerManager) ComponentManager.getComponentInstanceOfType(OsgiContainerManager.class);
%>
<%
    for(Iterator it = pluginAccessor.getPlugins().iterator(); it.hasNext(); )
        {
        Plugin p = (Plugin) it.next();
%>
        <li><%=p.getKey()%></li>
<% } %>
    </ul>

    <h2>Bundles</h2>
    <table border="1">
        <tr>
            <th>Name</th>
            <th>Version</th>
            <th>State</th>
            <th>Services</th>
        </tr>

<%  Bundle[] osgiBundles = osgiContainerManager.getBundles();
    for(int osgiBundleIndex = 0; osgiBundleIndex < osgiBundles.length; osgiBundleIndex++)
    {
        Bundle bundle = osgiBundles[osgiBundleIndex];
%>
        <tr>
            <td>
                <%=bundle.getSymbolicName()%>
            </td>
            <td>
                <%=bundle.getHeaders().get("Bundle-Version")%>
            </td>
            <td>
                <%
                    String state = "N/A";
                    switch (bundle.getState()) {
                        case Bundle.INSTALLED : state = "Installed"; break;
                        case Bundle.ACTIVE : state = "Active"; break;
                        case Bundle.RESOLVED : state = "Resolved"; break;
                    }
                %>
                <%=state%>
            </td>
            <td>
                &nbsp;
            <%  if (bundle.getRegisteredServices() != null && bundle.getRegisteredServices().length > 0) { %>
                <table border="1" width="100%">
             <tr>
                 <th>Interfaces</th>
                 <th>Properties</th>
                 <th>Using Bundles</th>
             </tr>

            <%  ServiceReference[] serviceReferences = bundle.getRegisteredServices();
                for(int serviceIndex = 0; serviceIndex < serviceReferences.length; serviceIndex++)
                    {
                    ServiceReference service = serviceReferences[serviceIndex];
            %>
                    <tr>
                        <td>
                            <% String[] infs = (String[]) service.getProperty("objectClass");
                                for (int infsIndex = 0; infsIndex < infs.length; infsIndex++)
                                {
                                    String inf = infs[infsIndex];
                            %>
                                    <li><%=inf%></li>
                            <% } %>

                        </td>
                        <td>
                            <ul>
                            <%  String[] propertyKeys = service.getPropertyKeys();
                                for(int propertyKeyIndex = 0; propertyKeyIndex < propertyKeys.length; propertyKeyIndex++)
                                {
                                    String key = propertyKeys[propertyKeyIndex];
                                    if (!"objectClass".equals(key)) { %>
                                        <li><%=key%> - <%=service.getProperty(key)%></li>
                            <% }} %>
                            </ul>
                        </td>
                        <td> &nbsp;
                            <ul>
                            <%  if (service.getUsingBundles() != null) {
                                    Bundle[] serviceBundles = service.getUsingBundles();
                                    for (int serviceBundleIndex = 0; serviceBundleIndex < serviceBundles.length; serviceBundleIndex++)
                                    {
                                        Bundle user = serviceBundles[serviceBundleIndex];
                            %>
                                        <li><%=user.getSymbolicName()%></li>
                            <%      }
                                }%>
                            </ul>
                        </td>
                    </tr>

                <%  } %>
                </table>
                <% } %>
            </td>
        </tr>

<% } %>
        </table>

</html>