<%@ page import="com.atlassian.jira.bc.JiraServiceContext" %>
<%@ page import="com.atlassian.jira.bc.JiraServiceContextImpl" %>
<%@ page import="com.atlassian.jira.util.system.ExtendedSystemInfoUtils" %>
<%@ page import="webwork.action.CoreActionContext" %>
<%@ page import="java.util.Set" %>
<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="webwork" prefix="iterator" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>

<html>
<head>
	<title><webwork:text name="'admin.supportrequest.support.request'"/></title>
</head>

<body>

<table width="100%" cellpadding="10" cellspacing="0" border="0">
    <tr>
        <td>
            <webwork:if test="/hasMailServer == true">
                <page:applyDecorator name="jiraform">
                    <page:param name="title"><webwork:text name="'admin.supportrequest.support.request'"/></page:param>
                    <page:param name="description"><webwork:text name="'admin.supportrequest.instructions'"/>
                        <p><webwork:text name="'admin.supportrequest.note'">
                            <webwork:param name="'value0'"><b></webwork:param>
                            <webwork:param name="'value1'"></b></webwork:param>
                        </webwork:text></p>
                        <webwork:if test="/mailSendingDisabled == true">
                            <p><webwork:text name="'admin.mailqueue.sending.mail.is.disabled'">
                                <webwork:param name="'value0'"><span class="warning"></webwork:param>
                                <webwork:param name="'value1'"></span></webwork:param>
                            </webwork:text></p>
                        </webwork:if>
                    </page:param>
                    <page:param name="action">JiraSupportRequest.jspa</page:param>
                    <page:param name="submitId">support_submit</page:param>
                    <page:param name="submitName"><webwork:text name="'admin.common.words.submit'"/></page:param>

                    <ui:textfield label="text('admin.supportrequest.to')" name="'to'" size="60" maxlength="255">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.email.description'"/></ui:param>
                        <ui:param name="'mandatory'" value="true" />
                    </ui:textfield>

                    <ui:textfield label="text('admin.supportrequest.cc')" name="'cc'" size="60" maxlength="255">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.email.description'"/></ui:param>
                    </ui:textfield>

                    <ui:textfield label="text('admin.supportrequest.subject')" name="'subject'" size="60" maxlength="255">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.subject.description'"/></ui:param>
                        <ui:param name="'mandatory'" value="true" />
                    </ui:textfield>

                    <ui:textarea label="text('common.words.description')" name="'description'" cols="'70'" rows="'20'" >
                        <ui:param name="'description'" value="''" />
                        <ui:param name="'mandatory'" value="true" />
                    </ui:textarea>

                    <ui:textfield label="text('admin.supportrequest.supportIssueKey')" name="'supportIssueKey'" size="60" maxlength="20">
                        <ui:param name="'description'">
                            <webwork:text name="'admin.supportrequest.supportIssueKey.description'">
                                <webwork:param name="'value0'"><br /></webwork:param>
                                <webwork:param name="'value1'"><u></webwork:param>
                                <webwork:param name="'value2'"></u></webwork:param>
                            </webwork:text>
                        </ui:param>
                    </ui:textfield>

                    <ui:checkbox label="text('admin.supportrequest.data.export')" name="'attachzipexport'" fieldValue="'true'">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.data.export.description'"/><br />
                            <webwork:text name="'admin.supportrequest.data.export.confidentiality'"/><br />
                            <webwork:text name="'admin.supportrequest.data.export.note'">
                                <webwork:param name="'value0'"><u></webwork:param>
                                <webwork:param name="'value1'"></u></webwork:param>
                            </webwork:text>
                        </ui:param>
                    </ui:checkbox>

                    <ui:checkbox label="text('admin.supportrequest.attach.jira.logs')" name="'attachlogs'" fieldValue="'true'">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.attach.jira.logs.description'"/><br />
                            <webwork:text name="'admin.systeminfo.location.of.atlassian.jira.log'"/>: <webwork:property value="logPath" /><br />
                        </ui:param>
                    </ui:checkbox>

                    <ui:textfield label="text('admin.supportrequest.contact.name')" name="'name'" size="60" maxlength="255">
                        <ui:param name="'mandatory'" value="true" />
                    </ui:textfield>

                    <ui:textfield label="text('admin.supportrequest.contact.email')" name="'email'" size="60" maxlength="255">
                        <ui:param name="'description'"><webwork:text name="'admin.supportrequest.email.description'" /></ui:param>
                        <ui:param name="'mandatory'" value="true" />
                    </ui:textfield>

                    <ui:textfield label="text('admin.supportrequest.contact.number')" name="'phone'" size="60" maxlength="255" />

                    <tr>
                        <td bgcolor="#fffff0" align="right" valign="top"><webwork:text name="'admin.supportrequest.environment'"/>:</td>
                        <td bgcolor="#ffffff">
                            <table id="support_req_env" class="borderedBox" bgcolor="#f0f0f0" width="100%" cellpadding="1">

                                <webwork:if test="/warningMessages/size() > 0">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:text name="'admin.systeminfo.environment.warnings'"/></b></td>
                                    <td>
                                        <webwork:iterator value="/warningMessages">
                                            <webwork:property value="."/><br/>
                                        </webwork:iterator>
                                    </td>
                                </tr>
                                </webwork:if>

                                <webwork:if test="/appliedPatches/size() > 0">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:text name="'admin.systeminfo.applied.patches'"/></b></td>
                                    <td>
                                        <webwork:iterator value="/appliedPatches">
                                            <webwork:property value="./issueKey"/> : <webwork:property value="./description"/><br/>
                                        </webwork:iterator>
                                    </td>
                                </tr>
                                </webwork:if>

                                <tr>
                                    <td nowrap width="1%"><b><webwork:text name="'admin.generalconfiguration.base.url'"/></b></td>
                                    <td ><webwork:property value="/extendedSystemInfoUtils/baseUrl"/></td>
                                </tr>

                                <webwork:iterator value="/extendedSystemInfoUtils/props(true)" status="'status'">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:property value="key" /></b></td>
                                    <td ><webwork:property value="value" /></td>
                                </tr>
                                </webwork:iterator>

                                <webwork:iterator value="/extendedSystemInfoUtils/licenseInfo" status="'status'">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:property value="key" /></b></td>
                                    <td ><webwork:property value="value" /></td>
                                </tr>
                                </webwork:iterator>

                                <webwork:iterator value="/extendedSystemInfoUtils/jvmStats" status="'status'">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:property value="key" /></b></td>
                                    <td ><webwork:property value="value" /></td>
                                </tr>
                                </webwork:iterator>

                                <webwork:iterator value="/extendedSystemInfoUtils/buildStats" status="'status'">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:property value="key" /></b></td>
                                    <td ><webwork:property value="value" /></td>
                                </tr>
                                </webwork:iterator>

                                <webwork:iterator value="/extendedSystemInfoUtils/commonConfigProperties" status="'status'">
                                <tr>
                                    <td nowrap width="1%"><b><webwork:property value="key" /></b></td>
                                    <td ><webwork:property value="value" /></td>
                                </tr>
                                </webwork:iterator>

                                <tr>
                                    <td valign="top"><b><webwork:text name="'admin.generalconfiguration.installed.languages'"/></b></td>
                                    <td valign="top">
                                    <webwork:iterator value="jiraLocaleUtils/installedLocales" status="'status'">
                                        <webwork:property value="./displayName"/><webwork:if test="@status/last == false"><br></webwork:if>
                                    </webwork:iterator>
                                    </td>
                                </tr>

                                <tr>
                                    <td valign="top"><b><webwork:text name="'admin.generalconfiguration.default.language'"/></b></td>
                                    <td valign="top"><webwork:property value="/extendedSystemInfoUtils/defaultLanguage" /><webwork:if test="/extendedSystemInfoUtils/usingSystemLocale == true"> - <webwork:text name="'admin.systeminfo.system.default.locale'"/></webwork:if></td>
                                </tr>

                                <webwork:if test="/extendedSystemInfoUtils/usageStats != null && /extendedSystemInfoUtils/usageStats/empty == false">
                                    <tr>
                                        <td valign="top" colspan="2"><b><webwork:text name="'admin.systeminfo.database.statistics'"/></b></td>
                                    </tr>
                                    <webwork:iterator value="/extendedSystemInfoUtils/usageStats" status="'status'">
                                    <tr>
                                        <td valign="top" width="40%"><webwork:property value="key" /></td>
                                        <td valign="top" width="60%"><webwork:property value="value" /></td>
                                    </tr>
                                    </webwork:iterator>
                                </webwork:if>

                                <tr>
                                    <td valign="top" colspan="2"><b><webwork:text name="'admin.systeminfo.system.properties'"/></b></td>
                                </tr>
                                <webwork:iterator value="systemPropertiesHTML" status="'status'">
                                <tr>
                                    <td valign="top" width="40%"><webwork:property value="key" /></td>
                                    <td valign="top" width="60%" class="small"><webwork:property value="value" escape="false"/></td>
                                </tr>
                                </webwork:iterator>

                                <tr>
                                    <td valign="top" colspan="2"><b><webwork:text name="'admin.systeminfo.trustedapps'"/></b><webwork:property value="trustedAppContext"/></td>
                                </tr>
                                <%
                                    JiraServiceContext jiraServiceContext = (JiraServiceContext) CoreActionContext.getValueStack().findValue("/jiraServiceContext");
                                    JiraServiceContext trustedAppContext = new JiraServiceContextImpl(jiraServiceContext.getUser());
                                    ExtendedSystemInfoUtils sysInfo = (ExtendedSystemInfoUtils) CoreActionContext.getValueStack().findValue("/extendedSystemInfoUtils");
                                    Set trustedApps = sysInfo.getTrustedApplications(trustedAppContext);
                                    if(trustedAppContext.getErrorCollection().hasAnyErrors()) {
                                %>
                                    <tr>
                                        <td width="40%" valign="top"></td>
                                        <td valign="top" width="60%" class="small">
                                            [<webwork:text name="'admin.errors.trustedapps.no.permission'"/>]
                                        </td>
                                    </tr>
                                <% } else if(trustedApps.isEmpty()) { %>
                                    <tr>
                                        <td width="40%" valign="top"></td>
                                        <td valign="top" width="60%" class="small">
                                            [<webwork:text name="'admin.trustedapps.no.apps.configured'"/>]
                                        </td>
                                    </tr>
                                <% } else { %>
                                    <webwork:iterator value="/extendedSystemInfoUtils/trustedApplications(/jiraServiceContext)" status="'status'">
                                    <tr>
                                        <td width="40%" valign="top"><webwork:property value="./name" /></td>
                                        <td width="60%" valign="top">
                                            <table cellpadding="0" cellspacing="0" border="0">
                                                <tr>
                                                    <td valign="top"><webwork:text name="'admin.trustedapps.field.application.id'"/>:</td>
                                                    <td valign="top" class="small"><webwork:property value="./ID" /></td>
                                                </tr>
                                                <tr>
                                                    <td valign="top"><webwork:text name="'admin.trustedapps.field.timeout'"/>:</td>
                                                    <td valign="top" class="small"><webwork:property value="./timeout" /></td>
                                                </tr>
                                                <tr>
                                                    <td valign="top"><webwork:text name="'admin.trustedapps.field.ip.matches'"/>:</td>
                                                    <td valign="top" class="small"><webwork:iterator value="/extendedSystemInfoUtils/IPMatches(.)">
                                                            <webwork:property value="." /><br/>
                                                        </webwork:iterator></td>
                                                </tr>
                                                <tr>
                                                    <td valign="top"><webwork:text name="'admin.trustedapps.field.url.matches'"/>:</td>
                                                    <td valign="top" class="small"><webwork:iterator value="/extendedSystemInfoUtils/urlMatches(.)">
                                                            <webwork:property value="." /><br/>
                                                        </webwork:iterator></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    </webwork:iterator>
                                <% } %>
                            </table>
                        </td>
                    </tr>
                </page:applyDecorator>
            </webwork:if>
            <webwork:else>
                <page:applyDecorator name="jiraform">
                    <page:param name="action">ViewProjects.jspa</page:param>
                    <page:param name="submitId">cancel_submit</page:param>
                    <page:param name="submitName"><webwork:text name="'common.forms.cancel'"/></page:param>
                    <page:param name="autoSelectFirst">false</page:param>
                    <page:param name="title"><webwork:text name="'admin.supportrequest.support.request'"/></page:param>
                    <page:param name="width">100%</page:param>
                    <page:param name="description">
                        <p><webwork:text name="'admin.supportrequest.page.description'"/></p>
                        <p>
                            <webwork:if test="/systemAdministrator == true">
                                <webwork:text name="'admin.supportrequest.note.configure.mail.server'">
                                    <webwork:param name="'value0'"><span class="note"></webwork:param>
                                    <webwork:param name="'value1'"></span></webwork:param>
                                    <webwork:param name="'value2'"><a id="configure_mail_server" href="ViewMailServers.jspa"></webwork:param>
                                    <webwork:param name="'value3'"></a></webwork:param>
                                </webwork:text>
                            </webwork:if>
                            <webwork:else>
                                <webwork:text name="'admin.supportrequest.note.configure.mail.server.admin'">
                                    <webwork:param name="'value0'"><span class="note"></webwork:param>
                                    <webwork:param name="'value1'"></span></webwork:param>
                                    <webwork:param name="'value2'"><a href="<%=request.getContextPath()%>/secure/Administrators.jspa#sysadmins"></webwork:param>
                                    <webwork:param name="'value3'"></a></webwork:param>
                                </webwork:text>
                            </webwork:else>
                        </p>
                    </page:param>
                </page:applyDecorator>
            </webwork:else>
        </td>
    </tr>
</table>

</body>
</html>
