<%@ page import="org.apache.lucene.index.IndexReader,
				 java.io.IOException,
				 org.apache.lucene.document.Document,
				 java.util.Enumeration,
				 org.apache.lucene.document.Field,
                 java.util.Iterator,
                 java.net.URLEncoder,
                 com.atlassian.jira.issue.IssueRelationConstants,
                 com.atlassian.jira.issue.index.DocumentConstants,
                 org.apache.lucene.index.IndexWriter,
                 com.atlassian.jira.issue.index.DefaultIndexManager" %>
<%@ page import="com.atlassian.jira.config.properties.APKeys"%>
<%@ page import="com.atlassian.jira.ManagerFactory"%>
<%@ page import="com.atlassian.jira.ComponentManager"%>
<%@ taglib uri="webwork" prefix="webwork" %>

<%
    String defaultIndexDir = ComponentManager.getInstance().getIndexPathManager().getIssueIndexPath();
    String indexDir = null;
	if (request.getParameter("index.dir") != null)
	{
		session.setAttribute("index.dir", request.getParameter("index.dir"));
	}

    if (session.getAttribute("index.dir") != null)
    {
        indexDir = (String)session.getAttribute("index.dir");
    }

%>

<html>

	<head>

		<title><webwork:text name="'admin.indexbrowser.index.browser'"/></title>

	</head>

	<body>

	<p>

	<form action="indexbrowser.jsp">
		<webwork:text name="'admin.indexbrowser.which.index'"/>

        <input name="index.dir" value="<%= indexDir != null ? indexDir : defaultIndexDir %>">

		<input type="submit" value="<webwork:text name="'admin.common.words.refresh'"/>">
	</form>

	<hr>

	<%
        IndexReader reader = null;

        if (indexDir != null)
        {

			try
			{
                IndexWriter writer = new IndexWriter(indexDir, DefaultIndexManager.ANALYZER_FOR_INDEXING, false);
                writer.optimize();
                writer.close();
                
				reader = IndexReader.open(indexDir);
			}
			catch (IOException e)
			{
				out.println("<b>Error</b>: Could not open index: " + e);
			}
		}
	%>

	<% if (reader != null) { %>

	<b><webwork:text name="'admin.indexbrowser.index.location'"/></b>: <%=  indexDir %><br>
	<b><webwork:text name="'admin.indexbrowser.number.of.documents'"/></b>: <%= reader.numDocs() %><br>


	<ol>
	<%
		for (int i = 0; i < reader.numDocs(); i++) {
			try {
                Document doc = reader.document(i);
	%>
		<li><b><a href="viewdocument.jsp?doc=<%= i %>"><%= doc.get(DocumentConstants.ISSUE_KEY) %></a></b></li>
	<%
		    } catch (Exception e)
            {
    %>
        <li><b><webwork:text name="'common.words.error'"/>: <%= e %></b></li>
    <%
            }
        }
	%>
	</ol>

	<% reader.close(); %>
	<% } %>


</body>

</html>

