<%@ page import="com.atlassian.core.user.GroupUtils,
                 com.atlassian.jira.ComponentManager" %>
<%@ page import="com.atlassian.jira.security.util.GroupSelectorUtils" %>
<%@ page import="com.opensymphony.user.Group" %>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Iterator" %>
<%@ page import="com.atlassian.jira.config.properties.ApplicationProperties" %>
<%@ page import="com.atlassian.jira.config.properties.APKeys" %>
<%
    ApplicationProperties ap = ComponentManager.getInstance().getApplicationProperties();
%>

<html>
<head><title>Edit Group Display Names</title></head>

<body>
<h1>Edit group display names</h1>
<% if (!ap.getOption(APKeys.JIRA_OPTION_USER_EXTERNALMGT)) { %>
    <p>Here you can specify a 'display' name for each group.</p>

    <p>Once display names have been assigned, you can:</p>
    <ol>
        <li>Create a select-list <a href="ViewCustomFields.jspa">custom field</a></li>
        <li>Configure this custom field, and set its values to the <b>display</b> names for each group></li>
        <li>In the <a href="ViewPermissionSchemes.jspa">permission scheme</a>, set a <b>Group Selector</b> permission
            type,
            set to the custom field added above.
        </li>
    </ol>

    <p>Users will then see a list of 'display' names for groups, which the permission scheme will interpret as
        specifying
        the mapped group.</p>

    <form method="POST">
        <table>
            <tr>
                <th>Group</th>
                <th>Display name</th>
            </tr>
            <%
                Collection groups = GroupUtils.getGroups();
                GroupSelectorUtils util = (GroupSelectorUtils) ComponentManager.getInstance().getContainer().getComponentInstanceOfType(GroupSelectorUtils.class);
                Iterator iter = groups.iterator();
                while (iter.hasNext())
                {
                    Group group = (Group) iter.next();
                    String oldVal = util.getGroupDisplayName(group);
                    String newVal = request.getParameter(group.getName());
                    boolean updated = util.updateGroupName(group, oldVal, newVal);
                    out.println("<tr><td>" + group.getName() + "</td>");
                    out.println("<td><input name='" + group.getName() + "' value='" + (updated ? newVal : (oldVal == null ? "" : oldVal)) + "'/>");
                    if (updated)
                    {
                        out.println("<font color='red'>Updated</font>");
                    }
                    out.println("</td></tr>");
                }
            %>
        </table>
        <input type="submit" value="Update Group(s)"/>
    </form>
<% } else { %>
    External user management is enabled. If you would like to be able to specify a 'display' name for each of your
    groups, disable external user managment. Contact your Administrator.
<% }  %>
</body>

</html>
