/**
 * If necessary, will shorten any matched element to the number of lines provided by the numRows parameter (1 by
 * default).  The contents of the matched element will be tokenized using an array of separators ('</span>,' '</a>,'
 * and ',' by default) and tokens will be removed from the end until the contents fit on a single line.  An ellipsis
 * will be appended to expand the section to display all text.  The state of a particular element will also be stored
 * in a cookie provided via a parameter ("jira.viewissue.cong.cookie" by default).
 */
jQuery.fn.shorten = function () {
    var defaults = {
        numRows: 1,
        separators:["</span>,", "</a>,", ","],
        cookieName: "jira.viewissue.cong.cookie"
    };

    return function (options) {
        var that = this;
        options = AJS.$.extend(defaults, options);
        options.viewMoreMsg = AJS.params.viewMoreMsg || 'Click to view {0} more';
        options.hideMsg = AJS.params.hideMsg || 'Hide';

        var refreshAll = function() {
            //because IE is such a pile of !#@!$ I have to go through and touch each of the shortened elmenents whenever
            //a hide/ellipsis link is clicked to force it to properly re-layout all elements.  You'd think that
            //simply hiding one div and displaying another div wouldn't require this, but apparently it does!
            if(AJS.$.browser.msie) {
                AJS.$(that).attr("position", "absolute").attr("position", "relative");
            }
        };

        //Returns the number of rows a particular element is currently taking up
        var getNumberOfRows = function(obj) {
            var $obj = AJS.$(obj);
            return Math.round($obj.height() / getLineHeight($obj));
        };

        //calculates the line height for a particular element.  This should be simple, but IE makes this
        //somewhat more complicated than it needs to be.
        var getLineHeight = function(obj) {
            //because IE is a bitch, can't just go obj.css("line-height") here :(
            var tempDiv = AJS.$("<div style='position:absolute; visibility:hidden'>A</div>");
            obj.append(tempDiv);
            var height = tempDiv.height();
            tempDiv.remove();
            return height;
        };

        //Try to tokenize the element html using the separators provided (in order) and remove the last
        // token.  If no matches can be found, return the input text.
        var reduceByWord = function(text) {
            var str = AJS.$.trim(text);
            for(var i=0;i<options.separators.length ;i++) {
                var separator = options.separators[i];
                //need to convert string to lowercase first since IE for some reason has SPAN in the string instead
                //of span
                var sepIndex = str.toLowerCase().lastIndexOf(separator);
                if(sepIndex !== -1) {
                    return str.substring(0, sepIndex + separator.length - 1);
                }
            }
            return text;
        };

        this.each(function(index) {
            var elem = AJS.$(this);
            var elemId = elem.attr("id");

            var elemRows = getNumberOfRows(elem);
            if(elemRows > options.numRows) {
                var hideLink = AJS.$("<a href=\"#" + elemId + "-shortened\" class=\"icon icon-hide\" title=\"" +
                                     options.hideMsg + "\"><span>" + options.hideMsg + "</span></a>");
                
                //first copy the original text to a hidden div
                var original = elem.clone().removeClass("shorten").append(hideLink).attr("id", elemId + "-expanded").hide();                
                elem.after(original);

                var numReduced = 0;

                while(elemRows > options.numRows) {
                    var htmlToReduce = elem.html();
                    var reducedHtml = reduceByWord(htmlToReduce);
                    if(htmlToReduce != reducedHtml) {
                        elem.html(reducedHtml);
                        elem.append(ellipsis);
                        elemRows = getNumberOfRows(elem);
                        numReduced++;
                    } else {
                        break;
                    }
                }

                var ellipsis = AJS.$('<a class="ellipsis" href="#' + elemId + '-expanded">(' + numReduced + ')</a>');

                reducedHtml = elem.html();
                elem.attr("id", elemId + "-shortened");
                ellipsis.attr("title", AJS.format(options.viewMoreMsg, numReduced)).click(function(e) {
                    e.preventDefault();
                    original.show();
                    elem.hide();
                    if(elemId && elemId !== '') {
                        saveToConglomerateCookie(options.cookieName, elemId, 'shown');
                    }
                    refreshAll();
                });
                hideLink.click(function(e) {
                    e.preventDefault();
                    original.hide();
                    elem.show();
                    if(elemId && elemId !== '') {
                        saveToConglomerateCookie(options.cookieName, elemId, 'hidden');
                    }
                    refreshAll();
                });
                elem.append(ellipsis);

                var preference = 'hidden';
                if(elemId && elemId !== '') {
                    preference = readFromConglomerateCookie(options.cookieName, elemId, 'hidden');
                }
                if(preference === 'shown') {
                    original.show();
                    elem.hide();
                }
            }
        });

        refreshAll();

        return that;
    };
}();