/**
 *
 * @module Controls
 * @requires AJS, jQuery, jQuery.moveTo
 */

/**
 * On first <em>keypress</em> in textarea element, will expand textarea to 15 rows and ensure visible in viewport.
 *
 * <pre>
 * <strong>Usage:</strong>
 * jQuery("textarea").expandOnInput();
 * </pre>
 *
 * @class expandOnInput
 * @constuctor expandOnInput
 * @namespace jQuery.fn
*/

jQuery.fn.expandOnInput = function (maxHeight) {

    function setHeight () {
        var scrollHeight = parseInt(that.attr("scrollHeight"), 10);
        if (scrollHeight <= maxHeight) {
            if (scrollHeight  - 5 > that.height()) {
                that.css("overflowY", "hidden").height(scrollHeight);
            }
        } else {
            that.css("overflowY", "").height(maxHeight);
        }
    }

    var that = this;

    if (this.length === 0) {
        return this;
    }

    maxHeight = maxHeight || 300;

    this.unbind("keyup", setHeight).bind("keyup", setHeight);

    // ie8 needs it in a setTimeout for some bizzare reason
    window.setTimeout(function () {
        setHeight();
    }, 0);

    return this;
};