/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;

public class BeanShellRegister
implements Register {
    public Object registerVariable(WorkflowContext context, WorkflowEntry entry, Map args, PropertySet ps) throws WorkflowException {
        String script = (String)args.get("script");
        Interpreter i = new Interpreter();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                i.setClassLoader(loader);
            }
            i.set("entry", (Object)entry);
            i.set("context", (Object)context);
            i.set("propertySet", (Object)ps);
            Object object = i.eval(script);
            return object;
        }
        catch (TargetError targetError) {
            if (targetError.getTarget() instanceof WorkflowException) {
                throw (WorkflowException)targetError.getTarget();
            }
            String message = "Could not get object registered in to variable map";
            throw new WorkflowException(message, targetError.getTarget());
        }
        catch (EvalError e) {
            String message = "Could not get object registered in to variable map";
            throw new WorkflowException(message, e);
        }
        finally {
            if (loader != null) {
                i.setClassLoader(null);
            }
        }
    }
}

