/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.util.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanShellCondition
implements Condition {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$util$beanshell$BeanShellCondition == null ? (class$com$opensymphony$workflow$util$beanshell$BeanShellCondition = BeanShellCondition.class$("com.opensymphony.workflow.util.beanshell.BeanShellCondition")) : class$com$opensymphony$workflow$util$beanshell$BeanShellCondition));
    static /* synthetic */ Class class$com$opensymphony$workflow$util$beanshell$BeanShellCondition;

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String script = (String)args.get("script");
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        Interpreter i = new Interpreter();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                i.setClassLoader(loader);
            }
            i.set("entry", (Object)entry);
            i.set("context", (Object)context);
            i.set("transientVars", (Object)transientVars);
            i.set("propertySet", (Object)ps);
            i.set("jn", transientVars.get("jn"));
            Object o = i.eval(script);
            if (o == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = TextUtils.parseBoolean((String)o.toString());
            return bl;
        }
        catch (TargetError targetError) {
            if (targetError.getTarget() instanceof WorkflowException) {
                throw (WorkflowException)targetError.getTarget();
            }
            String message = "Could not execute BeanShell script";
            throw new WorkflowException(message, targetError.getTarget());
        }
        catch (EvalError e) {
            String message = "Could not execute BeanShell script";
            log.error((Object)message, (Throwable)e);
            throw new WorkflowException(message, e);
        }
        finally {
            if (loader != null) {
                i.setClassLoader(null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

