/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.config;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.loader.ClassLoaderUtil;
import com.opensymphony.workflow.loader.URLWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowFactory;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.util.DefaultVariableResolver;
import com.opensymphony.workflow.util.VariableResolver;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultConfiguration
implements Configuration,
Serializable {
    private static final long serialVersionUID = 4120889092947132961L;
    public static DefaultConfiguration INSTANCE = new DefaultConfiguration();
    private Map persistenceArgs = new HashMap();
    private String persistenceClass;
    private WorkflowFactory factory = new URLWorkflowFactory();
    private transient WorkflowStore store = null;
    private VariableResolver variableResolver = new DefaultVariableResolver();
    private boolean initialized;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isModifiable(String name) {
        return this.factory.isModifiable(name);
    }

    public void setPersistence(String persistence) {
        this.persistenceClass = persistence;
    }

    public String getPersistence() {
        return this.persistenceClass;
    }

    public Map getPersistenceArgs() {
        return this.persistenceArgs;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public WorkflowDescriptor getWorkflow(String name) throws FactoryException {
        WorkflowDescriptor workflow = this.factory.getWorkflow(name);
        if (workflow == null) {
            throw new FactoryException("Unknown workflow name");
        }
        return workflow;
    }

    public String[] getWorkflowNames() throws FactoryException {
        return this.factory.getWorkflowNames();
    }

    public WorkflowStore getWorkflowStore() throws StoreException {
        if (this.store == null) {
            String clazz = this.getPersistence();
            try {
                this.store = (WorkflowStore)Class.forName(clazz).newInstance();
            }
            catch (Exception ex) {
                throw new StoreException("Error creating store", ex);
            }
            this.store.init(this.getPersistenceArgs());
        }
        return this.store;
    }

    public void load(URL url) throws FactoryException {
        InputStream is = this.getInputStream(url);
        if (is == null) {
            throw new FactoryException("Cannot find osworkflow.xml configuration file in classpath or in META-INF");
        }
        try {
            String resolverClass;
            DocumentBuilder db;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new FactoryException("Error creating document builder", e);
            }
            Document doc = db.parse(is);
            Element root = (Element)doc.getElementsByTagName("osworkflow").item(0);
            Element p = XMLUtil.getChildElement(root, "persistence");
            Element resolver = XMLUtil.getChildElement(root, "resolver");
            Element factoryElement = XMLUtil.getChildElement(root, "factory");
            if (resolver != null && (resolverClass = resolver.getAttribute("class")) != null) {
                this.variableResolver = (VariableResolver)ClassLoaderUtil.loadClass(resolverClass, this.getClass()).newInstance();
            }
            this.persistenceClass = p.getAttribute("class");
            List args = XMLUtil.getChildElements(p, "property");
            for (int i = 0; i < args.size(); ++i) {
                Element e = (Element)args.get(i);
                this.persistenceArgs.put(e.getAttribute("key"), e.getAttribute("value"));
            }
            if (factoryElement != null) {
                String clazz = null;
                try {
                    clazz = factoryElement.getAttribute("class");
                    if (clazz == null) {
                        throw new FactoryException("factory does not specify a class attribute");
                    }
                    this.factory = (WorkflowFactory)ClassLoaderUtil.loadClass(clazz, this.getClass()).newInstance();
                    Properties properties = new Properties();
                    List props = XMLUtil.getChildElements(factoryElement, "property");
                    for (int i = 0; i < props.size(); ++i) {
                        Element e = (Element)props.get(i);
                        properties.setProperty(e.getAttribute("key"), e.getAttribute("value"));
                    }
                    this.factory.init(properties);
                    this.factory.initDone();
                }
                catch (FactoryException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new FactoryException("Error creating workflow factory " + clazz, ex);
                }
            }
            this.initialized = true;
        }
        catch (FactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FactoryException("Error in workflow config", e);
        }
    }

    public boolean removeWorkflow(String workflow) throws FactoryException {
        return this.factory.removeWorkflow(workflow);
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        return this.factory.saveWorkflow(name, descriptor, replace);
    }

    protected InputStream getInputStream(URL url) {
        InputStream is = null;
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("osworkflow.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/osworkflow.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("META-INF/osworkflow.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/META-INF/osworkflow.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return is;
    }

    WorkflowFactory getFactory() {
        return this.factory;
    }
}

