/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.xmlrpc;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.rpc.RpcUtils;
import com.atlassian.jira.rpc.exception.RemoteAuthenticationException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.soap.JiraSoapService;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.xmlrpc.XmlRpcService;
import com.atlassian.plugin.PluginAccessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;

public class JiraXmlRpcService
implements XmlRpcService {
    JiraSoapService soapService;

    public JiraXmlRpcService(PluginAccessor pluginAccessor) {
        this.soapService = (JiraSoapService)pluginAccessor.getPluginModule("com.atlassian.jira.ext.rpc:soap").getModule();
    }

    public String login(String username, String password) throws RemoteException {
        return this.soapService.login(username, password);
    }

    public boolean logout(String token) {
        return this.soapService.logout(token);
    }

    public Hashtable getServerInfo(String token) {
        return RpcUtils.makeStruct(this.soapService.getServerInfo(token));
    }

    public Vector getProjectsNoSchemes(String token) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getProjectsNoSchemes(token));
    }

    public Vector getVersions(String token, String projectKey) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getVersions(token, projectKey));
    }

    public Vector getComponents(String token, String projectKey) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getComponents(token, projectKey));
    }

    public Vector getIssueTypesForProject(String token, String projectId) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getIssueTypesForProject(token, projectId));
    }

    public Vector getSubTaskIssueTypesForProject(String token, String projectId) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getSubTaskIssueTypesForProject(token, projectId));
    }

    public Vector getIssueTypes(String token) throws RemotePermissionException, RemoteAuthenticationException {
        return RpcUtils.makeVector(this.soapService.getIssueTypes(token));
    }

    public Vector getSubTaskIssueTypes(String token) throws Exception {
        return RpcUtils.makeVector(this.soapService.getSubTaskIssueTypes(token));
    }

    public Vector getPriorities(String token) throws RemotePermissionException, RemoteAuthenticationException {
        return RpcUtils.makeVector(this.soapService.getPriorities(token));
    }

    public Vector getStatuses(String token) throws RemotePermissionException, RemoteAuthenticationException {
        return RpcUtils.makeVector(this.soapService.getStatuses(token));
    }

    public Vector getResolutions(String token) throws RemotePermissionException, RemoteAuthenticationException {
        return RpcUtils.makeVector(this.soapService.getResolutions(token));
    }

    public Hashtable getUser(String token, String username) throws RemotePermissionException, RemoteAuthenticationException {
        return RpcUtils.makeStruct(this.soapService.getUser(token, username));
    }

    public Vector getSavedFilters(String token) throws RemoteException {
        return this.getFavouriteFilters(token);
    }

    public Vector getFavouriteFilters(String token) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getFavouriteFilters(token));
    }

    public Hashtable getIssue(String token, String issueKey) throws RemoteException {
        return this.makeIssueStruct(this.soapService.getIssue(token, issueKey));
    }

    public Vector getComments(String token, String issueKey) throws RemoteException {
        return RpcUtils.makeVector(this.soapService.getComments(token, issueKey));
    }

    public Hashtable createIssue(String token, Hashtable rIssueStruct) throws RemoteException {
        return this.makeIssueStruct(this.soapService.createIssue(token, this.makeRemoteIssue(rIssueStruct)));
    }

    public Hashtable updateIssue(String token, String issueKey, Hashtable rIssueStruct) throws RemoteException {
        return this.makeIssueStruct(this.soapService.updateIssue(token, issueKey, this.makeRemoteFieldValue(rIssueStruct)));
    }

    public boolean addComment(String token, String issueKey, String comment) throws Exception {
        this.soapService.addComment(token, issueKey, new RemoteComment(comment));
        return true;
    }

    public Vector getIssuesFromFilter(String token, String filterId) throws RemoteException {
        RemoteIssue[] issuesFromFilter = this.soapService.getIssuesFromFilter(token, filterId);
        return this.convertIssuesToVector(issuesFromFilter);
    }

    public Vector getIssuesFromTextSearch(String token, String searchTerms) throws Exception {
        RemoteIssue[] issuesFromFilter = this.soapService.getIssuesFromTextSearch(token, searchTerms);
        return this.convertIssuesToVector(issuesFromFilter);
    }

    public Vector getIssuesFromTextSearchWithProject(String token, Vector projectKeys, String searchTerms, int maxNumResults) throws Exception {
        try {
            String[] keys = projectKeys.toArray(new String[projectKeys.size()]);
            RemoteIssue[] issuesFromFilter = this.soapService.getIssuesFromTextSearchWithProject(token, keys, searchTerms, maxNumResults);
            return this.convertIssuesToVector(issuesFromFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Vector convertIssuesToVector(RemoteIssue[] issuesFromFilter) {
        if (issuesFromFilter != null) {
            Vector<Hashtable> returnedIsssue = new Vector<Hashtable>(issuesFromFilter.length);
            for (int i = 0; i < issuesFromFilter.length; ++i) {
                RemoteIssue remoteIssue = issuesFromFilter[i];
                try {
                    returnedIsssue.add(this.makeIssueStruct(remoteIssue));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return returnedIsssue;
        }
        return new Vector();
    }

    private RemoteFieldValue[] makeRemoteFieldValue(Hashtable ht) {
        if (ht != null) {
            RemoteFieldValue[] fieldValues = new RemoteFieldValue[ht.size()];
            Set entries = ht.entrySet();
            int i = 0;
            for (Map.Entry entry : entries) {
                String key = entry.getKey().toString();
                Vector values = (Vector)entry.getValue();
                fieldValues[i] = new RemoteFieldValue(key, this.makeStringVector(values));
                ++i;
            }
            return fieldValues;
        }
        return null;
    }

    private Hashtable makeIssueStruct(RemoteIssue issue) {
        try {
            Vector components = null;
            Vector fixVersions = null;
            Vector affectsVersions = null;
            if (issue.getComponents() != null) {
                components = RpcUtils.makeVector(issue.getComponents());
                issue.setComponents(null);
            }
            if (issue.getAffectsVersions() != null) {
                affectsVersions = RpcUtils.makeVector(issue.getAffectsVersions());
                issue.setAffectsVersions(null);
            }
            if (issue.getFixVersions() != null) {
                fixVersions = RpcUtils.makeVector(issue.getFixVersions());
                issue.setFixVersions(null);
            }
            Vector customFieldValues = null;
            if (issue.getCustomFieldValues() != null) {
                customFieldValues = RpcUtils.makeVector(issue.getCustomFieldValues());
                issue.setCustomFieldValues(null);
            }
            Hashtable result = new Hashtable(BeanUtils.describe((Object)issue)){

                public synchronized Object put(Object key, Object value) {
                    if (value == null || key == null || "class".equals(key)) {
                        return null;
                    }
                    return super.put(key, value);
                }
            };
            if (components != null) {
                result.put("components", components);
            }
            if (affectsVersions != null) {
                result.put("affectsVersions", affectsVersions);
            }
            if (fixVersions != null) {
                result.put("fixVersions", fixVersions);
            }
            if (customFieldValues != null) {
                result.put("customFieldValues", customFieldValues);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private RemoteIssue makeRemoteIssue(Hashtable rIssueStruct) {
        Hashtable workStruct = new Hashtable(rIssueStruct);
        RemoteIssue rIssue = new RemoteIssue();
        try {
            RemoteVersion[] versions;
            Vector versionStructs;
            int i;
            if (workStruct.containsKey("components")) {
                Vector componentStructs = (Vector)workStruct.get("components");
                RemoteComponent[] components = new RemoteComponent[componentStructs.size()];
                for (i = 0; i < components.length; ++i) {
                    components[i] = this.makeRemoteComponent((Hashtable)componentStructs.get(i));
                }
                rIssue.setComponents(components);
                workStruct.remove("components");
            }
            if (workStruct.containsKey("fixVersions")) {
                versionStructs = (Vector)workStruct.get("fixVersions");
                versions = new RemoteVersion[versionStructs.size()];
                for (i = 0; i < versions.length; ++i) {
                    versions[i] = this.makeRemoteVersion((Hashtable)versionStructs.get(i));
                }
                rIssue.setFixVersions(versions);
                workStruct.remove("fixVersions");
            }
            if (workStruct.containsKey("affectsVersions")) {
                versionStructs = (Vector)workStruct.get("affectsVersions");
                versions = new RemoteVersion[versionStructs.size()];
                for (i = 0; i < versions.length; ++i) {
                    versions[i] = this.makeRemoteVersion((Hashtable)versionStructs.get(i));
                }
                rIssue.setAffectsVersions(versions);
                workStruct.remove("affectsVersions");
            }
            if (workStruct.containsKey("customFieldValues")) {
                Vector structs = (Vector)workStruct.get("customFieldValues");
                RemoteCustomFieldValue[] customFieldValues = new RemoteCustomFieldValue[structs.size()];
                for (i = 0; i < customFieldValues.length; ++i) {
                    customFieldValues[i] = this.makeCustomFieldValue((Hashtable)structs.get(i));
                }
                rIssue.setCustomFieldValues(customFieldValues);
                workStruct.remove("customFieldValues");
            }
            BeanUtils.populate((Object)rIssue, workStruct);
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not create RemoteIssue from struct?", (Throwable)e);
        }
        return rIssue;
    }

    private RemoteCustomFieldValue makeCustomFieldValue(Hashtable struct) {
        Object id = struct.get("customfieldId");
        Object key = struct.get("key");
        RemoteCustomFieldValue customFieldValue = new RemoteCustomFieldValue();
        customFieldValue.setCustomfieldId(id != null ? id.toString() : null);
        customFieldValue.setKey(key != null ? key.toString() : null);
        customFieldValue.setValues(this.makeStringVector((Vector)struct.get("values")));
        return customFieldValue;
    }

    private String[] makeStringVector(Vector vector) {
        String[] strings = new String[vector.size()];
        int i = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            strings[i] = iterator.next().toString();
            ++i;
        }
        return strings;
    }

    private RemoteComponent makeRemoteComponent(Hashtable componentStruct) throws IllegalAccessException, InvocationTargetException {
        RemoteComponent component = new RemoteComponent();
        BeanUtils.populate((Object)component, (Map)componentStruct);
        return component;
    }

    private RemoteVersion makeRemoteVersion(Hashtable versionStruct) throws IllegalAccessException, InvocationTargetException {
        RemoteVersion version = new RemoteVersion();
        BeanUtils.populate((Object)version, (Map)versionStruct);
        return version;
    }
}

