/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.util;

import com.atlassian.core.user.UserUtils;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.util.RemoteEntityFactory;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.User;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteEntityFactoryImpl
implements RemoteEntityFactory {
    private static final Logger log = Logger.getLogger(RemoteEntityFactoryImpl.class);
    private final EmailFormatter emailFormatter;

    public RemoteEntityFactoryImpl(EmailFormatter emailFormatter) {
        this.emailFormatter = emailFormatter;
    }

    public RemoteUser createUser(User user) {
        Assertions.notNull((String)"user", (Object)user);
        RemoteUser remoteUser = new RemoteUser(user);
        remoteUser.setEmail(this.emailFormatter.formatEmail(user.getEmail(), true));
        return remoteUser;
    }

    public RemoteGroup createGroup(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        RemoteGroup remoteGroup = new RemoteGroup();
        remoteGroup.setName(group.getName());
        List userNames = group.getUsers();
        RemoteUser[] remoteUsers = new RemoteUser[userNames.size()];
        for (int i = 0; i < userNames.size(); ++i) {
            try {
                remoteUsers[i] = this.createUser(UserUtils.getUser((String)((String)userNames.get(i))));
                continue;
            }
            catch (EntityNotFoundException e) {
                log.error((Object)"EntityNotFoundException getting previously retrieved user, this should never happen?", (Throwable)e);
            }
        }
        remoteGroup.setUsers(remoteUsers);
        return remoteGroup;
    }
}

