/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class BeanPropertyComponentAdapter
extends DecoratingComponentAdapter {
    private Map properties;
    private PropertyDescriptor[] propertyDescriptors;
    private Map propertyDescriptorMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;

    public BeanPropertyComponentAdapter(ComponentAdapter delegate) throws PicoInitializationException {
        super(delegate);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(delegate.getComponentImplementation());
            this.propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < this.propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i];
                this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new PicoInitializationException("Couldn't load BeanInfo for" + delegate.getComponentImplementation().getName(), e);
        }
    }

    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentInstance = super.getComponentInstance();
        if (this.properties != null) {
            Set propertyNames = this.properties.keySet();
            Iterator iterator = propertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                Object propertyValue = this.properties.get(propertyName);
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
                if (propertyDescriptor == null) {
                    throw new PicoIntrospectionException("Unknown property '" + propertyName + "' in class " + componentInstance.getClass().getName() + " Existing properties:" + this.propertyDescriptorMap);
                }
                Method setter = propertyDescriptor.getWriteMethod();
                if (setter == null) {
                    throw new PicoInitializationException("There is no public setter method for property " + propertyName + " in " + componentInstance.getClass().getName() + ". Setter: " + propertyDescriptor.getWriteMethod() + ". Getter: " + propertyDescriptor.getReadMethod());
                }
                try {
                    setter.invoke(componentInstance, this.convertType(setter, propertyValue));
                }
                catch (Exception e) {
                    throw new PicoInitializationException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                }
            }
        }
        return componentInstance;
    }

    private Object convertType(Method setter, Object propertyValue) throws MalformedURLException {
        Object component;
        if (propertyValue == null) {
            return null;
        }
        Class<?> type = setter.getParameterTypes()[0];
        if (type.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPropertyComponentAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPropertyComponentAdapter.class$("java.lang.Byte")) : class$java$lang$Byte) || type.equals(Byte.TYPE)) {
            return Byte.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Short == null ? (class$java$lang$Short = BeanPropertyComponentAdapter.class$("java.lang.Short")) : class$java$lang$Short) || type.equals(Short.TYPE)) {
            return Short.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPropertyComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Long == null ? (class$java$lang$Long = BeanPropertyComponentAdapter.class$("java.lang.Long")) : class$java$lang$Long) || type.equals(Long.TYPE)) {
            return Long.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Float == null ? (class$java$lang$Float = BeanPropertyComponentAdapter.class$("java.lang.Float")) : class$java$lang$Float) || type.equals(Float.TYPE)) {
            return Float.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Double == null ? (class$java$lang$Double = BeanPropertyComponentAdapter.class$("java.lang.Double")) : class$java$lang$Double) || type.equals(Double.TYPE)) {
            return Double.valueOf(propertyValue.toString());
        }
        if (type.equals(class$java$lang$Character == null ? (class$java$lang$Character = BeanPropertyComponentAdapter.class$("java.lang.Character")) : class$java$lang$Character) || type.equals(Character.TYPE)) {
            return new Character(propertyValue.toString().toCharArray()[0]);
        }
        if ((class$java$io$File == null ? (class$java$io$File = BeanPropertyComponentAdapter.class$("java.io.File")) : class$java$io$File).isAssignableFrom(type)) {
            return new File(propertyValue.toString());
        }
        if ((class$java$net$URL == null ? (class$java$net$URL = BeanPropertyComponentAdapter.class$("java.net.URL")) : class$java$net$URL).isAssignableFrom(type)) {
            return new URL(propertyValue.toString());
        }
        if (this.getContainer() != null && (component = this.getContainer().getComponentInstance(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
            return component;
        }
        return propertyValue;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

