/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyLoadedReference<V> {
    private final AtomicReference<FutureTask<V>> ref = new AtomicReference();

    public final V get() {
        FutureTask<V> future = this.ref.get();
        if (future == null) {
            future = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return LazyLoadedReference.this.create();
                }
            });
            this.ref.compareAndSet(null, future);
            future = this.ref.get();
            future.run();
        }
        while (true) {
            try {
                return future.get();
            }
            catch (InterruptedException interruptAndTryAgain) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw new InitializationException(e.getCause());
                }
                throw new InitializationException(e);
            }
            break;
        }
    }

    protected abstract V create() throws Exception;

    public static class InitializationException
    extends RuntimeException {
        InitializationException(Throwable t) {
            super(t);
        }
    }
}

