/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginContainerFailedEvent;
import com.atlassian.plugin.event.events.PluginContainerRefreshedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitEndedEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitStartingEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitTimedOutEvent;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.ModuleDescriptorServiceTrackerCustomizer;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.factory.OsgiPluginInstalledHelper;
import com.atlassian.plugin.osgi.factory.OsgiPluginUninstalledHelper;
import com.atlassian.plugin.osgi.factory.UnrecognizedModuleDescriptorServiceTrackerCustomizer;
import com.atlassian.plugin.util.PluginUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiPlugin
extends AbstractPlugin
implements AutowireCapablePlugin {
    private final Map<String, Element> moduleElements = new HashMap<String, Element>();
    private final PluginEventManager pluginEventManager;
    private final PackageAdmin packageAdmin;
    private final Set<OutstandingDependency> outstandingDependencies = new CopyOnWriteArraySet<OutstandingDependency>();
    private volatile boolean treatSpringBeanFactoryCreationAsRefresh = false;
    private volatile OsgiPluginHelper helper;
    public static final String SPRING_CONTEXT = "Spring-Context";
    public static final String ATLASSIAN_PLUGIN_KEY = "Atlassian-Plugin-Key";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public OsgiPlugin(String key, OsgiContainerManager mgr, PluginArtifact artifact, PluginEventManager pluginEventManager) {
        Validate.notNull((Object)key, (String)"The plugin key is required");
        Validate.notNull((Object)mgr, (String)"The osgi container is required");
        Validate.notNull((Object)artifact, (String)"The osgi container is required");
        Validate.notNull((Object)pluginEventManager, (String)"The osgi container is required");
        this.helper = new OsgiPluginUninstalledHelper(key, mgr, artifact);
        this.pluginEventManager = pluginEventManager;
        this.packageAdmin = this.extractPackageAdminFromOsgi(mgr);
    }

    OsgiPlugin(PluginEventManager pluginEventManager, OsgiPluginHelper helper) {
        this.helper = helper;
        this.pluginEventManager = pluginEventManager;
        this.packageAdmin = null;
    }

    public Bundle getBundle() throws IllegalPluginStateException {
        return this.helper.getBundle();
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException, IllegalPluginStateException {
        return this.helper.loadClass(clazz, callingClass);
    }

    public URL getResource(String name) throws IllegalPluginStateException {
        return this.helper.getResource(name);
    }

    public InputStream getResourceAsStream(String name) throws IllegalPluginStateException {
        return this.helper.getResourceAsStream(name);
    }

    public ClassLoader getClassLoader() throws IllegalPluginStateException {
        return this.helper.getClassLoader();
    }

    @PluginEventListener
    public void onSpringContextFailed(PluginContainerFailedEvent event) throws IllegalPluginStateException {
        if (this.getKey() == null) {
            throw new IllegalPluginStateException("Plugin key must be set");
        }
        if (this.getKey().equals(event.getPluginKey())) {
            this.logAndClearOustandingDependencies();
            this.getLog().error((Object)("Unable to start the Spring context for plugin " + this.getKey()), event.getCause());
            this.setPluginState(PluginState.DISABLED);
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitStarting(PluginServiceDependencyWaitStartingEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.add(dep);
            this.getLog().info((Object)this.generateOutstandingDependencyLogMessage(dep, "Waiting for"));
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitEnded(PluginServiceDependencyWaitEndedEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.remove(dep);
            this.getLog().info((Object)this.generateOutstandingDependencyLogMessage(dep, "Found"));
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitEnded(PluginServiceDependencyWaitTimedOutEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.remove(dep);
            this.getLog().error((Object)this.generateOutstandingDependencyLogMessage(dep, "Timeout waiting for "));
        }
    }

    private String generateOutstandingDependencyLogMessage(OutstandingDependency dep, String action) {
        StringBuilder sb = new StringBuilder();
        sb.append(action).append(" ");
        sb.append("service '").append(dep.getBeanName()).append("' for plugin '").append(this.getKey()).append("' with filter ").append(dep.getFilter());
        return sb.toString();
    }

    @PluginEventListener
    public void onSpringContextRefresh(PluginContainerRefreshedEvent event) throws IllegalPluginStateException {
        if (this.getKey() == null) {
            throw new IllegalPluginStateException("Plugin key must be set");
        }
        if (this.getKey().equals(event.getPluginKey())) {
            this.outstandingDependencies.clear();
            this.helper.setPluginContainer(event.getContainer());
            if (!this.compareAndSetPluginState(PluginState.ENABLING, PluginState.ENABLED) && this.getPluginState() != PluginState.ENABLED) {
                this.log.warn((Object)("Ignoring the Spring context that was just created for plugin " + this.getKey() + ".  The plugin " + "is in an invalid state, " + this.getPluginState() + ", that doesn't support a transition to " + "enabled.  Most likely, it was disabled due to a timeout."));
                this.helper.setPluginContainer(null);
                return;
            }
            if (this.treatSpringBeanFactoryCreationAsRefresh) {
                this.pluginEventManager.broadcast((Object)new PluginRefreshedEvent((Plugin)this));
            } else {
                this.treatSpringBeanFactoryCreationAsRefresh = true;
            }
        }
    }

    public <T> T autowire(Class<T> clazz) throws IllegalPluginStateException {
        return this.autowire(clazz, AutowireCapablePlugin.AutowireStrategy.AUTOWIRE_AUTODETECT);
    }

    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        return this.helper.autowire(clazz, autowireStrategy);
    }

    public void autowire(Object instance) throws IllegalStateException {
        this.autowire(instance, AutowireCapablePlugin.AutowireStrategy.AUTOWIRE_AUTODETECT);
    }

    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        this.helper.autowire(instance, autowireStrategy);
    }

    public Set<String> getRequiredPlugins() throws IllegalPluginStateException {
        return this.helper.getRequiredPlugins();
    }

    public String toString() {
        return this.getKey();
    }

    protected void installInternal() throws IllegalPluginStateException {
        Bundle bundle = this.helper.install();
        this.helper = new OsgiPluginInstalledHelper(bundle, this.packageAdmin);
    }

    protected synchronized PluginState enableInternal() throws OsgiContainerException, IllegalPluginStateException {
        try {
            PluginState stateResult;
            if (this.getBundle().getState() == 32) {
                stateResult = PluginState.ENABLED;
            } else if (this.getBundle().getState() == 4 || this.getBundle().getState() == 2) {
                this.pluginEventManager.register((Object)this);
                if (!this.treatSpringBeanFactoryCreationAsRefresh) {
                    stateResult = PluginState.ENABLING;
                    this.setPluginState(stateResult);
                } else {
                    stateResult = PluginState.ENABLED;
                }
                this.getBundle().start();
                BundleContext ctx = this.getBundle().getBundleContext();
                this.helper.onEnable(new ServiceTracker(ctx, ModuleDescriptor.class.getName(), (ServiceTrackerCustomizer)new ModuleDescriptorServiceTrackerCustomizer(this)), new ServiceTracker(ctx, ListableModuleDescriptorFactory.class.getName(), (ServiceTrackerCustomizer)new UnrecognizedModuleDescriptorServiceTrackerCustomizer(this)));
                ctx.addBundleListener(new BundleListener(){

                    public void bundleChanged(BundleEvent bundleEvent) {
                        if (bundleEvent.getBundle() == OsgiPlugin.this.getBundle() && bundleEvent.getType() == 4) {
                            OsgiPlugin.this.helper.onDisable();
                            OsgiPlugin.this.setPluginState(PluginState.DISABLED);
                        }
                    }
                });
            } else {
                throw new OsgiContainerException("Cannot enable the plugin '" + this.getKey() + "' when the bundle is not in the resolved or installed state: " + this.getBundle().getState() + "(" + this.getBundle().getBundleId() + ")");
            }
            return this.getPluginState() != PluginState.ENABLED ? stateResult : PluginState.ENABLED;
        }
        catch (BundleException e) {
            throw new OsgiContainerException("Cannot start plugin: " + this.getKey(), e);
        }
    }

    protected synchronized void disableInternal() throws OsgiContainerException, IllegalPluginStateException {
        try {
            if (!PluginUtils.doesPluginRequireRestart((Plugin)this)) {
                if (this.getPluginState() == PluginState.ENABLING) {
                    this.logAndClearOustandingDependencies();
                }
                this.helper.onDisable();
                this.pluginEventManager.unregister((Object)this);
                this.getBundle().stop();
                this.treatSpringBeanFactoryCreationAsRefresh = false;
            }
        }
        catch (BundleException e) {
            throw new OsgiContainerException("Cannot stop plugin: " + this.getKey(), e);
        }
    }

    private void logAndClearOustandingDependencies() {
        for (OutstandingDependency dep : this.outstandingDependencies) {
            this.getLog().error((Object)this.generateOutstandingDependencyLogMessage(dep, "Never resolved"));
        }
        this.outstandingDependencies.clear();
    }

    protected void uninstallInternal() throws OsgiContainerException, IllegalPluginStateException {
        try {
            if (this.getBundle().getState() != 1) {
                this.pluginEventManager.unregister((Object)this);
                this.getBundle().uninstall();
                this.helper.onUninstall();
                this.setPluginState(PluginState.UNINSTALLED);
            }
        }
        catch (BundleException e) {
            throw new OsgiContainerException("Cannot uninstall bundle " + this.getBundle().getSymbolicName());
        }
    }

    void addModuleDescriptorElement(String key, Element element) {
        this.moduleElements.put(key, element);
    }

    void clearModuleDescriptor(String key) {
        this.removeModuleDescriptor(key);
    }

    Map<String, Element> getModuleElements() {
        return this.moduleElements;
    }

    private PackageAdmin extractPackageAdminFromOsgi(OsgiContainerManager mgr) {
        Bundle bundle = mgr.getBundles()[0];
        ServiceReference ref = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)bundle.getBundleContext().getService(ref);
    }

    private static class OutstandingDependency {
        private final String beanName;
        private final String filter;

        public OutstandingDependency(String beanName, String filter) {
            this.beanName = beanName;
            this.filter = filter;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutstandingDependency that = (OutstandingDependency)o;
            if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
                return false;
            }
            return this.filter.equals(that.filter);
        }

        public int hashCode() {
            int result = this.beanName != null ? this.beanName.hashCode() : 0;
            result = 31 * result + this.filter.hashCode();
            return result;
        }
    }
}

