/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheManager
implements CacheManager {
    private final ConcurrentMap<String, CacheHolder<?, ?>> caches = new ConcurrentHashMap();
    private final List<String> nonFlushableCacheNames;
    private final CacheProvider cacheProvider;

    public DefaultCacheManager(CacheProvider cacheProvider) {
        this(cacheProvider, Collections.emptyList());
    }

    public DefaultCacheManager(CacheProvider cacheProvider, List<String> nonFlushableCacheNames) {
        this.cacheProvider = cacheProvider;
        this.nonFlushableCacheNames = new ArrayList<String>(nonFlushableCacheNames);
    }

    @Override
    public Collection<Cache<?, ?>> getCaches() {
        HashSet ret = new HashSet();
        for (CacheHolder cacheHolder : this.caches.values()) {
            ret.add(cacheHolder.getCache());
        }
        return ret;
    }

    @Override
    public void flushCaches() {
        for (CacheHolder cacheHolder : this.caches.values()) {
            if (this.nonFlushableCacheNames.contains(cacheHolder.getCache().getName())) continue;
            cacheHolder.getCache().removeAll();
        }
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name) {
        return this.getCache(name, null, null);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) {
        CacheHolder holder;
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, new CacheHolder<K, V>(name, keyType, valueType));
        }
        if ((holder = (CacheHolder)this.caches.get(name)).isTypeMatch(keyType, valueType)) {
            Cache cache = holder.getCache();
            return cache;
        }
        throw new RuntimeException("Unreachable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheHolder<K, V> {
        private Cache<K, V> cache;
        private final Class<K> keyType;
        private final Class<V> valueType;
        private final String name;

        public CacheHolder(String name, Class<K> keyType, Class<V> valueType) {
            this.name = name;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public synchronized Cache<K, V> getCache() {
            if (this.cache == null) {
                this.cache = DefaultCacheManager.this.cacheProvider.createCache(this.name, this.keyType, this.valueType);
            }
            return this.cache;
        }

        public boolean isTypeMatch(Class<?> keyType, Class<?> valueType) throws ClassCastException {
            if (this.keyType != null && !this.keyType.equals(keyType)) {
                throw new ClassCastException("Key type doesn't match. Expected '" + this.keyType + "' but received '" + keyType + "'");
            }
            if (this.valueType != null && !this.valueType.equals(valueType)) {
                throw new ClassCastException("Value type doesn't match. Expected '" + this.valueType + "' but received '" + valueType + "'");
            }
            return true;
        }
    }
}

