/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import webwork.util.URLCodec;

public class URLBean {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String page = null;
    private Map params = new HashMap();

    public String getPage() {
        return this.page;
    }

    public URLBean setPage(String page) {
        this.page = page;
        return this;
    }

    public URLBean addParameter(String name, Object value) {
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, value.toString());
        }
        return this;
    }

    public void setRequest(HttpServletRequest req) {
        this.request = req;
        String query = req.getQueryString();
        if (query != null) {
            Hashtable queryParams;
            int idx = query.lastIndexOf(35);
            if (idx != -1) {
                query = query.substring(0, idx - 1);
            }
            if ((queryParams = HttpUtils.parseQueryString((String)query)).size() > 0) {
                if (this.params == null) {
                    this.params = new HashMap();
                }
                this.params.putAll(queryParams);
            }
        }
    }

    public void setResponse(HttpServletResponse resp) {
        this.response = resp;
    }

    public String getURL() {
        String result;
        StringBuffer link = new StringBuffer();
        if (this.page != null) {
            if (this.page.startsWith("/")) {
                String appContext = this.request.getContextPath();
                link.append(appContext);
            }
            link.append(this.page);
        } else {
            String requestURI = (String)this.request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = this.request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (this.params.size() > 0) {
            link.append('?');
            Iterator e = this.params.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry entry = e.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        link.append(name);
                        link.append('=');
                        link.append(URLCodec.encode((String)value));
                    } else {
                        String[] values = (String[])value;
                        for (int i = 0; i < values.length; ++i) {
                            String val = values[i];
                            link.append(name);
                            link.append('=');
                            link.append(URLCodec.encode(val));
                            if (i >= values.length - 1) continue;
                            link.append("&amp;");
                        }
                    }
                }
                if (!e.hasNext()) continue;
                link.append("&amp;");
            }
        }
        try {
            result = this.response.encodeURL(link.toString());
        }
        catch (Exception e) {
            result = link.toString();
        }
        return result;
    }

    public String toString() {
        return this.getURL();
    }
}

