/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.util.Encoding;
import webwork.util.URLCodec;
import webwork.view.taglib.PageResponse;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class IncludeTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private static final Log log = LogFactory.getLog(IncludeTag.class);
    protected String pageAttr;
    protected String valueAttr;
    protected Map params;

    public static void include(String aResult, PageContext aContext) throws ServletException, IOException {
        String resourcePath = IncludeTag.getContextRelativePath(aContext.getRequest(), aResult);
        RequestDispatcher rd = aContext.getRequest().getRequestDispatcher(resourcePath);
        if (rd == null) {
            String msg = "Not a valid resource path:" + resourcePath + ", make sure this file exists!";
            log.error((Object)msg);
            throw new ServletException(msg);
        }
        PageResponse pageResponse = new PageResponse((HttpServletResponse)aContext.getResponse());
        rd.include(aContext.getRequest(), (ServletResponse)pageResponse);
        String encoding = Encoding.getEncoding();
        if (encoding != null) {
            pageResponse.getContent().writeTo(aContext.getOut(), encoding);
        } else {
            pageResponse.getContent().writeTo(aContext.getOut(), null);
        }
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        String returnValue;
        if (relativePath.startsWith("/")) {
            returnValue = relativePath;
        } else if (!(request instanceof HttpServletRequest)) {
            returnValue = relativePath;
        } else {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = hrequest.getServletPath();
            }
            returnValue = uri.substring(0, uri.lastIndexOf(47)) + '/' + relativePath;
        }
        if (returnValue.indexOf("..") != -1) {
            Stack<String> stack = new Stack<String>();
            StringTokenizer pathParts = new StringTokenizer(returnValue.replace('\\', '/'), "/");
            while (pathParts.hasMoreTokens()) {
                String part = pathParts.nextToken();
                if (".".equals(part)) continue;
                if ("..".equals(part)) {
                    stack.pop();
                    continue;
                }
                stack.push(part);
            }
            StringBuffer flatPathBuffer = new StringBuffer();
            for (int i = 0; i < stack.size(); ++i) {
                flatPathBuffer.append('/').append(stack.elementAt(i));
            }
            returnValue = flatPathBuffer.toString();
        }
        return returnValue;
    }

    public void setPage(String aPage) {
        this.pageAttr = aPage;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            ArrayList<Object> currentValues = (ArrayList<Object>)this.params.get(name);
            if (currentValues == null) {
                currentValues = new ArrayList<Object>();
                this.params.put(name, currentValues);
            }
            currentValues.add(value);
        }
    }

    public int doStartTag() throws JspException {
        this.params = new HashMap();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        String page = this.valueAttr != null ? (String)this.findValue(this.valueAttr) : this.pageAttr;
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(page);
        if (this.params.size() > 0) {
            urlBuf.append('?');
            String concat = "";
            for (Map.Entry entry : this.params.entrySet()) {
                Object name = entry.getKey();
                List values = (List)entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    urlBuf.append(concat);
                    urlBuf.append(name);
                    urlBuf.append('=');
                    urlBuf.append(URLCodec.encode(values.get(i).toString()));
                    concat = "&";
                }
            }
        }
        this.params = null;
        String result = urlBuf.toString();
        try {
            IncludeTag.include(result, this.pageContext);
        }
        catch (Exception e) {
            throw new JspException("Exception thrown during include of " + result, (Throwable)e);
        }
        super.doEndTag();
        return 6;
    }
}

