/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.ArrayList;
import java.util.List;
import webwork.util.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySegment {
    public static final int STRING = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int CURRENT = 3;
    public static final int PARENT = 4;
    public static final int ROOT = 5;
    public static final int ATTRIBUTE = 6;
    public static final int PARAMETER = 7;
    public static final int PROPERTY = 8;
    public static final int COLLECTION = 9;
    public static final int METHOD = 10;
    public static final int EXPAND = 11;
    public static final int NUMBER = 12;
    public static final int NULL = 13;
    public static final int CONCAT = 14;
    private final Query query;
    private final String id;
    private final int type;
    private final List<Object> values = new ArrayList<Object>();

    public QuerySegment(int type) {
        this.type = type;
        this.id = null;
        this.query = null;
    }

    public QuerySegment(String id, int type) {
        this.type = type;
        this.id = id;
        this.query = null;
    }

    public QuerySegment(String id, Query query, int type) {
        this.type = type;
        this.id = id;
        this.query = query;
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void createValues() {
        this.values.clear();
    }

    public String getId() {
        return this.id;
    }

    public Query getQuery() {
        return this.query;
    }

    public int getType() {
        return this.type;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                sb.append(this.values.get(i));
                if (i + 1 >= this.values.size()) continue;
                sb.append(",");
            }
        }
        sb.append("\"");
        return "[id=\"" + this.id + "\" type=\"" + this.type + "\" values=" + sb.toString() + "]";
    }
}

