/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SessionMap
extends AbstractMap {
    HttpSession session;
    Set entries;

    public SessionMap(HttpSession s) {
        this.session = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            if (this.entries == null) {
                this.entries = new HashSet();
                Enumeration e = this.session.getAttributeNames();
                while (e.hasMoreElements()) {
                    final String key = e.nextElement().toString();
                    final Object value = this.session.getAttribute(key);
                    this.entries.add(new Map.Entry(){

                        public boolean equals(Object obj) {
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        public Object getKey() {
                            return key;
                        }

                        public Object getValue() {
                            return value;
                        }

                        public Object setValue(Object obj) {
                            SessionMap.this.session.setAttribute(key, obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.entries = null;
            Object originalValue = this.session.getAttribute(key.toString());
            this.session.setAttribute(key.toString(), value);
            return originalValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            return this.session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.entries = null;
            Object value = this.get(key);
            this.session.removeAttribute(key.toString());
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            this.entries = null;
            this.session.invalidate();
        }
    }
}

